(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    329136,       5980]
NotebookOptionsPosition[    327818,       5943]
NotebookOutlinePosition[    328412,       5964]
CellTagsIndexPosition[    328369,       5961]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["", "Text",
 CellChangeTimes->{{3.8505675482933645`*^9, 3.8505675511099663`*^9}}],

Cell["", "Text",
 CellChangeTimes->{{3.8505674817413397`*^9, 3.850567491054656*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"N0", "=", 
   RowBox[{"10", "^", "3"}]}], ";", 
  RowBox[{"P0", "=", "160000"}], ";", 
  RowBox[{"EV", "=", 
   RowBox[{"-", "1"}]}], ";", 
  RowBox[{"kT", "=", "0.026"}], ";", 
  RowBox[{"Rs", "=", "0.1"}], ";", 
  RowBox[{"L", "=", 
   RowBox[{"10", "^", 
    RowBox[{"-", "5"}]}]}], ";", 
  RowBox[{"f", "=", "0.5"}], ";", " ", 
  RowBox[{"\[Theta]", "=", 
   RowBox[{"-", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Tau]e", "=", "0.5"}], ";", 
  RowBox[{"\[Tau]d", "=", "0.1"}], ";", " ", 
  RowBox[{"uv0", "=", 
   RowBox[{"-", "1"}]}], ";", 
  RowBox[{"uv1", "=", 
   RowBox[{"-", "0.1"}]}], ";", 
  RowBox[{"uvH", "=", 
   RowBox[{"-", "0.8"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Meq", "[", "u_", "]"}], ":=", 
  RowBox[{
   RowBox[{"2", "/", "3"}], "N0", " ", 
   RowBox[{"Abs", "[", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"u", "-", "EV"}], "kT"], ")"}], 
     RowBox[{"3", "/", "2"}]], "  ", "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cmu", "[", "u_", "]"}], ":=", 
  RowBox[{
   RowBox[{"N0", " ", "/", "kT"}], " ", 
   RowBox[{"Abs", "[", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"u", "-", "EV"}], "kT"], ")"}], 
     RowBox[{"1", "/", "2"}]], "  ", "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Idc", "[", "u_", "]"}], ":=", 
    RowBox[{
     RowBox[{"-", "\[Theta]"}], " ", 
     RowBox[{"L", "/", "\[Tau]e"}], " ", 
     RowBox[{"(", 
      RowBox[{"ND", " ", "-", 
       RowBox[{"Meq", "[", "u", "]"}]}], ")"}]}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Iu", " ", "curve"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"io1", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"uv", ",", 
       RowBox[{"Idc", "[", "uv", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"uv", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "10"}], ",", "10000"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\!\(\*SubscriptBox[\(u\), \(g\)]\) (V)\>\"", ",", 
          RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(d\)]\) (\[Mu]A)\>\"", ",", 
          RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
        ",", "\"\<\>\""}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3"}], ",", 
          RowBox[{"-", "2"}], ",", 
          RowBox[{"-", "1"}], ",", 
          RowBox[{"-", "0.5"}], ",", "0", ",", "0.5", ",", "1", ",", "2", ",",
           "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", 
          RowBox[{"-", "3"}], ",", 
          RowBox[{"-", "2"}], ",", 
          RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", "3"}], "}"}],
         ",", "None", ",", "None"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Gray"}], "}"}], 
       "}"}]}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "0.7"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"90", " ", "4`"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{"io1", ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3.5"}], ",", "3.5"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"BaseStyle", "->", 
     RowBox[{"{", 
      RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"io2", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"uv", ",", 
       RowBox[{
        RowBox[{"Meq", "[", "uv", "]"}], "/", "100000"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"uv", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "10"}], ",", "10000"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\!\(\*SubscriptBox[\(u\), \(g\)]\) (V)\>\"", ",", 
          RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\!\(\*SuperscriptBox[\(10\), \(-6\)]\) Z\>\"", ",", 
          RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
        ",", "\"\<\>\""}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3"}], ",", 
          RowBox[{"-", "2"}], ",", 
          RowBox[{"-", "1"}], ",", 
          RowBox[{"-", "0.5"}], ",", "0", ",", "0.5", ",", "1", ",", "2", ",",
           "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", 
          RowBox[{"-", "3"}], ",", 
          RowBox[{"-", "2"}], ",", 
          RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", "3"}], "}"}],
         ",", "None", ",", "None"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Green"}], "}"}], 
       "}"}]}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "0.7"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"90", " ", "4`"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"io3", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"uv", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"ND", "-", 
          RowBox[{"Meq", "[", "uv", "]"}]}], ")"}], "/", "100000"}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"uv", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "10"}], ",", "10000"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\!\(\*SubscriptBox[\(u\), \(g\)]\) (V)\>\"", ",", 
          RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(d\)]\) (\[Mu]A)\>\"", ",", 
          RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
        ",", "\"\<\>\""}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3"}], ",", 
          RowBox[{"-", "2"}], ",", 
          RowBox[{"-", "1"}], ",", 
          RowBox[{"-", "0.5"}], ",", "0", ",", "0.5", ",", "1", ",", "2", ",",
           "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", 
          RowBox[{"-", "3"}], ",", 
          RowBox[{"-", "2"}], ",", 
          RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", "3"}], "}"}],
         ",", "None", ",", "None"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Gray"}], "}"}], 
       "}"}]}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "0.7"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"90", " ", "4`"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{"io2", ",", "io3", ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "2"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"BaseStyle", "->", 
     RowBox[{"{", 
      RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.8390646611298313`*^9, 3.839064663549252*^9}, {
   3.8390651628201227`*^9, 3.8390651698744855`*^9}, {3.8390671245340233`*^9, 
   3.839067253968177*^9}, {3.8390672908692884`*^9, 3.8390673435588245`*^9}, {
   3.839067444277615*^9, 3.8390674530816755`*^9}, {3.839067483223913*^9, 
   3.8390676448632746`*^9}, {3.839067792030848*^9, 3.8390679296503277`*^9}, {
   3.839068035965031*^9, 3.8390681198292847`*^9}, {3.8390709139116144`*^9, 
   3.8390709421089935`*^9}, {3.83907099038449*^9, 3.8390709930117693`*^9}, {
   3.839071053413534*^9, 3.839071065617492*^9}, {3.839071142245447*^9, 
   3.8390712315177836`*^9}, {3.839071262559967*^9, 3.8390713000871944`*^9}, {
   3.8390714971122246`*^9, 3.839071517359198*^9}, {3.8390715485300074`*^9, 
   3.8390716200472517`*^9}, {3.8390716672806673`*^9, 3.839071782347397*^9}, {
   3.839071837937226*^9, 3.839071939311781*^9}, {3.839072168081314*^9, 
   3.839072168581891*^9}, {3.8390723168444653`*^9, 3.8390724465495067`*^9}, {
   3.8390724871236815`*^9, 3.839072628537404*^9}, {3.8390726857581015`*^9, 
   3.83907270608572*^9}, {3.8390728526632924`*^9, 3.8390730714112225`*^9}, {
   3.839082271666379*^9, 3.8390823055073657`*^9}, {3.839082353119522*^9, 
   3.839082449840514*^9}, {3.8390839765348864`*^9, 3.839084057466158*^9}, {
   3.8390840878065057`*^9, 3.8390841778809776`*^9}, {3.8390842363292522`*^9, 
   3.8390842982497163`*^9}, 3.83908433029414*^9, {3.8390843708346243`*^9, 
   3.8390844315092807`*^9}, 3.839084462612833*^9, {3.8390845298830824`*^9, 
   3.839084537171591*^9}, {3.8390846234607463`*^9, 3.839084639769829*^9}, {
   3.839085385972989*^9, 3.8390853976007433`*^9}, {3.8390854555897675`*^9, 
   3.839085524444199*^9}, {3.839085565738154*^9, 3.8390855920819826`*^9}, {
   3.8390863447286386`*^9, 3.839086474045252*^9}, {3.839086860852067*^9, 
   3.839086874816577*^9}, {3.839087637034748*^9, 3.8390876843714943`*^9}, 
   3.83908780285631*^9, 3.8390878367914057`*^9, {3.839088015231053*^9, 
   3.8390880802460375`*^9}, {3.839088241208177*^9, 3.839088251058446*^9}, 
   3.839088396382834*^9, 3.8391182307918463`*^9, {3.839118379381566*^9, 
   3.8391183868618546`*^9}, {3.839118542781612*^9, 3.839118576690755*^9}, {
   3.839119230679368*^9, 3.8391192435152392`*^9}, {3.8391193005384474`*^9, 
   3.839119322077612*^9}, {3.8391197370496492`*^9, 3.839119744561663*^9}, {
   3.839119780647091*^9, 3.8391198576053133`*^9}, {3.83913747847266*^9, 
   3.839137485481214*^9}, {3.8391375587687283`*^9, 3.8391375797199593`*^9}, {
   3.8391376276780567`*^9, 3.8391376620779104`*^9}, {3.83913835785732*^9, 
   3.839138374216883*^9}, 3.8391384110040264`*^9, {3.8391384624942074`*^9, 
   3.839138462879356*^9}, {3.8391385170099597`*^9, 3.839138536349577*^9}, {
   3.839139183554804*^9, 3.8391391930138044`*^9}, {3.8391393033973885`*^9, 
   3.8391393043613095`*^9}, 3.839139359067504*^9, 3.839139436240513*^9, {
   3.8392078031308994`*^9, 3.8392078143543434`*^9}, {3.8392078889566584`*^9, 
   3.83920790820275*^9}, {3.839208054761527*^9, 3.839208093399903*^9}, {
   3.8392084092575808`*^9, 3.8392084620514746`*^9}, 3.839208533536579*^9, {
   3.8392086070037084`*^9, 3.8392086083290124`*^9}, 3.8392086479255266`*^9, {
   3.8392225965883913`*^9, 3.8392226283136573`*^9}, {3.8392226646362276`*^9, 
   3.8392227421040397`*^9}, 3.8392227767756677`*^9, {3.8392228326927814`*^9, 
   3.839222892911393*^9}, 3.8392230743763013`*^9, {3.839223141092394*^9, 
   3.839223141783134*^9}, 3.839223177642132*^9, {3.8392232273840017`*^9, 
   3.8392232854596047`*^9}, {3.8392233573873816`*^9, 3.839223398790718*^9}, {
   3.8392234505961695`*^9, 3.839223507183962*^9}, {3.839223811017748*^9, 
   3.8392239510950837`*^9}, {3.8392240167007127`*^9, 3.839224025275307*^9}, {
   3.8392241057509785`*^9, 3.839224157437503*^9}, {3.839224200897134*^9, 
   3.8392242487597456`*^9}, {3.839224294917468*^9, 3.839224296013791*^9}, {
   3.8392243639841394`*^9, 3.8392243950383773`*^9}, 3.839224442185709*^9, {
   3.8392245129185476`*^9, 3.8392245373577056`*^9}, {3.8392245776385975`*^9, 
   3.839224740679908*^9}, {3.8392248367057567`*^9, 3.839224838004247*^9}, {
   3.8392249023255987`*^9, 3.8392249329681873`*^9}, 3.8392250078513308`*^9, {
   3.8392250461420965`*^9, 3.8392250567765236`*^9}, {3.8392250892690206`*^9, 
   3.839225128234888*^9}, {3.839225292837965*^9, 3.8392253052980237`*^9}, {
   3.839225374465659*^9, 3.839225378163327*^9}, {3.8392366608564453`*^9, 
   3.839236691352835*^9}, {3.839236736346908*^9, 3.8392367461057377`*^9}, {
   3.8392368452896976`*^9, 3.8392369245276327`*^9}, {3.8392369586763678`*^9, 
   3.839236989556669*^9}, {3.8392370210310707`*^9, 3.839237025639107*^9}, {
   3.8392370611832547`*^9, 3.839237143422812*^9}, {3.839237229917989*^9, 
   3.839237306453603*^9}, {3.8392373387206373`*^9, 3.839237342820054*^9}, {
   3.839237447098841*^9, 3.8392375543643665`*^9}, {3.8392411494009237`*^9, 
   3.839241171431179*^9}, {3.83924120627816*^9, 3.8392412247291117`*^9}, 
   3.8392412792201967`*^9, 3.8392413874247665`*^9, {3.8392415172512045`*^9, 
   3.8392415791894693`*^9}, {3.839241632182249*^9, 3.8392416472548246`*^9}, 
   3.8392418101230965`*^9, {3.839242047805271*^9, 3.8392420951804295`*^9}, {
   3.8392421670049934`*^9, 3.8392422247577305`*^9}, {3.8392422574679546`*^9, 
   3.8392422587095203`*^9}, {3.839242291908*^9, 3.8392425704347763`*^9}, {
   3.8392426617662134`*^9, 3.8392426717163734`*^9}, 3.839242785862258*^9, {
   3.839246817917405*^9, 3.8392468269690895`*^9}, {3.839246889891876*^9, 
   3.839246924816616*^9}, {3.839309996677757*^9, 3.839310018708186*^9}, {
   3.839310845764266*^9, 3.839310880859878*^9}, {3.839310926113166*^9, 
   3.839310949193386*^9}, {3.8393110019361973`*^9, 3.8393110308399534`*^9}, {
   3.8393270934512377`*^9, 3.839327332415727*^9}, {3.839327370226597*^9, 
   3.839327451303669*^9}, {3.8393275031436253`*^9, 3.8393275194960613`*^9}, {
   3.839327586008069*^9, 3.8393276948310633`*^9}, {3.8393278034898295`*^9, 
   3.8393278068680096`*^9}, {3.8393278450424776`*^9, 
   3.8393278797618237`*^9}, {3.8393289610021143`*^9, 3.839328976754302*^9}, {
   3.8393294967878103`*^9, 3.839329617607455*^9}, 3.8393297021511583`*^9, {
   3.839329736764967*^9, 3.83932973839811*^9}, {3.839329841358012*^9, 
   3.839329850076448*^9}, {3.8393298856244183`*^9, 3.83932990739045*^9}, {
   3.839330200791801*^9, 3.839330209464896*^9}, 3.83933026862875*^9, {
   3.8393304947792683`*^9, 3.839330614321838*^9}, {3.839330707456501*^9, 
   3.8393307223587484`*^9}, {3.8393307586469154`*^9, 3.839330774655125*^9}, {
   3.8393308208469334`*^9, 3.8393308254369345`*^9}, {3.83933092079788*^9, 
   3.8393310148602314`*^9}, {3.8393311745075006`*^9, 
   3.8393311994275675`*^9}, {3.8393312620131807`*^9, 
   3.8393312886598005`*^9}, {3.83933158528376*^9, 3.8393316720258255`*^9}, 
   3.8393317188850336`*^9, {3.8393317973728094`*^9, 3.8393319397094903`*^9}, 
   3.8393320294844685`*^9, {3.8393325727147913`*^9, 3.8393326007437224`*^9}, {
   3.839332643937569*^9, 3.8393326886712303`*^9}, {3.839332884251463*^9, 
   3.8393328849388123`*^9}, {3.8393329498885293`*^9, 3.839332954368989*^9}, 
   3.839332984548478*^9, {3.839333161836732*^9, 3.839333179429063*^9}, {
   3.839333212168277*^9, 3.8393332158859396`*^9}, {3.839333299885914*^9, 
   3.839333320058819*^9}, {3.8393333662749724`*^9, 3.839333389618166*^9}, 
   3.8393335815372777`*^9, {3.8393336646381135`*^9, 3.839333690640252*^9}, {
   3.839333816187891*^9, 3.839333852596138*^9}, {3.839333913143673*^9, 
   3.839333960953573*^9}, {3.8393340547869487`*^9, 3.839334137419753*^9}, {
   3.839420765475212*^9, 3.839420767706482*^9}, {3.839420800720344*^9, 
   3.83942080814257*^9}, {3.839420930166752*^9, 3.839420954611184*^9}, 
   3.839421093306271*^9, {3.839421249787591*^9, 3.8394213460868835`*^9}, {
   3.839421400152422*^9, 3.8394214417353144`*^9}, {3.839421483648677*^9, 
   3.839421580608614*^9}, 3.839421616079374*^9, 3.839422181142932*^9, {
   3.8394224472930202`*^9, 3.839422448371497*^9}, {3.8394225405886507`*^9, 
   3.839422541885687*^9}, {3.8394225839963813`*^9, 3.83942258751882*^9}, 
   3.8394239784679832`*^9, {3.8394240190394516`*^9, 3.8394240194005165`*^9}, {
   3.839481241680246*^9, 3.8394812636526537`*^9}, {3.8394813033197775`*^9, 
   3.839481343020226*^9}, {3.8394813886318493`*^9, 3.83948138904453*^9}, {
   3.8394814470082235`*^9, 3.8394815138762083`*^9}, {3.839484145142799*^9, 
   3.8394841575703464`*^9}, {3.8394842427712455`*^9, 
   3.8394842456191454`*^9}, {3.8394844396674995`*^9, 
   3.8394844660440836`*^9}, {3.8394845806487627`*^9, 3.83948460808449*^9}, {
   3.8394847191879005`*^9, 3.839484719920673*^9}, {3.8394847985864277`*^9, 
   3.8394847999498053`*^9}, {3.839485522225484*^9, 3.8394858614478054`*^9}, {
   3.8394858968609977`*^9, 3.8394858979280567`*^9}, {3.83950394022218*^9, 
   3.839504016595684*^9}, {3.839504079022719*^9, 3.8395041716366367`*^9}, {
   3.8395042475063295`*^9, 3.83950424807436*^9}, {3.8395043044033585`*^9, 
   3.8395043325148754`*^9}, {3.839504403912784*^9, 3.839504405955762*^9}, {
   3.839504461254238*^9, 3.8395044954062967`*^9}, {3.839504572085556*^9, 
   3.8395046258331623`*^9}, {3.839504718095887*^9, 3.839504733043982*^9}, {
   3.839504792704324*^9, 3.8395048214714227`*^9}, {3.8395048602645364`*^9, 
   3.839504871422516*^9}, {3.83950521161292*^9, 3.8395052235501237`*^9}, {
   3.839505255990897*^9, 3.8395052773582516`*^9}, {3.839505321851119*^9, 
   3.839505332451271*^9}, {3.8395054257374*^9, 3.8395054385582395`*^9}, 
   3.839505580972617*^9, {3.8395057025144815`*^9, 3.8395057031788645`*^9}, {
   3.8395057369934807`*^9, 3.8395057373979363`*^9}, {3.839505772294227*^9, 
   3.839505778367197*^9}, {3.83950673092721*^9, 3.8395067795192204`*^9}, {
   3.8395084122279215`*^9, 3.8395084138977666`*^9}, {3.839508448233049*^9, 
   3.8395084493422976`*^9}, {3.839508499051385*^9, 3.8395085344200335`*^9}, 
   3.8395086207285233`*^9, {3.8395086973952723`*^9, 3.8395086978689127`*^9}, {
   3.8395089696790757`*^9, 3.839509039224576*^9}, {3.8395100524490423`*^9, 
   3.839510053723009*^9}, {3.839511493807127*^9, 3.8395115089839754`*^9}, {
   3.8395115931589155`*^9, 3.839511633911852*^9}, {3.839511664551564*^9, 
   3.8395117021779413`*^9}, {3.839511738662855*^9, 3.8395117683886237`*^9}, {
   3.8395840465025244`*^9, 3.8395840478719764`*^9}, {3.8395842326636224`*^9, 
   3.8395842405526743`*^9}, {3.8395844072352886`*^9, 3.839584438590257*^9}, {
   3.839584539157859*^9, 3.839584558647271*^9}, {3.8395846133789663`*^9, 
   3.83958465811094*^9}, {3.839584785836444*^9, 3.839584807986281*^9}, 
   3.839586726652771*^9, {3.8395867995416994`*^9, 3.8395868420413933`*^9}, 
   3.83958688638865*^9, {3.839587244941451*^9, 3.83958726487414*^9}, {
   3.83958774293878*^9, 3.8395877838602095`*^9}, 3.839587828597546*^9, {
   3.839587879706158*^9, 3.8395879135449758`*^9}, {3.839587955043039*^9, 
   3.8395879642045746`*^9}, {3.8395880048781385`*^9, 3.839588051406326*^9}, {
   3.8395880883490973`*^9, 3.8395881594520197`*^9}, {3.8395882347911615`*^9, 
   3.8395883226336384`*^9}, 3.8395883559509153`*^9, 3.839588415451826*^9, {
   3.8395884902783833`*^9, 3.8395885216082554`*^9}, {3.8395941073926105`*^9, 
   3.8395942227438965`*^9}, 3.839595304916483*^9, {3.8395954862576475`*^9, 
   3.83959557521957*^9}, {3.839595607221432*^9, 3.8395956076140194`*^9}, {
   3.839595660820343*^9, 3.839595661835729*^9}, {3.839604650775865*^9, 
   3.8396046640054827`*^9}, {3.839604708532463*^9, 3.8396047629301977`*^9}, {
   3.839604795558606*^9, 3.839604808947177*^9}, {3.839604852056878*^9, 
   3.8396048690185547`*^9}, {3.839642088079403*^9, 3.839642141004441*^9}, {
   3.8396422800918975`*^9, 3.8396423077286944`*^9}, {3.8396424143783884`*^9, 
   3.8396424152236857`*^9}, {3.8396426095904264`*^9, 
   3.8396426100591545`*^9}, {3.8396426843268356`*^9, 3.8396426912164164`*^9}, 
   3.8396427676568155`*^9, {3.8396428549330425`*^9, 3.8396429650459213`*^9}, 
   3.839643049962629*^9, {3.839643091872772*^9, 3.8396431410841303`*^9}, 
   3.839643491656567*^9, {3.839643550041149*^9, 3.839643610060313*^9}, {
   3.8396436783391447`*^9, 3.8396437059963512`*^9}, {3.8396437389632745`*^9, 
   3.8396437448257093`*^9}, {3.839643793497415*^9, 3.8396438275668716`*^9}, {
   3.839643978745996*^9, 3.8396439798436737`*^9}, {3.839644021519642*^9, 
   3.8396440428152156`*^9}, {3.8396441695399504`*^9, 
   3.8396441971715937`*^9}, {3.839644230142295*^9, 3.8396442469945946`*^9}, {
   3.839644284692358*^9, 3.8396442961501245`*^9}, {3.8396443434969287`*^9, 
   3.8396443583914576`*^9}, {3.8396448346105194`*^9, 3.839644913123821*^9}, {
   3.8396555898716025`*^9, 3.839655650012109*^9}, {3.8396556822310605`*^9, 
   3.839655771771843*^9}, {3.839655952479162*^9, 3.8396559541084647`*^9}, 
   3.839656003389371*^9, {3.8396560347174463`*^9, 3.839656116850046*^9}, {
   3.8396562422855325`*^9, 3.8396562713341274`*^9}, 3.8396563271846943`*^9, {
   3.8396565529884825`*^9, 3.839656667985509*^9}, {3.8396568526250334`*^9, 
   3.839656873162519*^9}, {3.8396570321068354`*^9, 3.8396570367161813`*^9}, {
   3.8396571621919303`*^9, 3.839657193340761*^9}, {3.839657225174745*^9, 
   3.8396572442512493`*^9}, {3.8396572932236905`*^9, 3.8396572940165*^9}, 
   3.8396574072631903`*^9, {3.8396575476060143`*^9, 3.8396575682943974`*^9}, {
   3.839664138921971*^9, 3.839664156869915*^9}, 3.839664243007531*^9, {
   3.839669622125418*^9, 3.839669647884663*^9}, {3.839670002387182*^9, 
   3.839670025487237*^9}, {3.8396700586539392`*^9, 3.8396701085420904`*^9}, {
   3.8396766028729286`*^9, 3.839676603372811*^9}, {3.839676649783103*^9, 
   3.8396766681979322`*^9}, {3.839723206211033*^9, 3.839723252419324*^9}, {
   3.8397243192805915`*^9, 3.8397243622670403`*^9}, {3.839724526690404*^9, 
   3.8397245565593586`*^9}, 3.839724591814554*^9, {3.8397246526353917`*^9, 
   3.8397246677187424`*^9}, {3.839724698665658*^9, 3.8397248461537275`*^9}, {
   3.839724910156172*^9, 3.839724969029936*^9}, {3.839725029399225*^9, 
   3.839725070375955*^9}, {3.8397257491640964`*^9, 3.8397258148584566`*^9}, {
   3.839726205531111*^9, 3.839726226304987*^9}, {3.839726314389023*^9, 
   3.8397264887181263`*^9}, {3.8397266355093994`*^9, 
   3.8397266356472826`*^9}, {3.839727069639051*^9, 3.83972707062368*^9}, {
   3.8397274615058823`*^9, 3.839727481527841*^9}, {3.83972755827617*^9, 
   3.8397275594724007`*^9}, {3.839727857737072*^9, 3.83972788618902*^9}, 
   3.8397281801577473`*^9, {3.839741406815917*^9, 3.839741648719699*^9}, 
   3.839741694966459*^9, {3.8397417738301263`*^9, 3.8397417740488653`*^9}, 
   3.839742014559319*^9, {3.8397421882027674`*^9, 3.839742188943444*^9}, {
   3.8397589658528605`*^9, 3.83975903164762*^9}, {3.839759582024466*^9, 
   3.8397596437148447`*^9}, {3.8397597378135786`*^9, 3.839759770277839*^9}, {
   3.839760042248042*^9, 3.8397600434337606`*^9}, {3.839760792865179*^9, 
   3.839760817913896*^9}, {3.8397655048182044`*^9, 3.839765505036851*^9}, {
   3.839765649791177*^9, 3.839765680039174*^9}, {3.839765730951825*^9, 
   3.8397657438209515`*^9}, {3.8397658325268707`*^9, 3.839765870890603*^9}, {
   3.8397695336031294`*^9, 3.8397695785421767`*^9}, 3.839769610638837*^9, {
   3.839769642999297*^9, 3.8397696900062704`*^9}, {3.8397697294324865`*^9, 
   3.839769753667972*^9}, 3.839770624201335*^9, {3.8399858643515997`*^9, 
   3.839985870106961*^9}, {3.8399859073530426`*^9, 3.83998590778368*^9}, {
   3.839986665758301*^9, 3.839986671600184*^9}, {3.840015477117873*^9, 
   3.840015532633871*^9}, {3.840262190474472*^9, 3.8402621922160215`*^9}, {
   3.8402622512898836`*^9, 3.8402623158498154`*^9}, {3.840262346847395*^9, 
   3.840262361938197*^9}, {3.8402624446884875`*^9, 3.840262497278998*^9}, {
   3.8402625593196363`*^9, 3.840262562846277*^9}, {3.840262654524027*^9, 
   3.8402626673364897`*^9}, {3.8402800661176753`*^9, 3.840280138278593*^9}, {
   3.840280177703832*^9, 3.840280189480773*^9}, {3.8402802324576406`*^9, 
   3.8402802331825943`*^9}, {3.8402812754975386`*^9, 3.840281326464582*^9}, 
   3.8402813946519136`*^9, {3.84028186111417*^9, 3.8402818954912634`*^9}, {
   3.8402819964993353`*^9, 3.8402819971437144`*^9}, {3.840330466229367*^9, 
   3.8403304972505484`*^9}, 3.8403305401374164`*^9, 3.840330628649666*^9, {
   3.8403306672934227`*^9, 3.8403306802026963`*^9}, {3.8403307193320885`*^9, 
   3.840330758272279*^9}, 3.8403307967908325`*^9, 3.8403308358680725`*^9, {
   3.840330872410847*^9, 3.8403308786837*^9}, {3.8403309221453967`*^9, 
   3.840330944340696*^9}, 3.840330989285677*^9, {3.840331109810131*^9, 
   3.840331153164013*^9}, {3.840331431580937*^9, 3.8403314406879196`*^9}, {
   3.8403317789283185`*^9, 3.840331780542934*^9}, {3.840331813886128*^9, 
   3.8403318320633073`*^9}, {3.8403318821336937`*^9, 
   3.8403318897950106`*^9}, {3.8403319357741313`*^9, 
   3.8403319411825953`*^9}, {3.8403320129500637`*^9, 
   3.8403321277278547`*^9}, {3.840332221075777*^9, 3.8403322212632327`*^9}, {
   3.8404162792747984`*^9, 3.8404162803058043`*^9}, {3.840416344690134*^9, 
   3.8404163448306866`*^9}, {3.8404178626090136`*^9, 3.840417925824424*^9}, {
   3.8404191918191233`*^9, 3.84041920226635*^9}, {3.840419242024495*^9, 
   3.8404192617321796`*^9}, {3.8404194389428053`*^9, 3.840419462557069*^9}, {
   3.840453834266838*^9, 3.8404538447517056`*^9}, 3.840453909614043*^9, {
   3.8404539683635793`*^9, 3.8404539905838337`*^9}, 3.8404540272985306`*^9, {
   3.840454156166298*^9, 3.840454205291971*^9}, {3.840454240247527*^9, 
   3.8404542540157146`*^9}, {3.8404543237333283`*^9, 
   3.8404543404928937`*^9}, {3.8404544521143074`*^9, 
   3.8404544541302176`*^9}, {3.840454485008524*^9, 3.8404544958331428`*^9}, {
   3.840454535970628*^9, 3.840454551137659*^9}, {3.840500625089159*^9, 
   3.840500656940725*^9}, {3.840500695345143*^9, 3.8405006960523067`*^9}, {
   3.8405010969852047`*^9, 3.840501112587641*^9}, {3.840501150634077*^9, 
   3.8405011611522417`*^9}, {3.8405026446645527`*^9, 3.84050265267775*^9}, 
   3.8405026878215275`*^9, 3.8405027886745453`*^9, {3.8405028323157024`*^9, 
   3.8405028521056433`*^9}, {3.840508597751215*^9, 3.8405086042448597`*^9}, {
   3.8405086361734276`*^9, 3.840508697640854*^9}, {3.84530515034306*^9, 
   3.8453051663199177`*^9}, 3.845305197884505*^9, {3.8454792808354254`*^9, 
   3.8454794150956697`*^9}, {3.845479722113243*^9, 3.8454797915964413`*^9}, {
   3.845514873929638*^9, 3.8455149337268724`*^9}, {3.8455149684706416`*^9, 
   3.8455149695080223`*^9}, {3.8455153275220933`*^9, 3.845515328229957*^9}, {
   3.845515395675539*^9, 3.845515401297691*^9}, {3.845515515853771*^9, 
   3.845515576447665*^9}, {3.845515612558851*^9, 3.845515632979537*^9}, {
   3.845515680153039*^9, 3.8455159262376585`*^9}, {3.845516112061887*^9, 
   3.8455161465263453`*^9}, {3.845516193085106*^9, 3.845516229178423*^9}, {
   3.8455163351689043`*^9, 3.845516585318216*^9}, {3.8455166177397394`*^9, 
   3.845516714733508*^9}, {3.845516771645197*^9, 3.8455167731827154`*^9}, {
   3.845516818729296*^9, 3.84551695860878*^9}, {3.845516994711903*^9, 
   3.845517026462266*^9}, 3.845517092145789*^9, {3.845517135366593*^9, 
   3.845517155446496*^9}, {3.845517186534149*^9, 3.8455171937276707`*^9}, {
   3.845517227012909*^9, 3.8455172279061613`*^9}, {3.8455173234132085`*^9, 
   3.8455173514857492`*^9}, {3.845517423730919*^9, 3.8455174243493695`*^9}, {
   3.8455174624069753`*^9, 3.845517465100626*^9}, 3.845517507705373*^9, 
   3.8455175508535676`*^9, {3.8455176264044795`*^9, 3.8455176334075813`*^9}, {
   3.8455313319229393`*^9, 3.845531509940443*^9}, 3.8455315849840965`*^9, {
   3.8455317016782956`*^9, 3.845531738966821*^9}, {3.845531778451456*^9, 
   3.845531779386674*^9}, {3.8456415428113813`*^9, 3.845641735457308*^9}, {
   3.8456420427094593`*^9, 3.8456420444008894`*^9}, {3.8456420953927226`*^9, 
   3.845642095827136*^9}, {3.8456421305858717`*^9, 3.8456422084386454`*^9}, 
   3.8456422719473834`*^9, {3.8456424654126687`*^9, 3.8456424685516415`*^9}, {
   3.8456425391271963`*^9, 3.845642581942461*^9}, {3.8456426396045694`*^9, 
   3.845642806094469*^9}, {3.845642836196087*^9, 3.845642900922883*^9}, {
   3.845642970285206*^9, 3.8456430181273146`*^9}, {3.8456430708546114`*^9, 
   3.845643125882959*^9}, {3.845643178575968*^9, 3.845643257358486*^9}, {
   3.8456433623862553`*^9, 3.8456433771042914`*^9}, {3.8456434590863156`*^9, 
   3.8456434937160645`*^9}, 3.845643545927831*^9, {3.845643600156926*^9, 
   3.845643618570978*^9}, {3.8456436644300175`*^9, 3.84564366503797*^9}, {
   3.845643702197648*^9, 3.8456437461979747`*^9}, 3.8456439574887114`*^9, {
   3.846069818172841*^9, 3.846069849642768*^9}, {3.8460699136765876`*^9, 
   3.846069914209477*^9}, {3.8460699599440656`*^9, 3.8460700314146757`*^9}, {
   3.846070076753316*^9, 3.846070077439046*^9}, {3.846070157661101*^9, 
   3.8460701937707815`*^9}, {3.846070258127372*^9, 3.846070370035694*^9}, 
   3.8460704231130123`*^9, {3.846070456017062*^9, 3.8460704588184586`*^9}, {
   3.8460710172041235`*^9, 3.846071021582673*^9}, {3.846071106666136*^9, 
   3.8460711227728405`*^9}, {3.846071236516765*^9, 3.8460712690613956`*^9}, {
   3.846071302508814*^9, 3.8460713286265783`*^9}, {3.846071391711331*^9, 
   3.8460713919222136`*^9}, {3.8460717432565613`*^9, 3.846071846163582*^9}, {
   3.8460718796339417`*^9, 3.8460718981181345`*^9}, {3.8460719281852317`*^9, 
   3.8460719602156863`*^9}, {3.8460725487311463`*^9, 
   3.8460727277222366`*^9}, {3.8460727966336946`*^9, 
   3.8460727999447126`*^9}, {3.8460728715731387`*^9, 3.846072900231036*^9}, 
   3.8460729488995743`*^9, 3.846073094187673*^9, {3.846073124968068*^9, 
   3.846073143649494*^9}, {3.846073291437569*^9, 3.846073320871194*^9}, {
   3.8460733513356*^9, 3.8460733827836275`*^9}, {3.8460734213260293`*^9, 
   3.846073547913215*^9}, {3.8460735888598585`*^9, 3.8460735948494663`*^9}, {
   3.8460736630482445`*^9, 3.84607366906472*^9}, {3.846073769039547*^9, 
   3.8460738022300262`*^9}, {3.8460738788770266`*^9, 
   3.8460738952181954`*^9}, {3.846073949966679*^9, 3.8460739569065495`*^9}, {
   3.846074029073464*^9, 3.8460740346596146`*^9}, {3.846074102104647*^9, 
   3.8460741324118767`*^9}, {3.8460741949049115`*^9, 3.846074222593691*^9}, {
   3.8460742841895127`*^9, 3.846074340763191*^9}, {3.846160732253354*^9, 
   3.8461607332481594`*^9}, 3.846161492762432*^9, {3.846161780897497*^9, 
   3.846161788138113*^9}, {3.8461618293598766`*^9, 3.846161858226082*^9}, {
   3.8461618966585674`*^9, 3.846161969794857*^9}, 3.846162102689354*^9, {
   3.8461621668466263`*^9, 3.846162180355235*^9}, {3.8461622164826603`*^9, 
   3.8461622355856447`*^9}, {3.846162281065609*^9, 3.8461624985309367`*^9}, 
   3.8461626621493115`*^9, 3.846162697816634*^9, {3.8461627342864695`*^9, 
   3.8461627345822268`*^9}, {3.8461628166006966`*^9, 3.8461628174265194`*^9}, 
   3.846162849529516*^9, 3.846163042718745*^9, {3.8461630926561747`*^9, 
   3.8461631014520173`*^9}, 3.846164675187914*^9, {3.8461653709571285`*^9, 
   3.8461653939322076`*^9}, {3.846239297565034*^9, 3.846239321709072*^9}, {
   3.8462393704866405`*^9, 3.846239378462596*^9}, 3.8462394463604927`*^9, {
   3.846239908200873*^9, 3.846240041118046*^9}, {3.8462400979595313`*^9, 
   3.8462402075029526`*^9}, {3.846240330599819*^9, 3.846240332116249*^9}, {
   3.846240396409835*^9, 3.846240426609739*^9}, {3.8462404635946035`*^9, 
   3.846240479194495*^9}, {3.846240547126852*^9, 3.8462406007711906`*^9}, {
   3.846240672984129*^9, 3.8462406735655537`*^9}, {3.846240715451014*^9, 
   3.846240727662325*^9}, {3.8462408398048706`*^9, 3.8462408550133176`*^9}, {
   3.846240906219432*^9, 3.8462409845731764`*^9}, {3.8462415426024213`*^9, 
   3.846241600241384*^9}, {3.8462416533016524`*^9, 3.8462416824345474`*^9}, {
   3.846241871443136*^9, 3.846241889026347*^9}, {3.84624196622915*^9, 
   3.846241982209696*^9}, {3.8462420839315395`*^9, 3.8462421106657743`*^9}, {
   3.8462493213059616`*^9, 3.846249371505189*^9}, {3.846249426216957*^9, 
   3.8462494677076874`*^9}, {3.846249549506504*^9, 3.8462495503135986`*^9}, {
   3.8463317012472258`*^9, 3.846331723789422*^9}, 3.846331790148814*^9, {
   3.846331841946804*^9, 3.8463318642788124`*^9}, {3.8463318999649568`*^9, 
   3.84633190085021*^9}, {3.846331970187175*^9, 3.8463319724350276`*^9}, {
   3.846332425994608*^9, 3.8463324267831564`*^9}, {3.8463324853767433`*^9, 
   3.846332505743512*^9}, {3.84633253640195*^9, 3.84633253746087*^9}, 
   3.8463325927468147`*^9, {3.846332664076268*^9, 3.84633267729871*^9}, {
   3.84633282094595*^9, 3.846332866648316*^9}, {3.846332915983061*^9, 
   3.846332964772069*^9}, {3.8463332315659857`*^9, 3.8463332589840655`*^9}, {
   3.8463333159368706`*^9, 3.8463333881232243`*^9}, {3.846333478174964*^9, 
   3.846333507307977*^9}, {3.8463337169753866`*^9, 3.846333752677167*^9}, {
   3.8463337874930525`*^9, 3.8463337938266315`*^9}, {3.84633382889653*^9, 
   3.8463338314544067`*^9}, {3.8463338661347585`*^9, 
   3.8463338671064034`*^9}, {3.8463341029946103`*^9, 3.8463341178046017`*^9}, 
   3.8463344961508446`*^9, {3.846334551477289*^9, 3.8463345669722776`*^9}, {
   3.846334647851037*^9, 3.8463346507709723`*^9}, {3.8463350072556896`*^9, 
   3.846335009531336*^9}, {3.8463350584383993`*^9, 3.8463350832915545`*^9}, 
   3.8463356730391445`*^9, {3.8463357330577507`*^9, 3.846335734677639*^9}, {
   3.8463357713912954`*^9, 3.846335784599365*^9}, {3.846335824451017*^9, 
   3.846335850541898*^9}, {3.8465148279290648`*^9, 3.846514905645626*^9}, {
   3.8465149546536207`*^9, 3.8465149557287645`*^9}, 3.8465150347627506`*^9, 
   3.8465150735123754`*^9, 3.846515133355834*^9, {3.846551496354246*^9, 
   3.8465515199215117`*^9}, {3.8465515514860935`*^9, 3.846551558453719*^9}, {
   3.8465516511605453`*^9, 3.8465516816971188`*^9}, {3.8465517493251767`*^9, 
   3.8465517819787836`*^9}, {3.846551812162984*^9, 3.84655181978378*^9}, {
   3.8469012753631597`*^9, 3.8469014245266294`*^9}, {3.846901477101201*^9, 
   3.846901480891117*^9}, 3.846901533852523*^9, {3.8469015653056993`*^9, 
   3.8469015942691755`*^9}, 3.8469016260053563`*^9, {3.846901664939994*^9, 
   3.8469016657155457`*^9}, {3.846901747509447*^9, 3.8469017503170366`*^9}, {
   3.84690191404624*^9, 3.84690193970901*^9}, 3.846901985149589*^9, {
   3.84690203255608*^9, 3.8469020373058805`*^9}, {3.8469021528510695`*^9, 
   3.84690220430954*^9}, {3.8469022448931456`*^9, 3.8469022504597807`*^9}, {
   3.846902285388745*^9, 3.846902288603936*^9}, {3.8469023384879513`*^9, 
   3.846902371933584*^9}, 3.846902765731144*^9, {3.8469028332433987`*^9, 
   3.8469028443561935`*^9}, 3.8469030843801355`*^9, 3.846903160980903*^9, {
   3.8469032059828815`*^9, 3.8469032390870132`*^9}, {3.84690342310567*^9, 
   3.846903439207902*^9}, {3.8469061580301685`*^9, 3.8469062645476227`*^9}, {
   3.8469065486448135`*^9, 3.846906561548581*^9}, {3.8469067471371455`*^9, 
   3.8469068174896765`*^9}, {3.84690686154051*^9, 3.8469068684523077`*^9}, {
   3.8497527618146653`*^9, 3.8497527676380615`*^9}, {3.8497528414079475`*^9, 
   3.849752843454638*^9}, {3.8497530625145917`*^9, 3.849753063032662*^9}, {
   3.8497530971084747`*^9, 3.8497531011988783`*^9}, {3.8497532258666143`*^9, 
   3.849753345755213*^9}, {3.849753924288494*^9, 3.849753985952464*^9}, {
   3.849754069460248*^9, 3.849754087001464*^9}, {3.849754259204835*^9, 
   3.849754268999332*^9}, {3.8497554284565487`*^9, 3.8497554930272894`*^9}, {
   3.849755685279069*^9, 3.8497556896240177`*^9}, {3.8497558773614607`*^9, 
   3.849755877843891*^9}, {3.8497559807269473`*^9, 3.8497560211165953`*^9}, 
   3.850443650520732*^9, {3.8504438404083548`*^9, 3.8504441120345283`*^9}, {
   3.850444156664489*^9, 3.850444280967318*^9}, {3.850444354744196*^9, 
   3.85044463643923*^9}, {3.8504447256702757`*^9, 3.8504447980665684`*^9}, {
   3.8505274395909743`*^9, 3.8505274411181674`*^9}, {3.8505275310510144`*^9, 
   3.8505276349685197`*^9}, {3.850527665564816*^9, 3.850527741150744*^9}, {
   3.850528010969228*^9, 3.8505280914370484`*^9}, {3.850528341539154*^9, 
   3.8505283435766478`*^9}, {3.850528399268195*^9, 3.850528452926201*^9}, {
   3.850528511901552*^9, 3.850528524032834*^9}, {3.8505286008142643`*^9, 
   3.8505286255862675`*^9}, {3.850528657292616*^9, 3.8505287485299587`*^9}, {
   3.850528791091945*^9, 3.8505287912193995`*^9}, {3.8505289892778673`*^9, 
   3.8505290093703814`*^9}, {3.8505291179397283`*^9, 3.850529246368305*^9}, {
   3.8505292847200036`*^9, 3.8505293531238484`*^9}, {3.85052942526715*^9, 
   3.8505295026053452`*^9}, {3.850529652810694*^9, 3.85052969888447*^9}, {
   3.8505297570230837`*^9, 3.8505297793908668`*^9}, {3.8505298130474796`*^9, 
   3.85052982372943*^9}, 3.850529903643921*^9, {3.8505299339680395`*^9, 
   3.850529938523468*^9}, {3.850533467746894*^9, 3.850533696587976*^9}, {
   3.8505337523084393`*^9, 3.8505340100220647`*^9}, {3.850534073301394*^9, 
   3.8505341115212436`*^9}, {3.8505341448690495`*^9, 3.850534244609003*^9}, {
   3.8505342773409953`*^9, 3.850534317485276*^9}, {3.850534376818581*^9, 
   3.8505345375059347`*^9}, 3.8505345895823593`*^9, {3.850534712936541*^9, 
   3.850534853983102*^9}, {3.85053489565536*^9, 3.85053490800423*^9}, {
   3.850535011630887*^9, 3.850535069369616*^9}, {3.8505609789941187`*^9, 
   3.8505609796472797`*^9}, {3.850561024378234*^9, 3.8505611077291512`*^9}, {
   3.8505611554662695`*^9, 3.8505611900834045`*^9}, {3.8505612604815354`*^9, 
   3.850561307036023*^9}, 3.8505614161973686`*^9, {3.850561489892841*^9, 
   3.8505614904828854`*^9}, 3.850561540476676*^9, {3.850566961415826*^9, 
   3.85056699607444*^9}, {3.8505670465401917`*^9, 3.850567067268143*^9}, {
   3.850567124561453*^9, 3.8505671481746936`*^9}, {3.8505671891195374`*^9, 
   3.850567192972233*^9}, {3.8505672404233675`*^9, 3.850567272319547*^9}, {
   3.8505673802869396`*^9, 3.850567388289441*^9}, {3.850567420051065*^9, 
   3.8505674379775977`*^9}, {3.850568113924102*^9, 3.850568121245113*^9}, {
   3.8505681786419373`*^9, 3.8505682190225987`*^9}, {3.8505682742836356`*^9, 
   3.8505682972999997`*^9}, {3.850568330443387*^9, 3.8505683415549088`*^9}, {
   3.850568377492758*^9, 3.850568403154665*^9}, {3.850568837097434*^9, 
   3.850568946787299*^9}, {3.8505691453292117`*^9, 3.850569195539899*^9}, {
   3.8505692859376397`*^9, 3.8505693669331837`*^9}, {3.8505693974289236`*^9, 
   3.8505695475039663`*^9}, {3.8505696079724298`*^9, 
   3.8505696221275873`*^9}, {3.8505697874854712`*^9, 
   3.8505698175396166`*^9}, {3.850569868969412*^9, 3.8505698726296372`*^9}, {
   3.850569905926787*^9, 3.8505699809036593`*^9}, {3.850570015920215*^9, 
   3.85057008172045*^9}, {3.850785556912866*^9, 3.850785616614393*^9}, {
   3.8507856606466494`*^9, 3.850785723209618*^9}, {3.8507857656066175`*^9, 
   3.850785880874487*^9}, {3.850785924508508*^9, 3.850785937300992*^9}, {
   3.8507859750545197`*^9, 3.8507859968100834`*^9}, {3.850786077342246*^9, 
   3.8507860848236823`*^9}, {3.8507861340867023`*^9, 3.8507861374599075`*^9}, 
   3.850786227982345*^9, {3.8507862859910107`*^9, 3.8507863008387175`*^9}, {
   3.850786368316942*^9, 3.850786374976062*^9}, {3.850786423270744*^9, 
   3.850786423425295*^9}, {3.8507865491264324`*^9, 3.850786595976322*^9}, {
   3.850786636570469*^9, 3.850786709325587*^9}, {3.850786743990263*^9, 
   3.8507868015086374`*^9}, {3.8507870134211025`*^9, 
   3.8507870176048164`*^9}, {3.850787059141889*^9, 3.8507870650224657`*^9}, {
   3.850787111878257*^9, 3.850787113157389*^9}, {3.8507887599989805`*^9, 
   3.850788841851822*^9}, {3.850788913491912*^9, 3.8507890311085014`*^9}, {
   3.8507890809695005`*^9, 3.8507890902738066`*^9}, {3.8507891921970196`*^9, 
   3.8507891973037043`*^9}, {3.8507892279462795`*^9, 3.850789249495205*^9}, {
   3.850791412876636*^9, 3.8507914130273633`*^9}, {3.8507915155633483`*^9, 
   3.8507915162424593`*^9}, {3.850827343188859*^9, 3.850827375432101*^9}, {
   3.8508274109868975`*^9, 3.8508274369062905`*^9}, {3.8508274890786314`*^9, 
   3.8508274894138756`*^9}, {3.8508275695516253`*^9, 3.850827569788695*^9}, 
   3.8508276711587315`*^9, {3.8508277166165743`*^9, 3.8508277728386536`*^9}, {
   3.8508278475513325`*^9, 3.8508278753498926`*^9}, {3.8508279408872223`*^9, 
   3.85082794118405*^9}, {3.850827981298354*^9, 3.850828056921221*^9}, {
   3.850828494113824*^9, 3.850828495039543*^9}, {3.85082856023905*^9, 
   3.850828575017256*^9}, {3.850828628892047*^9, 3.850828696248144*^9}, 
   3.8508287630158415`*^9, {3.8508293694951773`*^9, 3.850829372071825*^9}, {
   3.8508294221130056`*^9, 3.8508294474505587`*^9}, {3.8508295136154523`*^9, 
   3.850829546786518*^9}, {3.8508307551495695`*^9, 3.850830755305548*^9}, {
   3.850830846425475*^9, 3.8508308469949007`*^9}, {3.8508328226756153`*^9, 
   3.8508328956454206`*^9}, {3.8515151599360895`*^9, 
   3.8515151854097323`*^9}, {3.851515227511881*^9, 3.8515152691971846`*^9}, {
   3.8517376565999703`*^9, 3.851737660729647*^9}, {3.8517376993937993`*^9, 
   3.851737854226467*^9}, {3.8517379030659018`*^9, 3.851737963592141*^9}, {
   3.8517380004040184`*^9, 3.851738156849004*^9}, {3.8517381881441555`*^9, 
   3.8517383547150526`*^9}, {3.851738403578961*^9, 3.8517384750343685`*^9}, {
   3.8517386329884996`*^9, 3.8517387036807384`*^9}, {3.8517387496128297`*^9, 
   3.8517391066461697`*^9}, 3.851739167106615*^9, {3.851739199324179*^9, 
   3.8517392033202653`*^9}, {3.851739306865944*^9, 3.8517396012506447`*^9}, {
   3.8517396478337793`*^9, 3.851739717012961*^9}, {3.851739779861041*^9, 
   3.8517398251446857`*^9}, {3.8517401674121*^9, 3.85174023031291*^9}, {
   3.8517403822763968`*^9, 3.8517405215277195`*^9}, {3.8517405598035936`*^9, 
   3.8517405807347307`*^9}, 3.8517406111741548`*^9, {3.852771815388609*^9, 
   3.852771815826337*^9}, {3.852771938933034*^9, 3.852772015527173*^9}, {
   3.8527720455326405`*^9, 3.852772051655347*^9}, {3.852772112575083*^9, 
   3.85277216712604*^9}, {3.8527722639917727`*^9, 3.8527723193930345`*^9}, {
   3.8527723507994275`*^9, 3.8527724886441803`*^9}, 3.852772518958836*^9, {
   3.8527726690962496`*^9, 3.8527726724595623`*^9}, {3.852772785224839*^9, 
   3.852772814059412*^9}, {3.8527728536940055`*^9, 3.8527728543197746`*^9}, 
   3.8527728940919833`*^9, {3.8527729250196114`*^9, 3.8527729905347033`*^9}, {
   3.8527730490675783`*^9, 3.8527730529881525`*^9}, {3.852773399558672*^9, 
   3.852773411256092*^9}, {3.852773459331044*^9, 3.852773480723246*^9}, {
   3.8527735251577444`*^9, 3.8527735647772226`*^9}, {3.85277372440212*^9, 
   3.852773727144375*^9}, {3.8528731960002193`*^9, 3.8528733256878357`*^9}, {
   3.852873387704274*^9, 3.852873409884766*^9}, {3.8528734508562613`*^9, 
   3.8528734515817213`*^9}, {3.8528734901873713`*^9, 3.852873528186962*^9}, {
   3.8528735614708843`*^9, 3.8528735812376013`*^9}, {3.8528736531146784`*^9, 
   3.852873677620881*^9}, {3.8528801200331235`*^9, 3.852880146194016*^9}, {
   3.853140879673688*^9, 3.8531409143592653`*^9}, {3.8531409625201416`*^9, 
   3.8531410288764524`*^9}, {3.8531410590292354`*^9, 
   3.8531411087537766`*^9}, {3.906960081539485*^9, 3.9069602331152077`*^9}, {
   3.9069603433707557`*^9, 3.906960532270595*^9}, {3.9069608107416534`*^9, 
   3.906960894501176*^9}, 3.906976975428384*^9, 3.9069784461360517`*^9, {
   3.9069784939955707`*^9, 3.906978495519633*^9}, {3.906979520056976*^9, 
   3.906979527909192*^9}, {3.9070299969708767`*^9, 3.9070299973647575`*^9}, 
   3.9070302622793455`*^9, {3.907031054878291*^9, 3.907031101672268*^9}, {
   3.907031132657627*^9, 3.907031137965227*^9}, {3.907031258015709*^9, 
   3.907031258244317*^9}, 3.907060462885079*^9, {3.9070616210919228`*^9, 
   3.9070617379829817`*^9}, {3.9070618359373693`*^9, 
   3.9070618491419787`*^9}, {3.9072168098312087`*^9, 
   3.9072168879034996`*^9}, {3.9072169598535347`*^9, 
   3.9072169971857233`*^9}, {3.9072170607219973`*^9, 3.907217066892645*^9}, {
   3.9076577595519457`*^9, 3.9076578173877373`*^9}, {3.9076578614233837`*^9, 
   3.907657894347175*^9}, {3.9076579602806206`*^9, 3.9076579846181087`*^9}, {
   3.9076596607447786`*^9, 3.9076596756372747`*^9}, {3.912649758684204*^9, 
   3.912649760833685*^9}, {3.912649837259575*^9, 3.912649848570344*^9}, {
   3.9126499517854204`*^9, 3.912649970892383*^9}, 3.912650059947663*^9, {
   3.9126500901878223`*^9, 3.912650090409895*^9}, 3.9126501210930157`*^9, {
   3.912650161299636*^9, 3.912650195770377*^9}, {3.9126502444052167`*^9, 
   3.912650249087671*^9}, {3.9126503503333225`*^9, 3.9126504621854153`*^9}, 
   3.9126506010978127`*^9, 3.912650669840725*^9, {3.912768414775481*^9, 
   3.912768499461568*^9}, {3.912768532787694*^9, 3.9127685546208143`*^9}, {
   3.912769054075884*^9, 3.912769202942466*^9}, {3.91276928130552*^9, 
   3.9127693421278896`*^9}, {3.9127693895200415`*^9, 3.91276939347456*^9}, {
   3.912769449251079*^9, 3.9127695130058765`*^9}, {3.9127695460304613`*^9, 
   3.912769637406728*^9}, {3.912769672995297*^9, 3.912769683695554*^9}, {
   3.9127699655129433`*^9, 3.9127702032882056`*^9}, {3.912770296658707*^9, 
   3.9127703175743523`*^9}, {3.912770427094532*^9, 3.91277044594245*^9}, 
   3.9127705303609056`*^9, {3.912770571895234*^9, 3.9127706020178995`*^9}, {
   3.9127706486135855`*^9, 3.9127706716451917`*^9}, {3.912770711413762*^9, 
   3.912770754484521*^9}, {3.9127708044063478`*^9, 3.9127708106291575`*^9}, {
   3.9127708503988996`*^9, 3.912770864756321*^9}, {3.9127709027091455`*^9, 
   3.912770959220462*^9}, {3.9127709899464912`*^9, 3.9127710660360575`*^9}, {
   3.9128198078072987`*^9, 3.912820031509515*^9}, {3.91282006827859*^9, 
   3.9128201061755395`*^9}, {3.9128201414506645`*^9, 
   3.9128202576441517`*^9}, {3.912820301485941*^9, 3.912820302036003*^9}, {
   3.91282118902829*^9, 3.912821200535576*^9}, {3.9128212987625976`*^9, 
   3.9128212997021604`*^9}, {3.9128213384189405`*^9, 3.912821339532572*^9}, {
   3.91380808097643*^9, 3.9138080914374475`*^9}, {3.913808133264759*^9, 
   3.9138081867755365`*^9}, {3.9138082503482437`*^9, 
   3.9138082841458397`*^9}, {3.9138085090926466`*^9, 3.913808519144635*^9}, {
   3.913944174749754*^9, 3.9139442412817116`*^9}, {3.9139443551487813`*^9, 
   3.913944355512908*^9}, {3.9139446795397243`*^9, 3.9139447171058693`*^9}, {
   3.913944750208041*^9, 3.9139447589918194`*^9}, {3.913944789150079*^9, 
   3.9139448749836483`*^9}, {3.9139449239924626`*^9, 
   3.9139449441650796`*^9}, {3.9139587224296885`*^9, 
   3.9139587446201954`*^9}, {3.9139588142087173`*^9, 3.913958817747795*^9}, {
   3.91395894456537*^9, 3.9139589457330937`*^9}, {3.9139590071767883`*^9, 
   3.9139590074760413`*^9}, 3.9139751840757055`*^9, {3.9139805254478717`*^9, 
   3.913980527285986*^9}, {3.914061651207717*^9, 3.9140616728059535`*^9}, {
   3.9143019528100643`*^9, 3.914302017740336*^9}, {3.914636108138605*^9, 
   3.914636116823386*^9}, {3.919138938697628*^9, 3.919139014338743*^9}, {
   3.919139150904415*^9, 3.9191391637002487`*^9}, {3.9191392332801642`*^9, 
   3.919139255454362*^9}, {3.9191392924448996`*^9, 3.919139349802597*^9}, {
   3.919139486406455*^9, 3.9191395156439233`*^9}, 3.9191397792319717`*^9, {
   3.9191398464250755`*^9, 3.919139879667204*^9}, 3.9191410988780746`*^9, {
   3.9191411766037207`*^9, 3.9191411772892494`*^9}, 3.9191412252244153`*^9, {
   3.920178314944941*^9, 3.920178331225047*^9}, {3.9201783670120707`*^9, 
   3.920178383079835*^9}, 3.9202484272201977`*^9, {3.920248505703142*^9, 
   3.920248506139598*^9}, {3.920248901930794*^9, 3.92024890391144*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {GrayLevel[0.5], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwtlgk41NsbxzFjfvMjoixJKutN15buTLfNHJGUpdKqiCxdeaxdQ7RR2iSk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     "]]}},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{-1., 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(u\\), \\(g\\)]\\) (V)\"", FontSize -> 20, 
      StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(I\\), \\(d\\)]\\) (\[Mu]A)\"", FontSize -> 
      20, StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, {{-4, 
      FormBox[
       RowBox[{"-", "4"}], TraditionalForm]}, {-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{-1, -0.1}, {-3.5, 3.5}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.9069604407168236`*^9, 3.9069605332272882`*^9}, {
   3.906960873128422*^9, 3.906960895531418*^9}, 3.906976395013073*^9, 
   3.9069768261688895`*^9, 3.9069768566022353`*^9, 3.906976976761789*^9, 
   3.9069783364612823`*^9, 3.906978446755515*^9, 3.9069784966360397`*^9, 
   3.906979529032095*^9, 3.907029772655319*^9, 3.9070299989453187`*^9, 
   3.907030263361041*^9, {3.90703105661911*^9, 3.9070311034146614`*^9}, 
   3.907031139329981*^9, 3.9070312609672413`*^9, 3.9070604634211054`*^9, {
   3.907061676379919*^9, 3.9070617074839373`*^9}, 3.907061739927741*^9, 
   3.907061850623412*^9, 3.9071484107390194`*^9, 3.907149316528576*^9, {
   3.907216830020722*^9, 3.9072168690736713`*^9}, {3.907216986441079*^9, 
   3.9072169979590325`*^9}, {3.907217061489775*^9, 3.9072170675900564`*^9}, 
   3.9072195872223215`*^9, 3.9076389821284227`*^9, {3.907657849989588*^9, 
   3.9076578954976673`*^9}, {3.907657963814293*^9, 3.907657985463826*^9}, {
   3.907659663191266*^9, 3.907659676333522*^9}, 3.9076602819193583`*^9, 
   3.9077769656344566`*^9, 3.9126498516824837`*^9, 3.9126499726689463`*^9, 
   3.9126500609405794`*^9, 3.9126500919897842`*^9, 3.912650122172583*^9, {
   3.9126501902975006`*^9, 3.9126501965834703`*^9}, {3.9126503540020475`*^9, 
   3.912650388036002*^9}, {3.9126504474372797`*^9, 3.912650463692734*^9}, 
   3.912650602273307*^9, 3.912650672142622*^9, 3.9127691708103347`*^9, 
   3.912769204339058*^9, 3.912769344056361*^9, 3.9127693944939623`*^9, {
   3.91276950752767*^9, 3.9127695135006533`*^9}, 3.9127695472789445`*^9, {
   3.91276958070685*^9, 3.912769640773776*^9}, {3.9127696770277123`*^9, 
   3.9127696844337893`*^9}, {3.912769976179847*^9, 3.9127700622893705`*^9}, {
   3.9127701128059435`*^9, 3.912770159854647*^9}, 3.912770194401973*^9, 
   3.912770234418211*^9, {3.9127703033567085`*^9, 3.912770318728407*^9}, {
   3.9127704302576885`*^9, 3.9127704577555428`*^9}, 3.9127705033778143`*^9, {
   3.912770580166715*^9, 3.912770602674535*^9}, {3.912770649978569*^9, 
   3.9127706722518063`*^9}, {3.912770729731973*^9, 3.9127707549712605`*^9}, 
   3.912770817300192*^9, 3.9127708658522806`*^9, {3.912770907497669*^9, 
   3.912770961000368*^9}, {3.9127710118261724`*^9, 3.912771068816465*^9}, 
   3.9128197772924275`*^9, {3.912819822025155*^9, 3.912820012098296*^9}, {
   3.9128200425073357`*^9, 3.91282010670754*^9}, {3.912820156700299*^9, 
   3.912820258617489*^9}, 3.9128203044680405`*^9, {3.9128211932404394`*^9, 
   3.912821201719369*^9}, 3.9128213005959864`*^9, 3.912821344803238*^9, 
   3.9129203082809577`*^9, 3.912924814040944*^9, 3.9138081041432886`*^9, {
   3.913808137783062*^9, 3.9138081574861727`*^9}, 3.9138081880263014`*^9, 
   3.9138082852494926`*^9, {3.9138085109219937`*^9, 3.9138085203919535`*^9}, 
   3.913944247246892*^9, 3.9139443563966236`*^9, {3.9139447224751434`*^9, 
   3.913944760020854*^9}, {3.913944796798437*^9, 3.9139448759662085`*^9}, {
   3.9139449265588183`*^9, 3.9139449451606817`*^9}, 3.913958749387721*^9, 
   3.9139588188150773`*^9, {3.913958986942833*^9, 3.9139590084836893`*^9}, 
   3.913975019460681*^9, 3.913975186405835*^9, 3.91398052988524*^9, 
   3.9140616734485283`*^9, {3.9143019652329783`*^9, 3.914302018403781*^9}, 
   3.9143750128265266`*^9, 3.9146361196135254`*^9, {3.9191389810400543`*^9, 
   3.919139014959218*^9}, 3.9191391656081343`*^9, 3.9191392615687814`*^9, 
   3.9191393105174246`*^9, 3.919139352629927*^9, {3.9191395059087553`*^9, 
   3.919139516237733*^9}, 3.9191397801678686`*^9, {3.919139861618489*^9, 
   3.919139880656597*^9}, 3.9191407916257615`*^9, 3.9191411783632746`*^9, 
   3.919141226128358*^9, 3.9191689199872236`*^9, 3.9201181122849836`*^9, {
   3.9201783771676683`*^9, 3.9201783837679214`*^9}, 3.9202480578989525`*^9, 
   3.920248428320279*^9, 3.9202485142512245`*^9, 3.920248905008693*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0, 1, 0], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwtlok31Hsfxxny02aLIksN0QzlSqGiPl+iLFFRSZaspXvJclGkoogiRCkU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      "]]}}, {{}, {}, 
    {GrayLevel[0.5], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwtlgk0lVsbx82vIaIISZnOuekK6abbZL8iKUOlUREZurKMXUM0UZokpFKG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      "]]}}},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{-1., 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(u\\), \\(g\\)]\\) (V)\"", FontSize -> 20, 
      StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SuperscriptBox[\\(10\\), \\(-6\\)]\\) Z\"", FontSize -> 20, 
      StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, {{-4, 
      FormBox[
       RowBox[{"-", "4"}], TraditionalForm]}, {-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{-1, -0.1}, {0, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.9069604407168236`*^9, 3.9069605332272882`*^9}, {
   3.906960873128422*^9, 3.906960895531418*^9}, 3.906976395013073*^9, 
   3.9069768261688895`*^9, 3.9069768566022353`*^9, 3.906976976761789*^9, 
   3.9069783364612823`*^9, 3.906978446755515*^9, 3.9069784966360397`*^9, 
   3.906979529032095*^9, 3.907029772655319*^9, 3.9070299989453187`*^9, 
   3.907030263361041*^9, {3.90703105661911*^9, 3.9070311034146614`*^9}, 
   3.907031139329981*^9, 3.9070312609672413`*^9, 3.9070604634211054`*^9, {
   3.907061676379919*^9, 3.9070617074839373`*^9}, 3.907061739927741*^9, 
   3.907061850623412*^9, 3.9071484107390194`*^9, 3.907149316528576*^9, {
   3.907216830020722*^9, 3.9072168690736713`*^9}, {3.907216986441079*^9, 
   3.9072169979590325`*^9}, {3.907217061489775*^9, 3.9072170675900564`*^9}, 
   3.9072195872223215`*^9, 3.9076389821284227`*^9, {3.907657849989588*^9, 
   3.9076578954976673`*^9}, {3.907657963814293*^9, 3.907657985463826*^9}, {
   3.907659663191266*^9, 3.907659676333522*^9}, 3.9076602819193583`*^9, 
   3.9077769656344566`*^9, 3.9126498516824837`*^9, 3.9126499726689463`*^9, 
   3.9126500609405794`*^9, 3.9126500919897842`*^9, 3.912650122172583*^9, {
   3.9126501902975006`*^9, 3.9126501965834703`*^9}, {3.9126503540020475`*^9, 
   3.912650388036002*^9}, {3.9126504474372797`*^9, 3.912650463692734*^9}, 
   3.912650602273307*^9, 3.912650672142622*^9, 3.9127691708103347`*^9, 
   3.912769204339058*^9, 3.912769344056361*^9, 3.9127693944939623`*^9, {
   3.91276950752767*^9, 3.9127695135006533`*^9}, 3.9127695472789445`*^9, {
   3.91276958070685*^9, 3.912769640773776*^9}, {3.9127696770277123`*^9, 
   3.9127696844337893`*^9}, {3.912769976179847*^9, 3.9127700622893705`*^9}, {
   3.9127701128059435`*^9, 3.912770159854647*^9}, 3.912770194401973*^9, 
   3.912770234418211*^9, {3.9127703033567085`*^9, 3.912770318728407*^9}, {
   3.9127704302576885`*^9, 3.9127704577555428`*^9}, 3.9127705033778143`*^9, {
   3.912770580166715*^9, 3.912770602674535*^9}, {3.912770649978569*^9, 
   3.9127706722518063`*^9}, {3.912770729731973*^9, 3.9127707549712605`*^9}, 
   3.912770817300192*^9, 3.9127708658522806`*^9, {3.912770907497669*^9, 
   3.912770961000368*^9}, {3.9127710118261724`*^9, 3.912771068816465*^9}, 
   3.9128197772924275`*^9, {3.912819822025155*^9, 3.912820012098296*^9}, {
   3.9128200425073357`*^9, 3.91282010670754*^9}, {3.912820156700299*^9, 
   3.912820258617489*^9}, 3.9128203044680405`*^9, {3.9128211932404394`*^9, 
   3.912821201719369*^9}, 3.9128213005959864`*^9, 3.912821344803238*^9, 
   3.9129203082809577`*^9, 3.912924814040944*^9, 3.9138081041432886`*^9, {
   3.913808137783062*^9, 3.9138081574861727`*^9}, 3.9138081880263014`*^9, 
   3.9138082852494926`*^9, {3.9138085109219937`*^9, 3.9138085203919535`*^9}, 
   3.913944247246892*^9, 3.9139443563966236`*^9, {3.9139447224751434`*^9, 
   3.913944760020854*^9}, {3.913944796798437*^9, 3.9139448759662085`*^9}, {
   3.9139449265588183`*^9, 3.9139449451606817`*^9}, 3.913958749387721*^9, 
   3.9139588188150773`*^9, {3.913958986942833*^9, 3.9139590084836893`*^9}, 
   3.913975019460681*^9, 3.913975186405835*^9, 3.91398052988524*^9, 
   3.9140616734485283`*^9, {3.9143019652329783`*^9, 3.914302018403781*^9}, 
   3.9143750128265266`*^9, 3.9146361196135254`*^9, {3.9191389810400543`*^9, 
   3.919139014959218*^9}, 3.9191391656081343`*^9, 3.9191392615687814`*^9, 
   3.9191393105174246`*^9, 3.919139352629927*^9, {3.9191395059087553`*^9, 
   3.919139516237733*^9}, 3.9191397801678686`*^9, {3.919139861618489*^9, 
   3.919139880656597*^9}, 3.9191407916257615`*^9, 3.9191411783632746`*^9, 
   3.919141226128358*^9, 3.9191689199872236`*^9, 3.9201181122849836`*^9, {
   3.9201783771676683`*^9, 3.9201783837679214`*^9}, 3.9202480578989525`*^9, 
   3.920248428320279*^9, 3.9202485142512245`*^9, 3.9202489050243177`*^9}]
}, Open  ]],

Cell["", "Text",
 CellChangeTimes->{{3.9139445815144615`*^9, 3.913944583470003*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Theta]", "=", 
   RowBox[{"-", "1"}]}], ";", " ", 
  RowBox[{"\[Tau]e", "=", "0.5"}], ";", 
  RowBox[{"\[Tau]d", "=", "0.8"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vr", "=", "0.2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", " ", "=", " ", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Tau]d", " ", "vr", " ", 
         RowBox[{
          RowBox[{"M", "'"}], "[", "u", "]"}]}], " ", "\[Equal]", 
        RowBox[{
         RowBox[{
          RowBox[{"2", "/", "3"}], "N0", "  ", 
          RowBox[{"Abs", "[", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox[
              RowBox[{"u", "-", "EV"}], "kT"], ")"}], 
            RowBox[{"3", "/", "2"}]], "  ", "]"}]}], "-", 
         RowBox[{"M", "[", "u", "]"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"M", "[", "uvH", "]"}], "\[Equal]", 
        RowBox[{"Meq", "[", "uvH", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", "M", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"Mv1", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{"M", "[", "uv1", "]"}], "]"}], "/.", "sol"}], "}"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gh1", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[Theta]"}], " ", "L", " ", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"P0", "-", 
                RowBox[{"M", "[", "u", "]"}]}], ")"}], "/", "\[Tau]e"}]}], 
            "+", 
            RowBox[{"L", " ", 
             RowBox[{"f", "/", "\[Tau]d"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Meq", "[", "u", "]"}], "-", 
               RowBox[{"M", "[", "u", "]"}]}], ")"}]}]}], "}"}], "/.", 
          "sol"}], "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Magenta"}], 
          "}"}], "}"}]}], ",", 
       RowBox[{"BaseStyle", "->", 
        RowBox[{"{", 
         RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<u\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(tot\)]\)\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
          ",", "\"\<\>\""}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}]}], "]"}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", " ", "=", " ", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Tau]d"}], " ", "vr", " ", 
         RowBox[{
          RowBox[{"M", "'"}], "[", "u", "]"}]}], " ", "\[Equal]", 
        RowBox[{
         RowBox[{
          RowBox[{"2", "/", "3"}], "N0", "  ", 
          RowBox[{"Abs", "[", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox[
              RowBox[{"u", "-", "EV"}], "kT"], ")"}], 
            RowBox[{"3", "/", "2"}]], "  ", "]"}]}], "-", 
         RowBox[{"M", "[", "u", "]"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"M", "[", "uv1", "]"}], "\[Equal]", "Mv1"}]}], "}"}], ",", 
     RowBox[{"{", "M", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"Mv2", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{"M", "[", "uvH", "]"}], "]"}], "/.", "sol"}], "}"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gh2", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[Theta]"}], " ", "L", " ", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"P0", "-", 
                RowBox[{"M", "[", "u", "]"}]}], ")"}], "/", "\[Tau]e"}]}], 
            "+", 
            RowBox[{"L", " ", 
             RowBox[{"f", "/", "\[Tau]d"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Meq", "[", "u", "]"}], "-", 
               RowBox[{"M", "[", "u", "]"}]}], ")"}]}]}], "}"}], "/.", 
          "sol"}], "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Magenta"}], 
          "}"}], "}"}]}], ",", 
       RowBox[{"BaseStyle", "->", 
        RowBox[{"{", 
         RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<u\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(tot\)]\)\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
          ",", "\"\<\>\""}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}]}], "]"}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", " ", "=", " ", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Tau]d", " ", "vr", " ", 
         RowBox[{
          RowBox[{"M", "'"}], "[", "u", "]"}]}], " ", "\[Equal]", 
        RowBox[{
         RowBox[{
          RowBox[{"2", "/", "3"}], "N0", "  ", 
          RowBox[{"Abs", "[", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox[
              RowBox[{"u", "-", "EV"}], "kT"], ")"}], 
            RowBox[{"3", "/", "2"}]], "  ", "]"}]}], "-", 
         RowBox[{"M", "[", "u", "]"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"M", "[", "uvH", "]"}], "\[Equal]", "Mv2"}]}], "}"}], ",", 
     RowBox[{"{", "M", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"Mv1", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{"M", "[", "uv1", "]"}], "]"}], "/.", "sol"}], "}"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gh3", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[Theta]"}], " ", "L", " ", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"P0", "-", 
                RowBox[{"M", "[", "u", "]"}]}], ")"}], "/", "\[Tau]e"}]}], 
            "+", 
            RowBox[{"L", " ", 
             RowBox[{"f", "/", "\[Tau]d"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Meq", "[", "u", "]"}], "-", 
               RowBox[{"M", "[", "u", "]"}]}], ")"}]}]}], "}"}], "/.", 
          "sol"}], "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Magenta"}], 
          "}"}], "}"}]}], ",", 
       RowBox[{"BaseStyle", "->", 
        RowBox[{"{", 
         RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<u\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(tot\)]\)\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
          ",", "\"\<\>\""}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}]}], "]"}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"io1", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"uv", ",", 
       RowBox[{"Idc", "[", "uv", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"uv", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "10"}], ",", "10000"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\!\(\*SubscriptBox[\(u\), \(g\)]\) (V)\>\"", ",", 
          RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(d\)]\) (\[Mu]A)\>\"", ",", 
          RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
        ",", "\"\<\>\""}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3"}], ",", 
          RowBox[{"-", "2"}], ",", 
          RowBox[{"-", "1"}], ",", 
          RowBox[{"-", "0.5"}], ",", "0", ",", "0.5", ",", "1", ",", "2", ",",
           "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", 
          RowBox[{"-", "3"}], ",", 
          RowBox[{"-", "2"}], ",", 
          RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", "3"}], "}"}],
         ",", "None", ",", "None"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Gray"}], "}"}], 
       "}"}]}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "0.7"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"90", " ", "4`"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{"io1", ",", "gh2", ",", "gh3", ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"uv0", ",", 
         RowBox[{"uv1", "+", "0.2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.5"}], ",", "3.2"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"BaseStyle", "->", 
     RowBox[{"{", 
      RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.8390646611298313`*^9, 3.839064663549252*^9}, {
   3.8390651628201227`*^9, 3.8390651698744855`*^9}, {3.8390671245340233`*^9, 
   3.839067253968177*^9}, {3.8390672908692884`*^9, 3.8390673435588245`*^9}, {
   3.839067444277615*^9, 3.8390674530816755`*^9}, {3.839067483223913*^9, 
   3.8390676448632746`*^9}, {3.839067792030848*^9, 3.8390679296503277`*^9}, {
   3.839068035965031*^9, 3.8390681198292847`*^9}, {3.8390709139116144`*^9, 
   3.8390709421089935`*^9}, {3.83907099038449*^9, 3.8390709930117693`*^9}, {
   3.839071053413534*^9, 3.839071065617492*^9}, {3.839071142245447*^9, 
   3.8390712315177836`*^9}, {3.839071262559967*^9, 3.8390713000871944`*^9}, {
   3.8390714971122246`*^9, 3.839071517359198*^9}, {3.8390715485300074`*^9, 
   3.8390716200472517`*^9}, {3.8390716672806673`*^9, 3.839071782347397*^9}, {
   3.839071837937226*^9, 3.839071939311781*^9}, {3.839072168081314*^9, 
   3.839072168581891*^9}, {3.8390723168444653`*^9, 3.8390724465495067`*^9}, {
   3.8390724871236815`*^9, 3.839072628537404*^9}, {3.8390726857581015`*^9, 
   3.83907270608572*^9}, {3.8390728526632924`*^9, 3.8390730714112225`*^9}, {
   3.839082271666379*^9, 3.8390823055073657`*^9}, {3.839082353119522*^9, 
   3.839082449840514*^9}, {3.8390839765348864`*^9, 3.839084057466158*^9}, {
   3.8390840878065057`*^9, 3.8390841778809776`*^9}, {3.8390842363292522`*^9, 
   3.8390842982497163`*^9}, 3.83908433029414*^9, {3.8390843708346243`*^9, 
   3.8390844315092807`*^9}, 3.839084462612833*^9, {3.8390845298830824`*^9, 
   3.839084537171591*^9}, {3.8390846234607463`*^9, 3.839084639769829*^9}, {
   3.839085385972989*^9, 3.8390853976007433`*^9}, {3.8390854555897675`*^9, 
   3.839085524444199*^9}, {3.839085565738154*^9, 3.8390855920819826`*^9}, {
   3.8390863447286386`*^9, 3.839086474045252*^9}, {3.839086860852067*^9, 
   3.839086874816577*^9}, {3.839087637034748*^9, 3.8390876843714943`*^9}, 
   3.83908780285631*^9, 3.8390878367914057`*^9, {3.839088015231053*^9, 
   3.8390880802460375`*^9}, {3.839088241208177*^9, 3.839088251058446*^9}, 
   3.839088396382834*^9, 3.8391182307918463`*^9, {3.839118379381566*^9, 
   3.8391183868618546`*^9}, {3.839118542781612*^9, 3.839118576690755*^9}, {
   3.839119230679368*^9, 3.8391192435152392`*^9}, {3.8391193005384474`*^9, 
   3.839119322077612*^9}, {3.8391197370496492`*^9, 3.839119744561663*^9}, {
   3.839119780647091*^9, 3.8391198576053133`*^9}, {3.83913747847266*^9, 
   3.839137485481214*^9}, {3.8391375587687283`*^9, 3.8391375797199593`*^9}, {
   3.8391376276780567`*^9, 3.8391376620779104`*^9}, {3.83913835785732*^9, 
   3.839138374216883*^9}, 3.8391384110040264`*^9, {3.8391384624942074`*^9, 
   3.839138462879356*^9}, {3.8391385170099597`*^9, 3.839138536349577*^9}, {
   3.839139183554804*^9, 3.8391391930138044`*^9}, {3.8391393033973885`*^9, 
   3.8391393043613095`*^9}, 3.839139359067504*^9, 3.839139436240513*^9, {
   3.8392078031308994`*^9, 3.8392078143543434`*^9}, {3.8392078889566584`*^9, 
   3.83920790820275*^9}, {3.839208054761527*^9, 3.839208093399903*^9}, {
   3.8392084092575808`*^9, 3.8392084620514746`*^9}, 3.839208533536579*^9, {
   3.8392086070037084`*^9, 3.8392086083290124`*^9}, 3.8392086479255266`*^9, {
   3.8392225965883913`*^9, 3.8392226283136573`*^9}, {3.8392226646362276`*^9, 
   3.8392227421040397`*^9}, 3.8392227767756677`*^9, {3.8392228326927814`*^9, 
   3.839222892911393*^9}, 3.8392230743763013`*^9, {3.839223141092394*^9, 
   3.839223141783134*^9}, 3.839223177642132*^9, {3.8392232273840017`*^9, 
   3.8392232854596047`*^9}, {3.8392233573873816`*^9, 3.839223398790718*^9}, {
   3.8392234505961695`*^9, 3.839223507183962*^9}, {3.839223811017748*^9, 
   3.8392239510950837`*^9}, {3.8392240167007127`*^9, 3.839224025275307*^9}, {
   3.8392241057509785`*^9, 3.839224157437503*^9}, {3.839224200897134*^9, 
   3.8392242487597456`*^9}, {3.839224294917468*^9, 3.839224296013791*^9}, {
   3.8392243639841394`*^9, 3.8392243950383773`*^9}, 3.839224442185709*^9, {
   3.8392245129185476`*^9, 3.8392245373577056`*^9}, {3.8392245776385975`*^9, 
   3.839224740679908*^9}, {3.8392248367057567`*^9, 3.839224838004247*^9}, {
   3.8392249023255987`*^9, 3.8392249329681873`*^9}, 3.8392250078513308`*^9, {
   3.8392250461420965`*^9, 3.8392250567765236`*^9}, {3.8392250892690206`*^9, 
   3.839225128234888*^9}, {3.839225292837965*^9, 3.8392253052980237`*^9}, {
   3.839225374465659*^9, 3.839225378163327*^9}, {3.8392366608564453`*^9, 
   3.839236691352835*^9}, {3.839236736346908*^9, 3.8392367461057377`*^9}, {
   3.8392368452896976`*^9, 3.8392369245276327`*^9}, {3.8392369586763678`*^9, 
   3.839236989556669*^9}, {3.8392370210310707`*^9, 3.839237025639107*^9}, {
   3.8392370611832547`*^9, 3.839237143422812*^9}, {3.839237229917989*^9, 
   3.839237306453603*^9}, {3.8392373387206373`*^9, 3.839237342820054*^9}, {
   3.839237447098841*^9, 3.8392375543643665`*^9}, {3.8392411494009237`*^9, 
   3.839241171431179*^9}, {3.83924120627816*^9, 3.8392412247291117`*^9}, 
   3.8392412792201967`*^9, 3.8392413874247665`*^9, {3.8392415172512045`*^9, 
   3.8392415791894693`*^9}, {3.839241632182249*^9, 3.8392416472548246`*^9}, 
   3.8392418101230965`*^9, {3.839242047805271*^9, 3.8392420951804295`*^9}, {
   3.8392421670049934`*^9, 3.8392422247577305`*^9}, {3.8392422574679546`*^9, 
   3.8392422587095203`*^9}, {3.839242291908*^9, 3.8392425704347763`*^9}, {
   3.8392426617662134`*^9, 3.8392426717163734`*^9}, 3.839242785862258*^9, {
   3.839246817917405*^9, 3.8392468269690895`*^9}, {3.839246889891876*^9, 
   3.839246924816616*^9}, {3.839309996677757*^9, 3.839310018708186*^9}, {
   3.839310845764266*^9, 3.839310880859878*^9}, {3.839310926113166*^9, 
   3.839310949193386*^9}, {3.8393110019361973`*^9, 3.8393110308399534`*^9}, {
   3.8393270934512377`*^9, 3.839327332415727*^9}, {3.839327370226597*^9, 
   3.839327451303669*^9}, {3.8393275031436253`*^9, 3.8393275194960613`*^9}, {
   3.839327586008069*^9, 3.8393276948310633`*^9}, {3.8393278034898295`*^9, 
   3.8393278068680096`*^9}, {3.8393278450424776`*^9, 
   3.8393278797618237`*^9}, {3.8393289610021143`*^9, 3.839328976754302*^9}, {
   3.8393294967878103`*^9, 3.839329617607455*^9}, 3.8393297021511583`*^9, {
   3.839329736764967*^9, 3.83932973839811*^9}, {3.839329841358012*^9, 
   3.839329850076448*^9}, {3.8393298856244183`*^9, 3.83932990739045*^9}, {
   3.839330200791801*^9, 3.839330209464896*^9}, 3.83933026862875*^9, {
   3.8393304947792683`*^9, 3.839330614321838*^9}, {3.839330707456501*^9, 
   3.8393307223587484`*^9}, {3.8393307586469154`*^9, 3.839330774655125*^9}, {
   3.8393308208469334`*^9, 3.8393308254369345`*^9}, {3.83933092079788*^9, 
   3.8393310148602314`*^9}, {3.8393311745075006`*^9, 
   3.8393311994275675`*^9}, {3.8393312620131807`*^9, 
   3.8393312886598005`*^9}, {3.83933158528376*^9, 3.8393316720258255`*^9}, 
   3.8393317188850336`*^9, {3.8393317973728094`*^9, 3.8393319397094903`*^9}, 
   3.8393320294844685`*^9, {3.8393325727147913`*^9, 3.8393326007437224`*^9}, {
   3.839332643937569*^9, 3.8393326886712303`*^9}, {3.839332884251463*^9, 
   3.8393328849388123`*^9}, {3.8393329498885293`*^9, 3.839332954368989*^9}, 
   3.839332984548478*^9, {3.839333161836732*^9, 3.839333179429063*^9}, {
   3.839333212168277*^9, 3.8393332158859396`*^9}, {3.839333299885914*^9, 
   3.839333320058819*^9}, {3.8393333662749724`*^9, 3.839333389618166*^9}, 
   3.8393335815372777`*^9, {3.8393336646381135`*^9, 3.839333690640252*^9}, {
   3.839333816187891*^9, 3.839333852596138*^9}, {3.839333913143673*^9, 
   3.839333960953573*^9}, {3.8393340547869487`*^9, 3.839334137419753*^9}, {
   3.839420765475212*^9, 3.839420767706482*^9}, {3.839420800720344*^9, 
   3.83942080814257*^9}, {3.839420930166752*^9, 3.839420954611184*^9}, 
   3.839421093306271*^9, {3.839421249787591*^9, 3.8394213460868835`*^9}, {
   3.839421400152422*^9, 3.8394214417353144`*^9}, {3.839421483648677*^9, 
   3.839421580608614*^9}, 3.839421616079374*^9, 3.839422181142932*^9, {
   3.8394224472930202`*^9, 3.839422448371497*^9}, {3.8394225405886507`*^9, 
   3.839422541885687*^9}, {3.8394225839963813`*^9, 3.83942258751882*^9}, 
   3.8394239784679832`*^9, {3.8394240190394516`*^9, 3.8394240194005165`*^9}, {
   3.839481241680246*^9, 3.8394812636526537`*^9}, {3.8394813033197775`*^9, 
   3.839481343020226*^9}, {3.8394813886318493`*^9, 3.83948138904453*^9}, {
   3.8394814470082235`*^9, 3.8394815138762083`*^9}, {3.839484145142799*^9, 
   3.8394841575703464`*^9}, {3.8394842427712455`*^9, 
   3.8394842456191454`*^9}, {3.8394844396674995`*^9, 
   3.8394844660440836`*^9}, {3.8394845806487627`*^9, 3.83948460808449*^9}, {
   3.8394847191879005`*^9, 3.839484719920673*^9}, {3.8394847985864277`*^9, 
   3.8394847999498053`*^9}, {3.839485522225484*^9, 3.8394858614478054`*^9}, {
   3.8394858968609977`*^9, 3.8394858979280567`*^9}, {3.83950394022218*^9, 
   3.839504016595684*^9}, {3.839504079022719*^9, 3.8395041716366367`*^9}, {
   3.8395042475063295`*^9, 3.83950424807436*^9}, {3.8395043044033585`*^9, 
   3.8395043325148754`*^9}, {3.839504403912784*^9, 3.839504405955762*^9}, {
   3.839504461254238*^9, 3.8395044954062967`*^9}, {3.839504572085556*^9, 
   3.8395046258331623`*^9}, {3.839504718095887*^9, 3.839504733043982*^9}, {
   3.839504792704324*^9, 3.8395048214714227`*^9}, {3.8395048602645364`*^9, 
   3.839504871422516*^9}, {3.83950521161292*^9, 3.8395052235501237`*^9}, {
   3.839505255990897*^9, 3.8395052773582516`*^9}, {3.839505321851119*^9, 
   3.839505332451271*^9}, {3.8395054257374*^9, 3.8395054385582395`*^9}, 
   3.839505580972617*^9, {3.8395057025144815`*^9, 3.8395057031788645`*^9}, {
   3.8395057369934807`*^9, 3.8395057373979363`*^9}, {3.839505772294227*^9, 
   3.839505778367197*^9}, {3.83950673092721*^9, 3.8395067795192204`*^9}, {
   3.8395084122279215`*^9, 3.8395084138977666`*^9}, {3.839508448233049*^9, 
   3.8395084493422976`*^9}, {3.839508499051385*^9, 3.8395085344200335`*^9}, 
   3.8395086207285233`*^9, {3.8395086973952723`*^9, 3.8395086978689127`*^9}, {
   3.8395089696790757`*^9, 3.839509039224576*^9}, {3.8395100524490423`*^9, 
   3.839510053723009*^9}, {3.839511493807127*^9, 3.8395115089839754`*^9}, {
   3.8395115931589155`*^9, 3.839511633911852*^9}, {3.839511664551564*^9, 
   3.8395117021779413`*^9}, {3.839511738662855*^9, 3.8395117683886237`*^9}, {
   3.8395840465025244`*^9, 3.8395840478719764`*^9}, {3.8395842326636224`*^9, 
   3.8395842405526743`*^9}, {3.8395844072352886`*^9, 3.839584438590257*^9}, {
   3.839584539157859*^9, 3.839584558647271*^9}, {3.8395846133789663`*^9, 
   3.83958465811094*^9}, {3.839584785836444*^9, 3.839584807986281*^9}, 
   3.839586726652771*^9, {3.8395867995416994`*^9, 3.8395868420413933`*^9}, 
   3.83958688638865*^9, {3.839587244941451*^9, 3.83958726487414*^9}, {
   3.83958774293878*^9, 3.8395877838602095`*^9}, 3.839587828597546*^9, {
   3.839587879706158*^9, 3.8395879135449758`*^9}, {3.839587955043039*^9, 
   3.8395879642045746`*^9}, {3.8395880048781385`*^9, 3.839588051406326*^9}, {
   3.8395880883490973`*^9, 3.8395881594520197`*^9}, {3.8395882347911615`*^9, 
   3.8395883226336384`*^9}, 3.8395883559509153`*^9, 3.839588415451826*^9, {
   3.8395884902783833`*^9, 3.8395885216082554`*^9}, {3.8395941073926105`*^9, 
   3.8395942227438965`*^9}, 3.839595304916483*^9, {3.8395954862576475`*^9, 
   3.83959557521957*^9}, {3.839595607221432*^9, 3.8395956076140194`*^9}, {
   3.839595660820343*^9, 3.839595661835729*^9}, {3.839604650775865*^9, 
   3.8396046640054827`*^9}, {3.839604708532463*^9, 3.8396047629301977`*^9}, {
   3.839604795558606*^9, 3.839604808947177*^9}, {3.839604852056878*^9, 
   3.8396048690185547`*^9}, {3.839642088079403*^9, 3.839642141004441*^9}, {
   3.8396422800918975`*^9, 3.8396423077286944`*^9}, {3.8396424143783884`*^9, 
   3.8396424152236857`*^9}, {3.8396426095904264`*^9, 
   3.8396426100591545`*^9}, {3.8396426843268356`*^9, 3.8396426912164164`*^9}, 
   3.8396427676568155`*^9, {3.8396428549330425`*^9, 3.8396429650459213`*^9}, 
   3.839643049962629*^9, {3.839643091872772*^9, 3.8396431410841303`*^9}, 
   3.839643491656567*^9, {3.839643550041149*^9, 3.839643610060313*^9}, {
   3.8396436783391447`*^9, 3.8396437059963512`*^9}, {3.8396437389632745`*^9, 
   3.8396437448257093`*^9}, {3.839643793497415*^9, 3.8396438275668716`*^9}, {
   3.839643978745996*^9, 3.8396439798436737`*^9}, {3.839644021519642*^9, 
   3.8396440428152156`*^9}, {3.8396441695399504`*^9, 
   3.8396441971715937`*^9}, {3.839644230142295*^9, 3.8396442469945946`*^9}, {
   3.839644284692358*^9, 3.8396442961501245`*^9}, {3.8396443434969287`*^9, 
   3.8396443583914576`*^9}, {3.8396448346105194`*^9, 3.839644913123821*^9}, {
   3.8396555898716025`*^9, 3.839655650012109*^9}, {3.8396556822310605`*^9, 
   3.839655771771843*^9}, {3.839655952479162*^9, 3.8396559541084647`*^9}, 
   3.839656003389371*^9, {3.8396560347174463`*^9, 3.839656116850046*^9}, {
   3.8396562422855325`*^9, 3.8396562713341274`*^9}, 3.8396563271846943`*^9, {
   3.8396565529884825`*^9, 3.839656667985509*^9}, {3.8396568526250334`*^9, 
   3.839656873162519*^9}, {3.8396570321068354`*^9, 3.8396570367161813`*^9}, {
   3.8396571621919303`*^9, 3.839657193340761*^9}, {3.839657225174745*^9, 
   3.8396572442512493`*^9}, {3.8396572932236905`*^9, 3.8396572940165*^9}, 
   3.8396574072631903`*^9, {3.8396575476060143`*^9, 3.8396575682943974`*^9}, {
   3.839664138921971*^9, 3.839664156869915*^9}, 3.839664243007531*^9, {
   3.839669622125418*^9, 3.839669647884663*^9}, {3.839670002387182*^9, 
   3.839670025487237*^9}, {3.8396700586539392`*^9, 3.8396701085420904`*^9}, {
   3.8396766028729286`*^9, 3.839676603372811*^9}, {3.839676649783103*^9, 
   3.8396766681979322`*^9}, {3.839723206211033*^9, 3.839723252419324*^9}, {
   3.8397243192805915`*^9, 3.8397243622670403`*^9}, {3.839724526690404*^9, 
   3.8397245565593586`*^9}, 3.839724591814554*^9, {3.8397246526353917`*^9, 
   3.8397246677187424`*^9}, {3.839724698665658*^9, 3.8397248461537275`*^9}, {
   3.839724910156172*^9, 3.839724969029936*^9}, {3.839725029399225*^9, 
   3.839725070375955*^9}, {3.8397257491640964`*^9, 3.8397258148584566`*^9}, {
   3.839726205531111*^9, 3.839726226304987*^9}, {3.839726314389023*^9, 
   3.8397264887181263`*^9}, {3.8397266355093994`*^9, 
   3.8397266356472826`*^9}, {3.839727069639051*^9, 3.83972707062368*^9}, {
   3.8397274615058823`*^9, 3.839727481527841*^9}, {3.83972755827617*^9, 
   3.8397275594724007`*^9}, {3.839727857737072*^9, 3.83972788618902*^9}, 
   3.8397281801577473`*^9, {3.839741406815917*^9, 3.839741648719699*^9}, 
   3.839741694966459*^9, {3.8397417738301263`*^9, 3.8397417740488653`*^9}, 
   3.839742014559319*^9, {3.8397421882027674`*^9, 3.839742188943444*^9}, {
   3.8397589658528605`*^9, 3.83975903164762*^9}, {3.839759582024466*^9, 
   3.8397596437148447`*^9}, {3.8397597378135786`*^9, 3.839759770277839*^9}, {
   3.839760042248042*^9, 3.8397600434337606`*^9}, {3.839760792865179*^9, 
   3.839760817913896*^9}, {3.8397655048182044`*^9, 3.839765505036851*^9}, {
   3.839765649791177*^9, 3.839765680039174*^9}, {3.839765730951825*^9, 
   3.8397657438209515`*^9}, {3.8397658325268707`*^9, 3.839765870890603*^9}, {
   3.8397695336031294`*^9, 3.8397695785421767`*^9}, 3.839769610638837*^9, {
   3.839769642999297*^9, 3.8397696900062704`*^9}, {3.8397697294324865`*^9, 
   3.839769753667972*^9}, 3.839770624201335*^9, {3.8399858643515997`*^9, 
   3.839985870106961*^9}, {3.8399859073530426`*^9, 3.83998590778368*^9}, {
   3.839986665758301*^9, 3.839986671600184*^9}, {3.840015477117873*^9, 
   3.840015532633871*^9}, {3.840262190474472*^9, 3.8402621922160215`*^9}, {
   3.8402622512898836`*^9, 3.8402623158498154`*^9}, {3.840262346847395*^9, 
   3.840262361938197*^9}, {3.8402624446884875`*^9, 3.840262497278998*^9}, {
   3.8402625593196363`*^9, 3.840262562846277*^9}, {3.840262654524027*^9, 
   3.8402626673364897`*^9}, {3.8402800661176753`*^9, 3.840280138278593*^9}, {
   3.840280177703832*^9, 3.840280189480773*^9}, {3.8402802324576406`*^9, 
   3.8402802331825943`*^9}, {3.8402812754975386`*^9, 3.840281326464582*^9}, 
   3.8402813946519136`*^9, {3.84028186111417*^9, 3.8402818954912634`*^9}, {
   3.8402819964993353`*^9, 3.8402819971437144`*^9}, {3.840330466229367*^9, 
   3.8403304972505484`*^9}, 3.8403305401374164`*^9, 3.840330628649666*^9, {
   3.8403306672934227`*^9, 3.8403306802026963`*^9}, {3.8403307193320885`*^9, 
   3.840330758272279*^9}, 3.8403307967908325`*^9, 3.8403308358680725`*^9, {
   3.840330872410847*^9, 3.8403308786837*^9}, {3.8403309221453967`*^9, 
   3.840330944340696*^9}, 3.840330989285677*^9, {3.840331109810131*^9, 
   3.840331153164013*^9}, {3.840331431580937*^9, 3.8403314406879196`*^9}, {
   3.8403317789283185`*^9, 3.840331780542934*^9}, {3.840331813886128*^9, 
   3.8403318320633073`*^9}, {3.8403318821336937`*^9, 
   3.8403318897950106`*^9}, {3.8403319357741313`*^9, 
   3.8403319411825953`*^9}, {3.8403320129500637`*^9, 
   3.8403321277278547`*^9}, {3.840332221075777*^9, 3.8403322212632327`*^9}, {
   3.8404162792747984`*^9, 3.8404162803058043`*^9}, {3.840416344690134*^9, 
   3.8404163448306866`*^9}, {3.8404178626090136`*^9, 3.840417925824424*^9}, {
   3.8404191918191233`*^9, 3.84041920226635*^9}, {3.840419242024495*^9, 
   3.8404192617321796`*^9}, {3.8404194389428053`*^9, 3.840419462557069*^9}, {
   3.840453834266838*^9, 3.8404538447517056`*^9}, 3.840453909614043*^9, {
   3.8404539683635793`*^9, 3.8404539905838337`*^9}, 3.8404540272985306`*^9, {
   3.840454156166298*^9, 3.840454205291971*^9}, {3.840454240247527*^9, 
   3.8404542540157146`*^9}, {3.8404543237333283`*^9, 
   3.8404543404928937`*^9}, {3.8404544521143074`*^9, 
   3.8404544541302176`*^9}, {3.840454485008524*^9, 3.8404544958331428`*^9}, {
   3.840454535970628*^9, 3.840454551137659*^9}, {3.840500625089159*^9, 
   3.840500656940725*^9}, {3.840500695345143*^9, 3.8405006960523067`*^9}, {
   3.8405010969852047`*^9, 3.840501112587641*^9}, {3.840501150634077*^9, 
   3.8405011611522417`*^9}, {3.8405026446645527`*^9, 3.84050265267775*^9}, 
   3.8405026878215275`*^9, 3.8405027886745453`*^9, {3.8405028323157024`*^9, 
   3.8405028521056433`*^9}, {3.840508597751215*^9, 3.8405086042448597`*^9}, {
   3.8405086361734276`*^9, 3.840508697640854*^9}, {3.84530515034306*^9, 
   3.8453051663199177`*^9}, 3.845305197884505*^9, {3.8454792808354254`*^9, 
   3.8454794150956697`*^9}, {3.845479722113243*^9, 3.8454797915964413`*^9}, {
   3.845514873929638*^9, 3.8455149337268724`*^9}, {3.8455149684706416`*^9, 
   3.8455149695080223`*^9}, {3.8455153275220933`*^9, 3.845515328229957*^9}, {
   3.845515395675539*^9, 3.845515401297691*^9}, {3.845515515853771*^9, 
   3.845515576447665*^9}, {3.845515612558851*^9, 3.845515632979537*^9}, {
   3.845515680153039*^9, 3.8455159262376585`*^9}, {3.845516112061887*^9, 
   3.8455161465263453`*^9}, {3.845516193085106*^9, 3.845516229178423*^9}, {
   3.8455163351689043`*^9, 3.845516585318216*^9}, {3.8455166177397394`*^9, 
   3.845516714733508*^9}, {3.845516771645197*^9, 3.8455167731827154`*^9}, {
   3.845516818729296*^9, 3.84551695860878*^9}, {3.845516994711903*^9, 
   3.845517026462266*^9}, 3.845517092145789*^9, {3.845517135366593*^9, 
   3.845517155446496*^9}, {3.845517186534149*^9, 3.8455171937276707`*^9}, {
   3.845517227012909*^9, 3.8455172279061613`*^9}, {3.8455173234132085`*^9, 
   3.8455173514857492`*^9}, {3.845517423730919*^9, 3.8455174243493695`*^9}, {
   3.8455174624069753`*^9, 3.845517465100626*^9}, 3.845517507705373*^9, 
   3.8455175508535676`*^9, {3.8455176264044795`*^9, 3.8455176334075813`*^9}, {
   3.8455313319229393`*^9, 3.845531509940443*^9}, 3.8455315849840965`*^9, {
   3.8455317016782956`*^9, 3.845531738966821*^9}, {3.845531778451456*^9, 
   3.845531779386674*^9}, {3.8456415428113813`*^9, 3.845641735457308*^9}, {
   3.8456420427094593`*^9, 3.8456420444008894`*^9}, {3.8456420953927226`*^9, 
   3.845642095827136*^9}, {3.8456421305858717`*^9, 3.8456422084386454`*^9}, 
   3.8456422719473834`*^9, {3.8456424654126687`*^9, 3.8456424685516415`*^9}, {
   3.8456425391271963`*^9, 3.845642581942461*^9}, {3.8456426396045694`*^9, 
   3.845642806094469*^9}, {3.845642836196087*^9, 3.845642900922883*^9}, {
   3.845642970285206*^9, 3.8456430181273146`*^9}, {3.8456430708546114`*^9, 
   3.845643125882959*^9}, {3.845643178575968*^9, 3.845643257358486*^9}, {
   3.8456433623862553`*^9, 3.8456433771042914`*^9}, {3.8456434590863156`*^9, 
   3.8456434937160645`*^9}, 3.845643545927831*^9, {3.845643600156926*^9, 
   3.845643618570978*^9}, {3.8456436644300175`*^9, 3.84564366503797*^9}, {
   3.845643702197648*^9, 3.8456437461979747`*^9}, 3.8456439574887114`*^9, {
   3.846069818172841*^9, 3.846069849642768*^9}, {3.8460699136765876`*^9, 
   3.846069914209477*^9}, {3.8460699599440656`*^9, 3.8460700314146757`*^9}, {
   3.846070076753316*^9, 3.846070077439046*^9}, {3.846070157661101*^9, 
   3.8460701937707815`*^9}, {3.846070258127372*^9, 3.846070370035694*^9}, 
   3.8460704231130123`*^9, {3.846070456017062*^9, 3.8460704588184586`*^9}, {
   3.8460710172041235`*^9, 3.846071021582673*^9}, {3.846071106666136*^9, 
   3.8460711227728405`*^9}, {3.846071236516765*^9, 3.8460712690613956`*^9}, {
   3.846071302508814*^9, 3.8460713286265783`*^9}, {3.846071391711331*^9, 
   3.8460713919222136`*^9}, {3.8460717432565613`*^9, 3.846071846163582*^9}, {
   3.8460718796339417`*^9, 3.8460718981181345`*^9}, {3.8460719281852317`*^9, 
   3.8460719602156863`*^9}, {3.8460725487311463`*^9, 
   3.8460727277222366`*^9}, {3.8460727966336946`*^9, 
   3.8460727999447126`*^9}, {3.8460728715731387`*^9, 3.846072900231036*^9}, 
   3.8460729488995743`*^9, 3.846073094187673*^9, {3.846073124968068*^9, 
   3.846073143649494*^9}, {3.846073291437569*^9, 3.846073320871194*^9}, {
   3.8460733513356*^9, 3.8460733827836275`*^9}, {3.8460734213260293`*^9, 
   3.846073547913215*^9}, {3.8460735888598585`*^9, 3.8460735948494663`*^9}, {
   3.8460736630482445`*^9, 3.84607366906472*^9}, {3.846073769039547*^9, 
   3.8460738022300262`*^9}, {3.8460738788770266`*^9, 
   3.8460738952181954`*^9}, {3.846073949966679*^9, 3.8460739569065495`*^9}, {
   3.846074029073464*^9, 3.8460740346596146`*^9}, {3.846074102104647*^9, 
   3.8460741324118767`*^9}, {3.8460741949049115`*^9, 3.846074222593691*^9}, {
   3.8460742841895127`*^9, 3.846074340763191*^9}, {3.846160732253354*^9, 
   3.8461607332481594`*^9}, 3.846161492762432*^9, {3.846161780897497*^9, 
   3.846161788138113*^9}, {3.8461618293598766`*^9, 3.846161858226082*^9}, {
   3.8461618966585674`*^9, 3.846161969794857*^9}, 3.846162102689354*^9, {
   3.8461621668466263`*^9, 3.846162180355235*^9}, {3.8461622164826603`*^9, 
   3.8461622355856447`*^9}, {3.846162281065609*^9, 3.8461624985309367`*^9}, 
   3.8461626621493115`*^9, 3.846162697816634*^9, {3.8461627342864695`*^9, 
   3.8461627345822268`*^9}, {3.8461628166006966`*^9, 3.8461628174265194`*^9}, 
   3.846162849529516*^9, 3.846163042718745*^9, {3.8461630926561747`*^9, 
   3.8461631014520173`*^9}, 3.846164675187914*^9, {3.8461653709571285`*^9, 
   3.8461653939322076`*^9}, {3.846239297565034*^9, 3.846239321709072*^9}, {
   3.8462393704866405`*^9, 3.846239378462596*^9}, 3.8462394463604927`*^9, {
   3.846239908200873*^9, 3.846240041118046*^9}, {3.8462400979595313`*^9, 
   3.8462402075029526`*^9}, {3.846240330599819*^9, 3.846240332116249*^9}, {
   3.846240396409835*^9, 3.846240426609739*^9}, {3.8462404635946035`*^9, 
   3.846240479194495*^9}, {3.846240547126852*^9, 3.8462406007711906`*^9}, {
   3.846240672984129*^9, 3.8462406735655537`*^9}, {3.846240715451014*^9, 
   3.846240727662325*^9}, {3.8462408398048706`*^9, 3.8462408550133176`*^9}, {
   3.846240906219432*^9, 3.8462409845731764`*^9}, {3.8462415426024213`*^9, 
   3.846241600241384*^9}, {3.8462416533016524`*^9, 3.8462416824345474`*^9}, {
   3.846241871443136*^9, 3.846241889026347*^9}, {3.84624196622915*^9, 
   3.846241982209696*^9}, {3.8462420839315395`*^9, 3.8462421106657743`*^9}, {
   3.8462493213059616`*^9, 3.846249371505189*^9}, {3.846249426216957*^9, 
   3.8462494677076874`*^9}, {3.846249549506504*^9, 3.8462495503135986`*^9}, {
   3.8463317012472258`*^9, 3.846331723789422*^9}, 3.846331790148814*^9, {
   3.846331841946804*^9, 3.8463318642788124`*^9}, {3.8463318999649568`*^9, 
   3.84633190085021*^9}, {3.846331970187175*^9, 3.8463319724350276`*^9}, {
   3.846332425994608*^9, 3.8463324267831564`*^9}, {3.8463324853767433`*^9, 
   3.846332505743512*^9}, {3.84633253640195*^9, 3.84633253746087*^9}, 
   3.8463325927468147`*^9, {3.846332664076268*^9, 3.84633267729871*^9}, {
   3.84633282094595*^9, 3.846332866648316*^9}, {3.846332915983061*^9, 
   3.846332964772069*^9}, {3.8463332315659857`*^9, 3.8463332589840655`*^9}, {
   3.8463333159368706`*^9, 3.8463333881232243`*^9}, {3.846333478174964*^9, 
   3.846333507307977*^9}, {3.8463337169753866`*^9, 3.846333752677167*^9}, {
   3.8463337874930525`*^9, 3.8463337938266315`*^9}, {3.84633382889653*^9, 
   3.8463338314544067`*^9}, {3.8463338661347585`*^9, 
   3.8463338671064034`*^9}, {3.8463341029946103`*^9, 3.8463341178046017`*^9}, 
   3.8463344961508446`*^9, {3.846334551477289*^9, 3.8463345669722776`*^9}, {
   3.846334647851037*^9, 3.8463346507709723`*^9}, {3.8463350072556896`*^9, 
   3.846335009531336*^9}, {3.8463350584383993`*^9, 3.8463350832915545`*^9}, 
   3.8463356730391445`*^9, {3.8463357330577507`*^9, 3.846335734677639*^9}, {
   3.8463357713912954`*^9, 3.846335784599365*^9}, {3.846335824451017*^9, 
   3.846335850541898*^9}, {3.8465148279290648`*^9, 3.846514905645626*^9}, {
   3.8465149546536207`*^9, 3.8465149557287645`*^9}, 3.8465150347627506`*^9, 
   3.8465150735123754`*^9, 3.846515133355834*^9, {3.846551496354246*^9, 
   3.8465515199215117`*^9}, {3.8465515514860935`*^9, 3.846551558453719*^9}, {
   3.8465516511605453`*^9, 3.8465516816971188`*^9}, {3.8465517493251767`*^9, 
   3.8465517819787836`*^9}, {3.846551812162984*^9, 3.84655181978378*^9}, {
   3.8469012753631597`*^9, 3.8469014245266294`*^9}, {3.846901477101201*^9, 
   3.846901480891117*^9}, 3.846901533852523*^9, {3.8469015653056993`*^9, 
   3.8469015942691755`*^9}, 3.8469016260053563`*^9, {3.846901664939994*^9, 
   3.8469016657155457`*^9}, {3.846901747509447*^9, 3.8469017503170366`*^9}, {
   3.84690191404624*^9, 3.84690193970901*^9}, 3.846901985149589*^9, {
   3.84690203255608*^9, 3.8469020373058805`*^9}, {3.8469021528510695`*^9, 
   3.84690220430954*^9}, {3.8469022448931456`*^9, 3.8469022504597807`*^9}, {
   3.846902285388745*^9, 3.846902288603936*^9}, {3.8469023384879513`*^9, 
   3.846902371933584*^9}, 3.846902765731144*^9, {3.8469028332433987`*^9, 
   3.8469028443561935`*^9}, 3.8469030843801355`*^9, 3.846903160980903*^9, {
   3.8469032059828815`*^9, 3.8469032390870132`*^9}, {3.84690342310567*^9, 
   3.846903439207902*^9}, {3.8469061580301685`*^9, 3.8469062645476227`*^9}, {
   3.8469065486448135`*^9, 3.846906561548581*^9}, {3.8469067471371455`*^9, 
   3.8469068174896765`*^9}, {3.84690686154051*^9, 3.8469068684523077`*^9}, {
   3.8497527618146653`*^9, 3.8497527676380615`*^9}, {3.8497528414079475`*^9, 
   3.849752843454638*^9}, {3.8497530625145917`*^9, 3.849753063032662*^9}, {
   3.8497530971084747`*^9, 3.8497531011988783`*^9}, {3.8497532258666143`*^9, 
   3.849753345755213*^9}, {3.849753924288494*^9, 3.849753985952464*^9}, {
   3.849754069460248*^9, 3.849754087001464*^9}, {3.849754259204835*^9, 
   3.849754268999332*^9}, {3.8497554284565487`*^9, 3.8497554930272894`*^9}, {
   3.849755685279069*^9, 3.8497556896240177`*^9}, {3.8497558773614607`*^9, 
   3.849755877843891*^9}, {3.8497559807269473`*^9, 3.8497560211165953`*^9}, 
   3.850443650520732*^9, {3.8504438404083548`*^9, 3.8504441120345283`*^9}, {
   3.850444156664489*^9, 3.850444280967318*^9}, {3.850444354744196*^9, 
   3.85044463643923*^9}, {3.8504447256702757`*^9, 3.8504447980665684`*^9}, {
   3.8505274395909743`*^9, 3.8505274411181674`*^9}, {3.8505275310510144`*^9, 
   3.8505276349685197`*^9}, {3.850527665564816*^9, 3.850527741150744*^9}, {
   3.850528010969228*^9, 3.8505280914370484`*^9}, {3.850528341539154*^9, 
   3.8505283435766478`*^9}, {3.850528399268195*^9, 3.850528452926201*^9}, {
   3.850528511901552*^9, 3.850528524032834*^9}, {3.8505286008142643`*^9, 
   3.8505286255862675`*^9}, {3.850528657292616*^9, 3.8505287485299587`*^9}, {
   3.850528791091945*^9, 3.8505287912193995`*^9}, {3.8505289892778673`*^9, 
   3.8505290093703814`*^9}, {3.8505291179397283`*^9, 3.850529246368305*^9}, {
   3.8505292847200036`*^9, 3.8505293531238484`*^9}, {3.85052942526715*^9, 
   3.8505295026053452`*^9}, {3.850529652810694*^9, 3.85052969888447*^9}, {
   3.8505297570230837`*^9, 3.8505297793908668`*^9}, {3.8505298130474796`*^9, 
   3.85052982372943*^9}, 3.850529903643921*^9, {3.8505299339680395`*^9, 
   3.850529938523468*^9}, {3.850533467746894*^9, 3.850533696587976*^9}, {
   3.8505337523084393`*^9, 3.8505340100220647`*^9}, {3.850534073301394*^9, 
   3.8505341115212436`*^9}, {3.8505341448690495`*^9, 3.850534244609003*^9}, {
   3.8505342773409953`*^9, 3.850534317485276*^9}, {3.850534376818581*^9, 
   3.8505345375059347`*^9}, 3.8505345895823593`*^9, {3.850534712936541*^9, 
   3.850534853983102*^9}, {3.85053489565536*^9, 3.85053490800423*^9}, {
   3.850535011630887*^9, 3.850535069369616*^9}, {3.8505609789941187`*^9, 
   3.8505609796472797`*^9}, {3.850561024378234*^9, 3.8505611077291512`*^9}, {
   3.8505611554662695`*^9, 3.8505611900834045`*^9}, {3.8505612604815354`*^9, 
   3.850561307036023*^9}, 3.8505614161973686`*^9, {3.850561489892841*^9, 
   3.8505614904828854`*^9}, 3.850561540476676*^9, {3.850566961415826*^9, 
   3.85056699607444*^9}, {3.8505670465401917`*^9, 3.850567067268143*^9}, {
   3.850567124561453*^9, 3.8505671481746936`*^9}, {3.8505671891195374`*^9, 
   3.850567192972233*^9}, {3.8505672404233675`*^9, 3.850567272319547*^9}, {
   3.8505673802869396`*^9, 3.850567388289441*^9}, {3.850567420051065*^9, 
   3.8505674379775977`*^9}, {3.850568113924102*^9, 3.850568121245113*^9}, {
   3.8505681786419373`*^9, 3.8505682190225987`*^9}, {3.8505682742836356`*^9, 
   3.8505682972999997`*^9}, {3.850568330443387*^9, 3.8505683415549088`*^9}, {
   3.850568377492758*^9, 3.850568403154665*^9}, {3.850568837097434*^9, 
   3.850568946787299*^9}, {3.8505691453292117`*^9, 3.850569195539899*^9}, {
   3.8505692859376397`*^9, 3.8505693669331837`*^9}, {3.8505693974289236`*^9, 
   3.8505695475039663`*^9}, {3.8505696079724298`*^9, 
   3.8505696221275873`*^9}, {3.8505697874854712`*^9, 
   3.8505698175396166`*^9}, {3.850569868969412*^9, 3.8505698726296372`*^9}, {
   3.850569905926787*^9, 3.8505699809036593`*^9}, {3.850570015920215*^9, 
   3.85057008172045*^9}, {3.850785556912866*^9, 3.850785616614393*^9}, {
   3.8507856606466494`*^9, 3.850785723209618*^9}, {3.8507857656066175`*^9, 
   3.850785880874487*^9}, {3.850785924508508*^9, 3.850785937300992*^9}, {
   3.8507859750545197`*^9, 3.8507859968100834`*^9}, {3.850786077342246*^9, 
   3.8507860848236823`*^9}, {3.8507861340867023`*^9, 3.8507861374599075`*^9}, 
   3.850786227982345*^9, {3.8507862859910107`*^9, 3.8507863008387175`*^9}, {
   3.850786368316942*^9, 3.850786374976062*^9}, {3.850786423270744*^9, 
   3.850786423425295*^9}, {3.8507865491264324`*^9, 3.850786595976322*^9}, {
   3.850786636570469*^9, 3.850786709325587*^9}, {3.850786743990263*^9, 
   3.8507868015086374`*^9}, {3.8507870134211025`*^9, 
   3.8507870176048164`*^9}, {3.850787059141889*^9, 3.8507870650224657`*^9}, {
   3.850787111878257*^9, 3.850787113157389*^9}, {3.8507887599989805`*^9, 
   3.850788841851822*^9}, {3.850788913491912*^9, 3.8507890311085014`*^9}, {
   3.8507890809695005`*^9, 3.8507890902738066`*^9}, {3.8507891921970196`*^9, 
   3.8507891973037043`*^9}, {3.8507892279462795`*^9, 3.850789249495205*^9}, {
   3.850791412876636*^9, 3.8507914130273633`*^9}, {3.8507915155633483`*^9, 
   3.8507915162424593`*^9}, {3.850827343188859*^9, 3.850827375432101*^9}, {
   3.8508274109868975`*^9, 3.8508274369062905`*^9}, {3.8508274890786314`*^9, 
   3.8508274894138756`*^9}, {3.8508275695516253`*^9, 3.850827569788695*^9}, 
   3.8508276711587315`*^9, {3.8508277166165743`*^9, 3.8508277728386536`*^9}, {
   3.8508278475513325`*^9, 3.8508278753498926`*^9}, {3.8508279408872223`*^9, 
   3.85082794118405*^9}, {3.850827981298354*^9, 3.850828056921221*^9}, {
   3.850828494113824*^9, 3.850828495039543*^9}, {3.85082856023905*^9, 
   3.850828575017256*^9}, {3.850828628892047*^9, 3.850828696248144*^9}, 
   3.8508287630158415`*^9, {3.8508293694951773`*^9, 3.850829372071825*^9}, {
   3.8508294221130056`*^9, 3.8508294474505587`*^9}, {3.8508295136154523`*^9, 
   3.850829546786518*^9}, {3.8508307551495695`*^9, 3.850830755305548*^9}, {
   3.850830846425475*^9, 3.8508308469949007`*^9}, {3.8508328226756153`*^9, 
   3.8508328956454206`*^9}, {3.8515151599360895`*^9, 
   3.8515151854097323`*^9}, {3.851515227511881*^9, 3.8515152691971846`*^9}, {
   3.8517376565999703`*^9, 3.851737660729647*^9}, {3.8517376993937993`*^9, 
   3.851737854226467*^9}, {3.8517379030659018`*^9, 3.851737963592141*^9}, {
   3.8517380004040184`*^9, 3.851738156849004*^9}, {3.8517381881441555`*^9, 
   3.8517383547150526`*^9}, {3.851738403578961*^9, 3.8517384750343685`*^9}, {
   3.8517386329884996`*^9, 3.8517387036807384`*^9}, {3.8517387496128297`*^9, 
   3.8517391066461697`*^9}, 3.851739167106615*^9, {3.851739199324179*^9, 
   3.8517392033202653`*^9}, {3.851739306865944*^9, 3.8517396012506447`*^9}, {
   3.8517396478337793`*^9, 3.851739717012961*^9}, {3.851739779861041*^9, 
   3.8517398251446857`*^9}, {3.8517401674121*^9, 3.85174023031291*^9}, {
   3.8517403822763968`*^9, 3.8517405215277195`*^9}, {3.8517405598035936`*^9, 
   3.8517405807347307`*^9}, 3.8517406111741548`*^9, {3.852771815388609*^9, 
   3.852771815826337*^9}, {3.852771938933034*^9, 3.852772015527173*^9}, {
   3.8527720455326405`*^9, 3.852772051655347*^9}, {3.852772112575083*^9, 
   3.85277216712604*^9}, {3.8527722639917727`*^9, 3.8527723193930345`*^9}, {
   3.8527723507994275`*^9, 3.8527724886441803`*^9}, 3.852772518958836*^9, {
   3.8527726690962496`*^9, 3.8527726724595623`*^9}, {3.852772785224839*^9, 
   3.852772814059412*^9}, {3.8527728536940055`*^9, 3.8527728543197746`*^9}, 
   3.8527728940919833`*^9, {3.8527729250196114`*^9, 3.8527729905347033`*^9}, {
   3.8527730490675783`*^9, 3.8527730529881525`*^9}, {3.852773399558672*^9, 
   3.852773411256092*^9}, {3.852773459331044*^9, 3.852773480723246*^9}, {
   3.8527735251577444`*^9, 3.8527735647772226`*^9}, {3.85277372440212*^9, 
   3.852773727144375*^9}, {3.8528731960002193`*^9, 3.8528733256878357`*^9}, {
   3.852873387704274*^9, 3.852873409884766*^9}, {3.8528734508562613`*^9, 
   3.8528734515817213`*^9}, {3.8528734901873713`*^9, 3.852873528186962*^9}, {
   3.8528735614708843`*^9, 3.8528735812376013`*^9}, {3.8528736531146784`*^9, 
   3.852873677620881*^9}, {3.8528801200331235`*^9, 3.852880146194016*^9}, {
   3.853140879673688*^9, 3.8531409143592653`*^9}, {3.8531409625201416`*^9, 
   3.8531410288764524`*^9}, {3.8531410590292354`*^9, 
   3.8531411087537766`*^9}, {3.906960081539485*^9, 3.9069602331152077`*^9}, {
   3.9069603433707557`*^9, 3.906960421970504*^9}, 3.90696058512084*^9, {
   3.9069606314181366`*^9, 3.906960643357847*^9}, {3.9069606827315874`*^9, 
   3.9069606842067842`*^9}, {3.9069607800459027`*^9, 3.906960789339467*^9}, {
   3.906960946958927*^9, 3.906961015693834*^9}, {3.9069610665773287`*^9, 
   3.9069610942448244`*^9}, {3.906975980921613*^9, 3.906976089812361*^9}, {
   3.9069761287780294`*^9, 3.9069761444527407`*^9}, {3.9069761802392483`*^9, 
   3.9069764111837945`*^9}, {3.9069764723969927`*^9, 
   3.9069764965177555`*^9}, {3.9069765456510816`*^9, 3.906976559809983*^9}, {
   3.9069766596602173`*^9, 3.9069766598802757`*^9}, 3.9069767005917444`*^9, {
   3.906976778520788*^9, 3.906976842147175*^9}, {3.90697690958217*^9, 
   3.906976948797903*^9}, {3.906977008286579*^9, 3.9069770258571725`*^9}, {
   3.9069783088004336`*^9, 3.9069783295883393`*^9}, {3.9069784555681205`*^9, 
   3.9069784736312475`*^9}, {3.9069785149274707`*^9, 
   3.9069785203580103`*^9}, {3.9069785545147533`*^9, 
   3.9069786442875185`*^9}, {3.9069786792021737`*^9, 
   3.9069788093775425`*^9}, {3.906978853786457*^9, 3.906978872127804*^9}, {
   3.906978907937706*^9, 3.9069789439029903`*^9}, {3.906979021341509*^9, 
   3.9069791012891383`*^9}, {3.9069793249639287`*^9, 
   3.9069793698176155`*^9}, {3.9069794500914555`*^9, 
   3.9069794867247863`*^9}, {3.9069795534312057`*^9, 3.906979579384478*^9}, {
   3.9069796794955473`*^9, 3.906979691967578*^9}, {3.90697984152462*^9, 
   3.9069798495662622`*^9}, {3.9069798829331303`*^9, 3.906979892303535*^9}, {
   3.906979929815036*^9, 3.9069799897806015`*^9}, {3.907029838923909*^9, 
   3.9070298429045696`*^9}, 3.907029873049452*^9, {3.9070299082271347`*^9, 
   3.9070299615551324`*^9}, {3.9070300098261147`*^9, 3.907030048469262*^9}, {
   3.907030090835805*^9, 3.907030236396055*^9}, {3.9070302925336046`*^9, 
   3.907030304052057*^9}, {3.907030372815591*^9, 3.9070304865078115`*^9}, {
   3.907030557887286*^9, 3.9070305689133244`*^9}, {3.9070308911683903`*^9, 
   3.907030892187997*^9}, {3.9070604376835546`*^9, 3.907060445993576*^9}, {
   3.9070605369359646`*^9, 3.907060610391075*^9}, {3.9070607652596164`*^9, 
   3.907060779428796*^9}, {3.90706081432941*^9, 3.9070608151924467`*^9}, {
   3.9070608516888237`*^9, 3.907060854768076*^9}, {3.907060944967448*^9, 
   3.907060990845777*^9}, {3.907061076512681*^9, 3.9070611086597958`*^9}, {
   3.9070611484876804`*^9, 3.9070611988926153`*^9}, {3.9070612582075396`*^9, 
   3.907061352628416*^9}, {3.9070614831261873`*^9, 3.9070615845827394`*^9}, {
   3.907061784180231*^9, 3.9070618159858637`*^9}, {3.907061890477336*^9, 
   3.907061943454452*^9}, {3.9071484650166793`*^9, 3.90714866651295*^9}, {
   3.907148762155178*^9, 3.9071488404975348`*^9}, {3.9071488774252872`*^9, 
   3.9071489294181747`*^9}, {3.9071489765577335`*^9, 3.907148976814991*^9}, {
   3.9071491725272875`*^9, 3.907149241274995*^9}, 3.9071493285419173`*^9, {
   3.9071493746789184`*^9, 3.907149483905308*^9}, {3.9071495447705164`*^9, 
   3.907149550473424*^9}, {3.9071495819630795`*^9, 3.90714963340366*^9}, {
   3.9071497225947556`*^9, 3.9071497240775113`*^9}, {3.907149760297258*^9, 
   3.907149761731573*^9}, {3.9071498152856555`*^9, 3.907149875310998*^9}, 
   3.9071499205002947`*^9, {3.9071499577662582`*^9, 3.9071499702396035`*^9}, {
   3.9071500532046795`*^9, 3.9071500682462764`*^9}, {3.907218618548807*^9, 
   3.9072187011296597`*^9}, {3.9072195014873066`*^9, 
   3.9072195025316906`*^9}, {3.90721955313033*^9, 3.907219605997478*^9}, {
   3.9076388883376904`*^9, 3.907639028857774*^9}, {3.9076584642948866`*^9, 
   3.9076584677515554`*^9}, 3.9076585061822867`*^9, {3.9076585847633705`*^9, 
   3.9076586673533773`*^9}, {3.9076587071776705`*^9, 3.907658763185525*^9}, {
   3.907658814220379*^9, 3.9076588335250573`*^9}, {3.907658905205724*^9, 
   3.907658950762456*^9}, {3.907660119522422*^9, 3.9076601635769453`*^9}, 
   3.9126500418645983`*^9, {3.912650272877923*^9, 3.9126503212520823`*^9}, {
   3.912650484389138*^9, 3.912650572012165*^9}, {3.912650656766632*^9, 
   3.9126506581126027`*^9}, {3.9126507259529123`*^9, 3.912650777581822*^9}, 
   3.912651074711319*^9, {3.9126512031248045`*^9, 3.912651213319991*^9}, 
   3.912651703687234*^9, {3.912770083842639*^9, 3.9127701076862574`*^9}, {
   3.9128202786546226`*^9, 3.912820284120411*^9}, 3.9128203334420757`*^9, {
   3.9128203658705187`*^9, 3.91282056892971*^9}, {3.912820649630741*^9, 
   3.912820661602646*^9}, {3.9128206955003443`*^9, 3.912820724768431*^9}, 
   3.9128207658429365`*^9, {3.9128210569191675`*^9, 3.9128210648083296`*^9}, 
   3.9128210964617248`*^9, 3.9128211283606553`*^9, 3.9128212232449136`*^9, 
   3.912821276435539*^9, 3.9128214180597515`*^9, {3.912821544243472*^9, 
   3.9128215499947147`*^9}, {3.9128217996313906`*^9, 
   3.9128218286437273`*^9}, {3.912821877012741*^9, 3.912821923396287*^9}, {
   3.9128219675831423`*^9, 3.9128221124228954`*^9}, {3.912920245593502*^9, 
   3.912920245966591*^9}, {3.9139445874276905`*^9, 3.91394459507491*^9}, {
   3.9139450187138863`*^9, 3.9139450343858995`*^9}, {3.913945205447682*^9, 
   3.913945248472603*^9}, {3.913945412690005*^9, 3.9139455155179462`*^9}, {
   3.913958962378629*^9, 3.9139589785035114`*^9}, {3.9139590402712264`*^9, 
   3.9139590937141848`*^9}, 3.9139750141153145`*^9, {3.9139750744801207`*^9, 
   3.9139751224167085`*^9}, {3.9139752153934174`*^9, 3.91397523521216*^9}, {
   3.9139752681667395`*^9, 3.9139752765309496`*^9}, {3.9139754210256305`*^9, 
   3.91397543855688*^9}, {3.913975474761815*^9, 3.913975549799944*^9}, {
   3.9139756202766843`*^9, 3.913975621473342*^9}, {3.913976355232353*^9, 
   3.9139763564720173`*^9}, 3.913976468052901*^9, {3.913976504313478*^9, 
   3.9139766047022376`*^9}, {3.9139768730666857`*^9, 
   3.9139769991515765`*^9}, {3.9139805364785786`*^9, 
   3.9139805578142247`*^9}, {3.9143020649613595`*^9, 3.914302072021001*^9}, {
   3.914302194959444*^9, 3.914302202483561*^9}, {3.9191390449333115`*^9, 
   3.919139125489049*^9}, {3.9191391862084427`*^9, 3.919139212733096*^9}, {
   3.9191393296015463`*^9, 3.9191393355361643`*^9}, {3.919139393908128*^9, 
   3.9191394603885593`*^9}, 3.919139538292508*^9, {3.9191395898427453`*^9, 
   3.9191395945714526`*^9}, {3.9191397104148407`*^9, 3.9191397261812196`*^9}, 
   3.919139790543318*^9, 3.919139967192321*^9, {3.9191406455936623`*^9, 
   3.919140690845147*^9}, {3.9191407735213203`*^9, 3.9191407743776417`*^9}, {
   3.9191408181117997`*^9, 3.9191408270078845`*^9}, {3.9191408657281303`*^9, 
   3.919140902915256*^9}, {3.9191410060045266`*^9, 3.9191410203172483`*^9}, 
   3.919141070320388*^9, {3.919141163927287*^9, 3.9191411872159586`*^9}, {
   3.9191412577972193`*^9, 3.9191412976368313`*^9}, {3.9191688870873775`*^9, 
   3.919168933052214*^9}, {3.9201182584505105`*^9, 3.920118274636175*^9}, {
   3.9201183148461*^9, 3.920118343218148*^9}, {3.9201784059083443`*^9, 
   3.920178470289201*^9}, {3.920178507855404*^9, 3.9201785455959826`*^9}, {
   3.920178965113888*^9, 3.9201790019678364`*^9}, {3.920248155151059*^9, 
   3.9202483498451767`*^9}, {3.920248389503045*^9, 3.9202483978744574`*^9}, 
   3.9202484386447196`*^9, {3.9202485470386105`*^9, 3.9202485618135386`*^9}, {
   3.9202485937761097`*^9, 3.9202486060898476`*^9}, {3.920248654173068*^9, 
   3.920248687395794*^9}, {3.9202487471821632`*^9, 3.920248757769596*^9}, {
   3.920248836338523*^9, 3.9202488737720094`*^9}, {3.9202489384678183`*^9, 
   3.9202489395783587`*^9}, {3.9202490180745525`*^9, 3.9202490544358435`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {GrayLevel[0.5], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwtlgk41NsbxzFjfvMjoixJKutN15buTLfNHJGUpdKqiCxdeaxdQ7RR2iSk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      "]]}}, {{}, {}, 
    {RGBColor[1, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV1nk4Fe0bB3AOhSJRiNSrxZosFXnV23NQlLU9ScheopSlIllTKWWPbEki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      "]]}}, {{}, {}, 
    {RGBColor[1, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV13k8VHsUAHBm7qhUlJCIlCTlISmJzK/0iISQNrsWL1JCkXloIUqULEkk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      "]]}}, {{{{{InsetBox[
         StyleBox[
          TagBox[
           RowBox[{
            StyleBox[
             SubscriptBox["\[Tau]", "e"],
             FontSize->12], 
            StyleBox["=",
             FontSize->12], 
            StyleBox[" ",
             FontSize->12], 
            RowBox[{
             StyleBox["0.5",
              FontSize->12], 
             StyleBox["  ",
              FontSize->12], 
             StyleBox["ms",
              FontSize->12], " "}]}],
           "RawBoxes"],
          FontFamily->"Arial",
          FontSize->10,
          
          Background->GrayLevel[
           1.]], {-0.9280694326579604, 0.967731616456105}, {Left, Baseline},
         Alignment->{Left, Top}], InsetBox[
         StyleBox[
          TagBox[
           RowBox[{
            StyleBox[
             SubscriptBox["\[Tau]", "d"],
             FontSize->12], 
            StyleBox["=",
             FontSize->12], 
            StyleBox[" ",
             FontSize->12], 
            RowBox[{
             StyleBox["0.8",
              FontSize->12], 
             StyleBox["  ",
              FontSize->12], 
             StyleBox["ms",
              FontSize->12], " "}]}],
           "RawBoxes"],
          FontFamily->"Arial",
          FontSize->10,
          
          Background->GrayLevel[
           1.]], {-0.9338290698461684, 0.5788427275672172}, {Left, Baseline},
         Alignment->{Left, Top}]}, InsetBox[
        RowBox[{"\[Theta]", "=", 
         RowBox[{"-", "1"}]}], {-0.958160135605806, 1.3636661807580142`}, {
        Left, Baseline},
        Alignment->{Left, Top}]}, InsetBox[
       StyleBox[
        TagBox[
         RowBox[{
          SubscriptBox[
           StyleBox["v",
            FontFamily->"Arial",
            FontSize->12,
            FontWeight->"Plain",
            FontSlant->"Plain",
            FontVariations->{"StrikeThrough"->False,
            "Underline"->False}], 
           RowBox[{"r", " "}]], 
          StyleBox["=",
           FontSize->12], 
          StyleBox[" ",
           FontSize->12], 
          RowBox[{
           StyleBox["0.2",
            FontSize->12], 
           StyleBox[" ",
            FontSize->12], 
           RowBox[{
            StyleBox["mV",
             FontSize->12], 
            StyleBox["/",
             FontSize->12], 
            StyleBox["s",
             FontSize->12], " "}]}]}],
         "RawBoxes"],
        FontFamily->"Arial",
        FontSize->10,
        Background->GrayLevel[
         1.]], {-0.9641125165581866, 0.19505587949465553`}, {Left, Baseline},
       Alignment->{Left, Top}]}, 
     {RGBColor[1., 0.32153022506559453`, 0.], AbsoluteThickness[2], 
      Arrowheads[{{0.042072662838444415`, 1, {
          GraphicsBox[{
            EdgeForm[None], 
            Dashing[{}], 
            PolygonBox[{{-1, 0.5}, {0, 0}, {-1, -0.5}}]}], 0.98}}}], 
      StrokeForm[RGBColor[0, 0.501961, 0.501961]], EdgeForm[{RGBColor[
      0., 0.5019607843137255, 0.5019607843137255], Opacity[1.], 
      AbsoluteThickness[2]}], EdgeForm[None], 
      ArrowBox[{{-0.4523474583626995, 
       1.0191473334020984`}, {-0.6526091507899645, 1.6756392980717534`}}]}}, 
    {RGBColor[1., 0.32153022506559453`, 0.], AbsoluteThickness[2], 
     Arrowheads[{{0.042072662838444415`, 1, {
         GraphicsBox[{
           EdgeForm[None], 
           Dashing[{}], 
           PolygonBox[{{-1, 0.5}, {0, 0}, {-1, -0.5}}]}], 0.98}}}], 
     StrokeForm[RGBColor[0, 0.501961, 0.501961]], EdgeForm[{RGBColor[
     0., 0.5019607843137255, 0.5019607843137255], Opacity[1.], 
     AbsoluteThickness[2]}], EdgeForm[None], 
     ArrowBox[{{-0.4324447203839775, 
      2.6373088386097905`}, {-0.22794450804933813`, 1.9842769937556402`}}]}}},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{-1., 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(u\\), \\(g\\)]\\) (V)\"", FontSize -> 20, 
      StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(I\\), \\(d\\)]\\) (\[Mu]A)\"", FontSize -> 
      20, StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, {{-4, 
      FormBox[
       RowBox[{"-", "4"}], TraditionalForm]}, {-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImagePadding->{{41., 25.}, {55., 24.}},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{-1., 0.1}, {-0.5, 3.2}},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic]], "Input",
 CellChangeTimes->{{3.9202490604875164`*^9, 3.920249088596271*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {GrayLevel[0.5], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwtlgk41NsbxzFjfvMjoixJKutN15buTLfNHJGUpdKqiCxdeaxdQ7RR2iSk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      "]]}}, {{}, {}, 
    {RGBColor[1, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwVl3c81f/3wK0UGaUkI0koChHpQzm3T0MhKons5KO+ZhQllBQqGkaJrJaV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      "]]}}, {{}, {}, 
    {RGBColor[1, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV1nk8VGsYB3DrnCRkzVbSRZRQV7Rx3lSiusiSuNFClmhIcYUoRUmhriWF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      "]]}}, {{{{{InsetBox[
         StyleBox[
          TagBox[
           RowBox[{
            StyleBox[
             SubscriptBox["\[Tau]", "e"],
             FontSize->12], 
            StyleBox["=",
             FontSize->12], 
            StyleBox[" ",
             FontSize->12], 
            RowBox[{
             StyleBox["0.5",
              FontSize->12], 
             StyleBox["  ",
              FontSize->12], 
             StyleBox["ms",
              FontSize->12], " "}]}],
           "RawBoxes"],
          FontFamily->"Arial",
          FontSize->10,
          
          Background->GrayLevel[
           1.]], {-0.9430354190525183, 0.9857102364755392}, {Left, Baseline},
         Alignment->{Left, Top}], InsetBox[
         StyleBox[
          TagBox[
           RowBox[{
            StyleBox[
             SubscriptBox["\[Tau]", "d"],
             FontSize->12], 
            StyleBox["=",
             FontSize->12], 
            StyleBox[" ",
             FontSize->12], 
            RowBox[{
             StyleBox["0.1",
              FontSize->12], 
             StyleBox["  ",
              FontSize->12], 
             StyleBox["ms",
              FontSize->12], " "}]}],
           "RawBoxes"],
          FontFamily->"Arial",
          FontSize->10,
          
          Background->GrayLevel[
           1.]], {-0.9487950562407264, 0.5968213475866515}, {Left, Baseline},
         Alignment->{Left, Top}]}, InsetBox[
        RowBox[{"\[Theta]", "=", 
         RowBox[{"-", "1"}]}], {-0.8982961900275748, 1.4715379008746305`}, {
        Left, Baseline},
        Alignment->{Left, Top}]}, InsetBox[
       StyleBox[
        TagBox[
         RowBox[{
          SubscriptBox[
           StyleBox["v",
            FontFamily->"Arial",
            FontSize->12,
            FontWeight->"Plain",
            FontSlant->"Plain",
            FontVariations->{"StrikeThrough"->False,
            "Underline"->False}], 
           RowBox[{"r", " "}]], 
          StyleBox["=",
           FontSize->12], 
          StyleBox[" ",
           FontSize->12], 
          RowBox[{
           StyleBox["0.4",
            FontSize->12], 
           StyleBox[" ",
            FontSize->12], 
           RowBox[{
            StyleBox["mV",
             FontSize->12], 
            StyleBox["/",
             FontSize->12], 
            StyleBox["s",
             FontSize->12], " "}]}]}],
         "RawBoxes"],
        FontFamily->"Arial",
        FontSize->10,
        Background->GrayLevel[
         1.]], {-0.9790785029527446, 0.21303449951408981`}, {Left, Baseline},
       Alignment->{Left, Top}]}, 
     {RGBColor[1., 0.32153022506559453`, 0.], AbsoluteThickness[2], 
      Arrowheads[{{0.042072662838444415`, 1, {
          GraphicsBox[{
            EdgeForm[None], 
            Dashing[{}], 
            PolygonBox[{{-1, 0.5}, {0, 0}, {-1, -0.5}}]}], 0.98}}}], 
      StrokeForm[RGBColor[0, 0.501961, 0.501961]], EdgeForm[{RGBColor[
      0., 0.5019607843137255, 0.5019607843137255], Opacity[1.], 
      AbsoluteThickness[2]}], EdgeForm[None], 
      ArrowBox[{{-0.38125902298854986`, 
       0.7854252731494242}, {-0.5628132324226176, 1.5138317178968235`}}]}}, 
    {RGBColor[1., 0.32153022506559453`, 0.], AbsoluteThickness[2], 
     Arrowheads[{{0.042072662838444415`, 1, {
         GraphicsBox[{
           EdgeForm[None], 
           Dashing[{}], 
           PolygonBox[{{-1, 0.5}, {0, 0}, {-1, -0.5}}]}], 0.98}}}], 
     StrokeForm[RGBColor[0, 0.501961, 0.501961]], EdgeForm[{RGBColor[
     0., 0.5019607843137255, 0.5019607843137255], Opacity[1.], 
     AbsoluteThickness[2]}], EdgeForm[None], 
     ArrowBox[{{-0.3875467612003042, 
      2.5474157385126066`}, {-0.1830465488656648, 1.8943838936584563`}}]}}},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{-1., 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(u\\), \\(g\\)]\\) (V)\"", FontSize -> 20, 
      StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(I\\), \\(d\\)]\\) (\[Mu]A)\"", FontSize -> 
      20, StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, {{-4, 
      FormBox[
       RowBox[{"-", "4"}], TraditionalForm]}, {-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImagePadding->{{41., 25.}, {55., 24.}},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{-1., 0.1}, {-0.5, 3.2}},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic]], "Input",
 CellChangeTimes->{{3.920248955177286*^9, 3.920248973879757*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {GrayLevel[0.5], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwtlgk41NsbxzFjfvMjoixJKutN15buTLfNHJGUpdKqiCxdeaxdQ7RR2iSk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      "]]}}, {{}, {}, 
    {RGBColor[1, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwVl3c81f/3wK0UGaUkI0koChHpQzm3T0MhKons5KO+ZhQllBQqGkaJrJaV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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV1nk8VGsYB3DrnCRkzVbSRZRQV7Rx3lSiusiSuNFClmhIcYUoRUmhriWF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      "]]}}, InsetBox[
    RowBox[{"\[Theta]", "=", 
     RowBox[{"-", "1"}]}], {-0.15816326530612246`, 2.426919339164236}, {
    Left, Baseline},
    Alignment->{Left, Top}]},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{-1., 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(u\\), \\(g\\)]\\) (V)\"", FontSize -> 20, 
      StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(I\\), \\(d\\)]\\) (\[Mu]A)\"", FontSize -> 
      20, StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, {{-4, 
      FormBox[
       RowBox[{"-", "4"}], TraditionalForm]}, {-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImagePadding->{{41., 25.}, {55., 24.}},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{-1., 0.1}, {-0.5, 3.2}},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic]], "Input",
 CellChangeTimes->{{3.9202489299467645`*^9, 3.9202489326179323`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {GrayLevel[0.5], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwtlgk41NsbxzFjfvMjoixJKutN15buTLfNHJGUpdKqiCxdeaxdQ7RR2iSk
UpaICnEjtKP3tChri+WGiVIhy8z8jGlMhP/8n///PM95znOe55z3fc/n+55z
Xn2fUDd/BTk5uXJZ/+/4v8bEGWdvdCVZaOMypwT2yl8EXrjLRqdDXxv7XNEI
jpQSuL54U6uRpjZ+aWHaOUwRuKg5pQ5PaOHTnm73OnoIfLWce1+pTgurVt4M
qHhBYLuRJ0/6fLXwvMj17/edJvAmXmc1ztDEy4ZT85pUCezkoj/KUNHAq6yk
xzaTDKz0lmsi/1INVyx84WWqqYgvcBO+3slUxv65z7c2GNNxfDdntEmegXuj
L8UbGtBwSJFV2OPf5fCHqYYHby0V8OCOV91Vgz/gCq/N0NpUHht0lKsc2NgH
qY4a+Xt+k8PPbMqrqJRymHoRtu1p8BSUqlgrNRzp5nDzPVt/9/sFOzpzVzbH
U5w3PZo7bY+Mg6HX9D9hVlLOtdXLGEM5Ujjys09aPHOaQ66fNJXPkABb63m9
B08BZSTlGESkSqA19rjVUJ8CMmu11e1PkID7jNviAyIF5Op1akbTIQkoN384
E0LSUCp3pvCqpwRea8+M0FxGQ/Py9O9Z6Uug+X5Ox/wLNGQ1sdbGu/AHKF90
4yogOtp5J8kNHojhzZTDY/oZRVR4kphMLhHDF2/myNVURST1jC3wzheDem0i
3/CaIrqieuCXfJoYLDJ3aMwvV0T/hm7Lt+eKQeIUbZXHU0RbrOeN1y0Vw23X
sVlfzBjI9eHt3Na7o6DRrlY09ZqBspMNnG8VjkLRYY1e9/cMJPgrU8K9PgoF
Zq9KijoZ6Pyc807aKaOwtYAGZnwGaowO++EeOgp6opxjZeoEWr9q2fpP5qNA
fty/vXwngeyfvaQGikRw2CD7oHk3gbRs+oc+54kgbmkIMdFLoP4nZP+HDBHY
p0ufVPEJlHDPtasmQQS9NVKHeZMEelfQXpcbKILx6Cvd63WZyCNpOM99sQgS
FhaYuWxjIgvlmdmbDETwKkbvny0eTDR9ekn6urkiOBIxPensy0R5cZHJLCUR
9PPm3tMOZ6LvEXKH1QdHoNvB/JRSIhNxd2tsq7s9Aq1P48OdgYkc2tmbcO4I
FPz0GzhQw0Rztrk7PUwfga8OGzcmNDBRlWu27a2zsv2Lz7ic+8BECmsWWcTt
HwFevXnxewETJS1aRSw3HQHvG+2k41wSed/ao2ClPwLZx1pqAxaQaIlB3KSJ
zgj4cBsDo4xI1Kr7alSDHIEz5zNcPC1INHfmps/Udwp6Ag+m29mSaPjcAV7/
ZwrcFK6fa1hLomrm5X+72ylgLjozarNBZl+hs7GxloL3Czqy+txIlP/D93Fh
IQVx/C5Hc18S8XLSty7OpeD0s/7QF/tIpLbhrbA4nYIPGYzD9oEkisleYVKa
QEFk8U0rxXASlTqGPbM6QUG2Xe59uwgSfRPd8ig/RIFFZU1bYBSJXNepX7wf
REHf809KYUdIdGLEwWKZPwXKS0QnnGNJ9CjzcN0jTwqO3uW5q54gkQHVP13p
SoGmdW396jMk2pGhl7l6HQXD4e6fChNIlGi/hQ0cChqDKCtxIonGrj4Nem5F
wW6tpn7DCyQysxMT9qYU+FouiKRdJNFevumNGn0Kuo3MVjy+RKK0K1426+ZS
EGH2G0ZpJGqwvdxRO4sClbrx6otXSCQ3XB+xQZmCkCSJQ+FVErHS5NQaaRQY
F1icDUyX8Y8N2p4pFYLdtn1+QbI5p+1DYvaAEM6/Vj9aLFtfZGr3IrdTCDp6
md+uyOxpHC35ebNBCAHsg7fXyvwdbdaxKqwSws8vbQ1PZfF8Nzm5r/iOEETB
KJuUxet2iMoqyRaCtsmq9MWy81S93d1SliyE4JERPeNkEqUctEaPwoWQurxe
clfGY7zxWmSljxC4T+KdHWS8/PTJO0+3CCFkzfe/qk+S6M/6Tzo1LCGc3mtv
ul3Gu0f3/Oj7nwII8Jxd5irTyzlMato2KICgFudDajI9H7z09W7nCUAlv/p4
ZTCJEoJXNHVXCyDY2zDrrSwfrKE/fyhOAA46v82Y2kGirNlbugQHBBB9ItBy
zlYSMQKezhb5CuBTAeW6YBOJOtUux0rXCmBz9KmvP9bJ9PdZs0tRSQBh8rmz
m9gynorXVBak8sEjoVTsqU6iymP3C7ri+LC7C+VMKpMo72eTbVY4Hz5e1Lh1
jkGiMP4UV2czHx76bMj7e4KJZrR5d89W44OtkqtG9Dcmsr9pVMpMGgZ1up/S
8Qomur/mn02is0MQo4a6kxyYKKvq5eDd6CG4qTrT2onDRPHsrvjQ/UOgI+UG
jy9jIrfFqo+HHYfgWUnp2BJTJhKoh+n3E0Pw96qAWkKZiUx6lop4JwfB3+9c
uHcjgdKOVV6siRuAnUUtIfYOsvdr63hw+oEBKHH0nJ5jQyDRouWOwb4D8OyU
WOMbi0CuzQ9+aawdAL37z8c9jQlEGJf7+zEHoH+rYUcPjUAH6wuX0ZK/g5dO
WIU1MNAuzTQeyuoHSNNxWm7JQHrFYYZVD3rhmb2iWbKEjhxveex1yu+Fuu2u
vKAhOorIcczpvNwLIhXPUtvPdFR/caHuz4heMNer6nlXR0eRh9/NYi/thdrQ
05ansujojYuVwt3Sb+D2pGKVm+z/OEoJP98o/AouJsXXM+NoqJsVmn0uowcU
U7U3LhqWR1q02I8MQx6obt9TWiz+xZmYdE1Oy2yBJe/r4980/eAUhOxdcvfr
K7jF3P25pWiQ8zB36nbT5RL4IFi6YuGfLZzAAD+j61Z3ONH7cdQJ/3fw1Cvx
rdfx1xxe21MH49vDYBza/LB4cwuHTTe4MO4jBanQqYwbz+NEGp5VmvVdHsdE
pcRG1fZwzo0wndk1BLZe+22+39leTkRI1h07rgouqxC8j8oc4Oi2fQw5wlfH
gWE+h1YG8DlD+4ayj9I1sa5EPmAoheK4Ti88rmY0B/vRS7Kc00QcsdHNPd9z
dXH946RGxWgxJ8huRm3jxHx8CepPucVLOD5T5cppu/XxoaCVq8aCpJyJ45nV
NsaGeFi65jXhPM6Z0sxSOU8ZYdx262PxFhmXmEAVL4EJLnNfzS/4c4qT0Lnu
W0frIkzTnvNS11AO7RxrP7hPuBiPUh6HdYzlUQK94pW/sjkOn7/K+oWmAqra
nbz91wxLrC92vPNgLg3FRJE3WHlW2FuPMt6uSkcVXpLlo6VLsN8Dn7O/T9LR
tFqzbneVNU4fUyjfIMdAUTtpN5J7l2LPxNXtmiIGiqeMf45N/YHN0j7GukgY
yISb4z9IY+HxnEOmJ8cZSPyHx6IuJgtfrXgcI1YgUMXA6bsvZrFwcydLr2U2
gRpp9IZLJizsYGrhkyLLY7uacMN1rixs8Wr+sFI0gYL6opYPX2PhX2+rL605
QiD/cVXfgTwWbujwWB0TR6DoAssvfQUsHMDPSBo4S6CmPsnnL2UsnKehvaQ2
g0Alwl+fumtYWNt3ZuTJKtm9uTzY3cdn4b6gkvnVmEB/5YXsGRCx8L1Il9fi
lwSSLtVfOjzGwm4J5+b4NRHIYP0ETyTPxollROUaWd2w27x3MV2LjXdV5vvG
fCHQNWfOFlKXjU1r1s4o7yNQYkvGO9WFbPyq/YSnvpBAjBxO/dzFbHzpiwHD
fZRAmbePOOhbsrHv8LOSlDECTRbkay/6g42tJd47aicI9GP63mrL5Wz8/3oY
hc658Yhtw8b/AXmcf1M=
      "]]}}, {{}, {}, 
    {RGBColor[1, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV1nc8lfsfAHAjRaEIpSFJoqEiGhef46aiQdmU0ZKo6Nd1o0hCRWSGKCQS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      "]]}}, {{}, {}, 
    {RGBColor[1, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV13k4VV0XAHDDuVF9ikKlhGtISqlEEWebZZ4zpiSlV8VbJLqRECEVkczl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      "]]}}, {{{{InsetBox[
        StyleBox[
         TagBox[
          RowBox[{
           StyleBox[
            SubscriptBox["\[Tau]", "e"],
            FontSize->12], 
           StyleBox["=",
            FontSize->12], 
           StyleBox[" ",
            FontSize->12], 
           RowBox[{
            StyleBox["0.5",
             FontSize->12], 
            StyleBox["  ",
             FontSize->12], 
            StyleBox["ms",
             FontSize->12], " "}]}],
          "RawBoxes"],
         FontFamily->"Arial",
         FontSize->10,
         Background->GrayLevel[
          1.]], {-0.9339929981597088, 0.9112811791383248}, {Left, Baseline},
        Alignment->{Left, Top}], InsetBox[
        StyleBox[
         TagBox[
          RowBox[{
           StyleBox[
            SubscriptBox["\[Tau]", "d"],
            FontSize->12], 
           StyleBox["=",
            FontSize->12], 
           StyleBox[" ",
            FontSize->12], 
           RowBox[{
            StyleBox["0.8",
             FontSize->12], 
            StyleBox["  ",
             FontSize->12], 
            StyleBox["ms",
             FontSize->12], " "}]}],
          "RawBoxes"],
         FontFamily->"Arial",
         FontSize->10,
         Background->GrayLevel[
          1.]], {-0.9397526353479169, 0.5223922902494371}, {Left, Baseline},
        Alignment->{Left, Top}]}, InsetBox[
       RowBox[{"\[Theta]", "=", 
        RowBox[{"-", "1"}]}], {-0.8892537691347653, 1.3971088435374162`}, {
       Left, Baseline},
       Alignment->{Left, Top}]}, InsetBox[
      StyleBox[
       TagBox[
        RowBox[{
         SubscriptBox[
          StyleBox["v",
           FontFamily->"Arial",
           FontSize->12,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontVariations->{"StrikeThrough"->False,
           "Underline"->False}], 
          RowBox[{"r", " "}]], 
         StyleBox["=",
          FontSize->12], 
         StyleBox[" ",
          FontSize->12], 
         RowBox[{
          StyleBox["0.2",
           FontSize->12], 
          StyleBox[" ",
           FontSize->12], 
          RowBox[{
           StyleBox["mV",
            FontSize->12], 
           StyleBox["/",
            FontSize->12], 
           StyleBox["s",
            FontSize->12], " "}]}]}],
        "RawBoxes"],
       FontFamily->"Arial",
       FontSize->10,
       Background->GrayLevel[
        1.]], {-0.9700360820599351, 0.13860544217687543`}, {Left, Baseline},
      Alignment->{Left, Top}]}, 
    {RGBColor[1., 0.32153022506559453`, 0.], AbsoluteThickness[2], 
     Arrowheads[{{0.042072662838444415`, 1, {
         GraphicsBox[{
           EdgeForm[None], 
           Dashing[{}], 
           PolygonBox[{{-1, 0.5}, {0, 0}, {-1, -0.5}}]}], 0.98}}}], 
     StrokeForm[RGBColor[0, 0.501961, 0.501961]], EdgeForm[{RGBColor[
     0., 0.5019607843137255, 0.5019607843137255], Opacity[1.], 
     AbsoluteThickness[2]}], EdgeForm[None], 
     ArrowBox[{{-0.37221660209574037`, 
      0.7109962158122098}, {-0.5724782945230054, 1.3674881804818648`}}]}}, 
   {RGBColor[1., 0.32153022506559453`, 0.], AbsoluteThickness[2], 
    Arrowheads[{{0.042072662838444415`, 1, {
        GraphicsBox[{
          EdgeForm[None], 
          Dashing[{}], 
          PolygonBox[{{-1, 0.5}, {0, 0}, {-1, -0.5}}]}], 0.98}}}], StrokeForm[
    RGBColor[0, 0.501961, 0.501961]], EdgeForm[{RGBColor[
    0., 0.5019607843137255, 0.5019607843137255], Opacity[1.], 
    AbsoluteThickness[2]}], EdgeForm[None], 
    ArrowBox[{{-0.3785043403074947, 2.472986681175392}, {-0.1740041279728553, 
     1.8199548363212419`}}]}},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(u\\), \\(g\\)]\\) (V)\"", FontSize -> 20, 
      StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(I\\), \\(d\\)]\\) (\[Mu]A)\"", FontSize -> 
      20, StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, {{-4, 
      FormBox[
       RowBox[{"-", "4"}], TraditionalForm]}, {-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImagePadding->{{41., 25.}, {55., 24.}},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{-1., 0.}, {-0.5, 3.}},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic]], "Input",
 CellChangeTimes->{{3.9202487128177257`*^9, 3.9202487297086773`*^9}, {
  3.920248771285089*^9, 3.920248803553816*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Theta]", "=", "1"}], ";", " ", 
  RowBox[{"\[Tau]e", "=", "0.5"}], ";", 
  RowBox[{"\[Tau]d", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vr", "=", "0.4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", " ", "=", " ", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Tau]d", " ", "vr", " ", 
         RowBox[{
          RowBox[{"M", "'"}], "[", "u", "]"}]}], " ", "\[Equal]", 
        RowBox[{
         RowBox[{
          RowBox[{"2", "/", "3"}], "N0", "  ", 
          RowBox[{"Abs", "[", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox[
              RowBox[{"u", "-", "EV"}], "kT"], ")"}], 
            RowBox[{"3", "/", "2"}]], "  ", "]"}]}], "-", 
         RowBox[{"M", "[", "u", "]"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"M", "[", "uvH", "]"}], "\[Equal]", 
        RowBox[{"Meq", "[", "uvH", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", "M", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"Mv1", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{"M", "[", "uv1", "]"}], "]"}], "/.", "sol"}], "}"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gh1", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[Theta]"}], " ", "L", " ", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"P0", "-", 
                RowBox[{"M", "[", "u", "]"}]}], ")"}], "/", "\[Tau]e"}]}], 
            "+", 
            RowBox[{"L", " ", 
             RowBox[{"f", "/", "\[Tau]d"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Meq", "[", "u", "]"}], "-", 
               RowBox[{"M", "[", "u", "]"}]}], ")"}]}]}], "}"}], "/.", 
          "sol"}], "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Magenta"}], 
          "}"}], "}"}]}], ",", 
       RowBox[{"BaseStyle", "->", 
        RowBox[{"{", 
         RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<u\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(tot\)]\)\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
          ",", "\"\<\>\""}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}]}], "]"}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", " ", "=", " ", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Tau]d"}], " ", "vr", " ", 
         RowBox[{
          RowBox[{"M", "'"}], "[", "u", "]"}]}], " ", "\[Equal]", 
        RowBox[{
         RowBox[{
          RowBox[{"2", "/", "3"}], "N0", "  ", 
          RowBox[{"Abs", "[", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox[
              RowBox[{"u", "-", "EV"}], "kT"], ")"}], 
            RowBox[{"3", "/", "2"}]], "  ", "]"}]}], "-", 
         RowBox[{"M", "[", "u", "]"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"M", "[", "uv1", "]"}], "\[Equal]", "Mv1"}]}], "}"}], ",", 
     RowBox[{"{", "M", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"Mv2", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{"M", "[", "uvH", "]"}], "]"}], "/.", "sol"}], "}"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gh2", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[Theta]"}], " ", "L", " ", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"P0", "-", 
                RowBox[{"M", "[", "u", "]"}]}], ")"}], "/", "\[Tau]e"}]}], 
            "+", 
            RowBox[{"L", " ", 
             RowBox[{"f", "/", "\[Tau]d"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Meq", "[", "u", "]"}], "-", 
               RowBox[{"M", "[", "u", "]"}]}], ")"}]}]}], "}"}], "/.", 
          "sol"}], "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Blue"}], "}"}],
          "}"}]}], ",", 
       RowBox[{"BaseStyle", "->", 
        RowBox[{"{", 
         RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<u\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(tot\)]\)\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
          ",", "\"\<\>\""}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}]}], "]"}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", " ", "=", " ", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Tau]d", " ", "vr", " ", 
         RowBox[{
          RowBox[{"M", "'"}], "[", "u", "]"}]}], " ", "\[Equal]", 
        RowBox[{
         RowBox[{
          RowBox[{"2", "/", "3"}], "N0", "  ", 
          RowBox[{"Abs", "[", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox[
              RowBox[{"u", "-", "EV"}], "kT"], ")"}], 
            RowBox[{"3", "/", "2"}]], "  ", "]"}]}], "-", 
         RowBox[{"M", "[", "u", "]"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"M", "[", "uvH", "]"}], "\[Equal]", "Mv2"}]}], "}"}], ",", 
     RowBox[{"{", "M", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"Mv1", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{"M", "[", "uv1", "]"}], "]"}], "/.", "sol"}], "}"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gh3", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[Theta]"}], " ", "L", " ", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"P0", "-", 
                RowBox[{"M", "[", "u", "]"}]}], ")"}], "/", "\[Tau]e"}]}], 
            "+", 
            RowBox[{"L", " ", 
             RowBox[{"f", "/", "\[Tau]d"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Meq", "[", "u", "]"}], "-", 
               RowBox[{"M", "[", "u", "]"}]}], ")"}]}]}], "}"}], "/.", 
          "sol"}], "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Blue"}], "}"}],
          "}"}]}], ",", 
       RowBox[{"BaseStyle", "->", 
        RowBox[{"{", 
         RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<u\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(tot\)]\)\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
          ",", "\"\<\>\""}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}]}], "]"}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"io1", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"uv", ",", 
       RowBox[{"Idc", "[", "uv", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"uv", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "10"}], ",", "10000"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\!\(\*SubscriptBox[\(u\), \(g\)]\) (V)\>\"", ",", 
          RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(d\)]\) (\[Mu]A)\>\"", ",", 
          RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
        ",", "\"\<\>\""}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3"}], ",", 
          RowBox[{"-", "2"}], ",", 
          RowBox[{"-", "1"}], ",", 
          RowBox[{"-", "0.5"}], ",", "0", ",", "0.5", ",", "1", ",", "2", ",",
           "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", 
          RowBox[{"-", "3"}], ",", 
          RowBox[{"-", "2"}], ",", 
          RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", "3"}], "}"}],
         ",", "None", ",", "None"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Gray"}], "}"}], 
       "}"}]}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "0.7"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"90", " ", "4`"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{"io1", ",", "gh2", ",", "gh3", ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"uv0", ",", 
         RowBox[{"uv1", "+", "0.2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5", ",", 
         RowBox[{"-", "3.2"}]}], "}"}]}], "}"}]}], ",", 
    RowBox[{"BaseStyle", "->", 
     RowBox[{"{", 
      RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.8390646611298313`*^9, 3.839064663549252*^9}, {
   3.8390651628201227`*^9, 3.8390651698744855`*^9}, {3.8390671245340233`*^9, 
   3.839067253968177*^9}, {3.8390672908692884`*^9, 3.8390673435588245`*^9}, {
   3.839067444277615*^9, 3.8390674530816755`*^9}, {3.839067483223913*^9, 
   3.8390676448632746`*^9}, {3.839067792030848*^9, 3.8390679296503277`*^9}, {
   3.839068035965031*^9, 3.8390681198292847`*^9}, {3.8390709139116144`*^9, 
   3.8390709421089935`*^9}, {3.83907099038449*^9, 3.8390709930117693`*^9}, {
   3.839071053413534*^9, 3.839071065617492*^9}, {3.839071142245447*^9, 
   3.8390712315177836`*^9}, {3.839071262559967*^9, 3.8390713000871944`*^9}, {
   3.8390714971122246`*^9, 3.839071517359198*^9}, {3.8390715485300074`*^9, 
   3.8390716200472517`*^9}, {3.8390716672806673`*^9, 3.839071782347397*^9}, {
   3.839071837937226*^9, 3.839071939311781*^9}, {3.839072168081314*^9, 
   3.839072168581891*^9}, {3.8390723168444653`*^9, 3.8390724465495067`*^9}, {
   3.8390724871236815`*^9, 3.839072628537404*^9}, {3.8390726857581015`*^9, 
   3.83907270608572*^9}, {3.8390728526632924`*^9, 3.8390730714112225`*^9}, {
   3.839082271666379*^9, 3.8390823055073657`*^9}, {3.839082353119522*^9, 
   3.839082449840514*^9}, {3.8390839765348864`*^9, 3.839084057466158*^9}, {
   3.8390840878065057`*^9, 3.8390841778809776`*^9}, {3.8390842363292522`*^9, 
   3.8390842982497163`*^9}, 3.83908433029414*^9, {3.8390843708346243`*^9, 
   3.8390844315092807`*^9}, 3.839084462612833*^9, {3.8390845298830824`*^9, 
   3.839084537171591*^9}, {3.8390846234607463`*^9, 3.839084639769829*^9}, {
   3.839085385972989*^9, 3.8390853976007433`*^9}, {3.8390854555897675`*^9, 
   3.839085524444199*^9}, {3.839085565738154*^9, 3.8390855920819826`*^9}, {
   3.8390863447286386`*^9, 3.839086474045252*^9}, {3.839086860852067*^9, 
   3.839086874816577*^9}, {3.839087637034748*^9, 3.8390876843714943`*^9}, 
   3.83908780285631*^9, 3.8390878367914057`*^9, {3.839088015231053*^9, 
   3.8390880802460375`*^9}, {3.839088241208177*^9, 3.839088251058446*^9}, 
   3.839088396382834*^9, 3.8391182307918463`*^9, {3.839118379381566*^9, 
   3.8391183868618546`*^9}, {3.839118542781612*^9, 3.839118576690755*^9}, {
   3.839119230679368*^9, 3.8391192435152392`*^9}, {3.8391193005384474`*^9, 
   3.839119322077612*^9}, {3.8391197370496492`*^9, 3.839119744561663*^9}, {
   3.839119780647091*^9, 3.8391198576053133`*^9}, {3.83913747847266*^9, 
   3.839137485481214*^9}, {3.8391375587687283`*^9, 3.8391375797199593`*^9}, {
   3.8391376276780567`*^9, 3.8391376620779104`*^9}, {3.83913835785732*^9, 
   3.839138374216883*^9}, 3.8391384110040264`*^9, {3.8391384624942074`*^9, 
   3.839138462879356*^9}, {3.8391385170099597`*^9, 3.839138536349577*^9}, {
   3.839139183554804*^9, 3.8391391930138044`*^9}, {3.8391393033973885`*^9, 
   3.8391393043613095`*^9}, 3.839139359067504*^9, 3.839139436240513*^9, {
   3.8392078031308994`*^9, 3.8392078143543434`*^9}, {3.8392078889566584`*^9, 
   3.83920790820275*^9}, {3.839208054761527*^9, 3.839208093399903*^9}, {
   3.8392084092575808`*^9, 3.8392084620514746`*^9}, 3.839208533536579*^9, {
   3.8392086070037084`*^9, 3.8392086083290124`*^9}, 3.8392086479255266`*^9, {
   3.8392225965883913`*^9, 3.8392226283136573`*^9}, {3.8392226646362276`*^9, 
   3.8392227421040397`*^9}, 3.8392227767756677`*^9, {3.8392228326927814`*^9, 
   3.839222892911393*^9}, 3.8392230743763013`*^9, {3.839223141092394*^9, 
   3.839223141783134*^9}, 3.839223177642132*^9, {3.8392232273840017`*^9, 
   3.8392232854596047`*^9}, {3.8392233573873816`*^9, 3.839223398790718*^9}, {
   3.8392234505961695`*^9, 3.839223507183962*^9}, {3.839223811017748*^9, 
   3.8392239510950837`*^9}, {3.8392240167007127`*^9, 3.839224025275307*^9}, {
   3.8392241057509785`*^9, 3.839224157437503*^9}, {3.839224200897134*^9, 
   3.8392242487597456`*^9}, {3.839224294917468*^9, 3.839224296013791*^9}, {
   3.8392243639841394`*^9, 3.8392243950383773`*^9}, 3.839224442185709*^9, {
   3.8392245129185476`*^9, 3.8392245373577056`*^9}, {3.8392245776385975`*^9, 
   3.839224740679908*^9}, {3.8392248367057567`*^9, 3.839224838004247*^9}, {
   3.8392249023255987`*^9, 3.8392249329681873`*^9}, 3.8392250078513308`*^9, {
   3.8392250461420965`*^9, 3.8392250567765236`*^9}, {3.8392250892690206`*^9, 
   3.839225128234888*^9}, {3.839225292837965*^9, 3.8392253052980237`*^9}, {
   3.839225374465659*^9, 3.839225378163327*^9}, {3.8392366608564453`*^9, 
   3.839236691352835*^9}, {3.839236736346908*^9, 3.8392367461057377`*^9}, {
   3.8392368452896976`*^9, 3.8392369245276327`*^9}, {3.8392369586763678`*^9, 
   3.839236989556669*^9}, {3.8392370210310707`*^9, 3.839237025639107*^9}, {
   3.8392370611832547`*^9, 3.839237143422812*^9}, {3.839237229917989*^9, 
   3.839237306453603*^9}, {3.8392373387206373`*^9, 3.839237342820054*^9}, {
   3.839237447098841*^9, 3.8392375543643665`*^9}, {3.8392411494009237`*^9, 
   3.839241171431179*^9}, {3.83924120627816*^9, 3.8392412247291117`*^9}, 
   3.8392412792201967`*^9, 3.8392413874247665`*^9, {3.8392415172512045`*^9, 
   3.8392415791894693`*^9}, {3.839241632182249*^9, 3.8392416472548246`*^9}, 
   3.8392418101230965`*^9, {3.839242047805271*^9, 3.8392420951804295`*^9}, {
   3.8392421670049934`*^9, 3.8392422247577305`*^9}, {3.8392422574679546`*^9, 
   3.8392422587095203`*^9}, {3.839242291908*^9, 3.8392425704347763`*^9}, {
   3.8392426617662134`*^9, 3.8392426717163734`*^9}, 3.839242785862258*^9, {
   3.839246817917405*^9, 3.8392468269690895`*^9}, {3.839246889891876*^9, 
   3.839246924816616*^9}, {3.839309996677757*^9, 3.839310018708186*^9}, {
   3.839310845764266*^9, 3.839310880859878*^9}, {3.839310926113166*^9, 
   3.839310949193386*^9}, {3.8393110019361973`*^9, 3.8393110308399534`*^9}, {
   3.8393270934512377`*^9, 3.839327332415727*^9}, {3.839327370226597*^9, 
   3.839327451303669*^9}, {3.8393275031436253`*^9, 3.8393275194960613`*^9}, {
   3.839327586008069*^9, 3.8393276948310633`*^9}, {3.8393278034898295`*^9, 
   3.8393278068680096`*^9}, {3.8393278450424776`*^9, 
   3.8393278797618237`*^9}, {3.8393289610021143`*^9, 3.839328976754302*^9}, {
   3.8393294967878103`*^9, 3.839329617607455*^9}, 3.8393297021511583`*^9, {
   3.839329736764967*^9, 3.83932973839811*^9}, {3.839329841358012*^9, 
   3.839329850076448*^9}, {3.8393298856244183`*^9, 3.83932990739045*^9}, {
   3.839330200791801*^9, 3.839330209464896*^9}, 3.83933026862875*^9, {
   3.8393304947792683`*^9, 3.839330614321838*^9}, {3.839330707456501*^9, 
   3.8393307223587484`*^9}, {3.8393307586469154`*^9, 3.839330774655125*^9}, {
   3.8393308208469334`*^9, 3.8393308254369345`*^9}, {3.83933092079788*^9, 
   3.8393310148602314`*^9}, {3.8393311745075006`*^9, 
   3.8393311994275675`*^9}, {3.8393312620131807`*^9, 
   3.8393312886598005`*^9}, {3.83933158528376*^9, 3.8393316720258255`*^9}, 
   3.8393317188850336`*^9, {3.8393317973728094`*^9, 3.8393319397094903`*^9}, 
   3.8393320294844685`*^9, {3.8393325727147913`*^9, 3.8393326007437224`*^9}, {
   3.839332643937569*^9, 3.8393326886712303`*^9}, {3.839332884251463*^9, 
   3.8393328849388123`*^9}, {3.8393329498885293`*^9, 3.839332954368989*^9}, 
   3.839332984548478*^9, {3.839333161836732*^9, 3.839333179429063*^9}, {
   3.839333212168277*^9, 3.8393332158859396`*^9}, {3.839333299885914*^9, 
   3.839333320058819*^9}, {3.8393333662749724`*^9, 3.839333389618166*^9}, 
   3.8393335815372777`*^9, {3.8393336646381135`*^9, 3.839333690640252*^9}, {
   3.839333816187891*^9, 3.839333852596138*^9}, {3.839333913143673*^9, 
   3.839333960953573*^9}, {3.8393340547869487`*^9, 3.839334137419753*^9}, {
   3.839420765475212*^9, 3.839420767706482*^9}, {3.839420800720344*^9, 
   3.83942080814257*^9}, {3.839420930166752*^9, 3.839420954611184*^9}, 
   3.839421093306271*^9, {3.839421249787591*^9, 3.8394213460868835`*^9}, {
   3.839421400152422*^9, 3.8394214417353144`*^9}, {3.839421483648677*^9, 
   3.839421580608614*^9}, 3.839421616079374*^9, 3.839422181142932*^9, {
   3.8394224472930202`*^9, 3.839422448371497*^9}, {3.8394225405886507`*^9, 
   3.839422541885687*^9}, {3.8394225839963813`*^9, 3.83942258751882*^9}, 
   3.8394239784679832`*^9, {3.8394240190394516`*^9, 3.8394240194005165`*^9}, {
   3.839481241680246*^9, 3.8394812636526537`*^9}, {3.8394813033197775`*^9, 
   3.839481343020226*^9}, {3.8394813886318493`*^9, 3.83948138904453*^9}, {
   3.8394814470082235`*^9, 3.8394815138762083`*^9}, {3.839484145142799*^9, 
   3.8394841575703464`*^9}, {3.8394842427712455`*^9, 
   3.8394842456191454`*^9}, {3.8394844396674995`*^9, 
   3.8394844660440836`*^9}, {3.8394845806487627`*^9, 3.83948460808449*^9}, {
   3.8394847191879005`*^9, 3.839484719920673*^9}, {3.8394847985864277`*^9, 
   3.8394847999498053`*^9}, {3.839485522225484*^9, 3.8394858614478054`*^9}, {
   3.8394858968609977`*^9, 3.8394858979280567`*^9}, {3.83950394022218*^9, 
   3.839504016595684*^9}, {3.839504079022719*^9, 3.8395041716366367`*^9}, {
   3.8395042475063295`*^9, 3.83950424807436*^9}, {3.8395043044033585`*^9, 
   3.8395043325148754`*^9}, {3.839504403912784*^9, 3.839504405955762*^9}, {
   3.839504461254238*^9, 3.8395044954062967`*^9}, {3.839504572085556*^9, 
   3.8395046258331623`*^9}, {3.839504718095887*^9, 3.839504733043982*^9}, {
   3.839504792704324*^9, 3.8395048214714227`*^9}, {3.8395048602645364`*^9, 
   3.839504871422516*^9}, {3.83950521161292*^9, 3.8395052235501237`*^9}, {
   3.839505255990897*^9, 3.8395052773582516`*^9}, {3.839505321851119*^9, 
   3.839505332451271*^9}, {3.8395054257374*^9, 3.8395054385582395`*^9}, 
   3.839505580972617*^9, {3.8395057025144815`*^9, 3.8395057031788645`*^9}, {
   3.8395057369934807`*^9, 3.8395057373979363`*^9}, {3.839505772294227*^9, 
   3.839505778367197*^9}, {3.83950673092721*^9, 3.8395067795192204`*^9}, {
   3.8395084122279215`*^9, 3.8395084138977666`*^9}, {3.839508448233049*^9, 
   3.8395084493422976`*^9}, {3.839508499051385*^9, 3.8395085344200335`*^9}, 
   3.8395086207285233`*^9, {3.8395086973952723`*^9, 3.8395086978689127`*^9}, {
   3.8395089696790757`*^9, 3.839509039224576*^9}, {3.8395100524490423`*^9, 
   3.839510053723009*^9}, {3.839511493807127*^9, 3.8395115089839754`*^9}, {
   3.8395115931589155`*^9, 3.839511633911852*^9}, {3.839511664551564*^9, 
   3.8395117021779413`*^9}, {3.839511738662855*^9, 3.8395117683886237`*^9}, {
   3.8395840465025244`*^9, 3.8395840478719764`*^9}, {3.8395842326636224`*^9, 
   3.8395842405526743`*^9}, {3.8395844072352886`*^9, 3.839584438590257*^9}, {
   3.839584539157859*^9, 3.839584558647271*^9}, {3.8395846133789663`*^9, 
   3.83958465811094*^9}, {3.839584785836444*^9, 3.839584807986281*^9}, 
   3.839586726652771*^9, {3.8395867995416994`*^9, 3.8395868420413933`*^9}, 
   3.83958688638865*^9, {3.839587244941451*^9, 3.83958726487414*^9}, {
   3.83958774293878*^9, 3.8395877838602095`*^9}, 3.839587828597546*^9, {
   3.839587879706158*^9, 3.8395879135449758`*^9}, {3.839587955043039*^9, 
   3.8395879642045746`*^9}, {3.8395880048781385`*^9, 3.839588051406326*^9}, {
   3.8395880883490973`*^9, 3.8395881594520197`*^9}, {3.8395882347911615`*^9, 
   3.8395883226336384`*^9}, 3.8395883559509153`*^9, 3.839588415451826*^9, {
   3.8395884902783833`*^9, 3.8395885216082554`*^9}, {3.8395941073926105`*^9, 
   3.8395942227438965`*^9}, 3.839595304916483*^9, {3.8395954862576475`*^9, 
   3.83959557521957*^9}, {3.839595607221432*^9, 3.8395956076140194`*^9}, {
   3.839595660820343*^9, 3.839595661835729*^9}, {3.839604650775865*^9, 
   3.8396046640054827`*^9}, {3.839604708532463*^9, 3.8396047629301977`*^9}, {
   3.839604795558606*^9, 3.839604808947177*^9}, {3.839604852056878*^9, 
   3.8396048690185547`*^9}, {3.839642088079403*^9, 3.839642141004441*^9}, {
   3.8396422800918975`*^9, 3.8396423077286944`*^9}, {3.8396424143783884`*^9, 
   3.8396424152236857`*^9}, {3.8396426095904264`*^9, 
   3.8396426100591545`*^9}, {3.8396426843268356`*^9, 3.8396426912164164`*^9}, 
   3.8396427676568155`*^9, {3.8396428549330425`*^9, 3.8396429650459213`*^9}, 
   3.839643049962629*^9, {3.839643091872772*^9, 3.8396431410841303`*^9}, 
   3.839643491656567*^9, {3.839643550041149*^9, 3.839643610060313*^9}, {
   3.8396436783391447`*^9, 3.8396437059963512`*^9}, {3.8396437389632745`*^9, 
   3.8396437448257093`*^9}, {3.839643793497415*^9, 3.8396438275668716`*^9}, {
   3.839643978745996*^9, 3.8396439798436737`*^9}, {3.839644021519642*^9, 
   3.8396440428152156`*^9}, {3.8396441695399504`*^9, 
   3.8396441971715937`*^9}, {3.839644230142295*^9, 3.8396442469945946`*^9}, {
   3.839644284692358*^9, 3.8396442961501245`*^9}, {3.8396443434969287`*^9, 
   3.8396443583914576`*^9}, {3.8396448346105194`*^9, 3.839644913123821*^9}, {
   3.8396555898716025`*^9, 3.839655650012109*^9}, {3.8396556822310605`*^9, 
   3.839655771771843*^9}, {3.839655952479162*^9, 3.8396559541084647`*^9}, 
   3.839656003389371*^9, {3.8396560347174463`*^9, 3.839656116850046*^9}, {
   3.8396562422855325`*^9, 3.8396562713341274`*^9}, 3.8396563271846943`*^9, {
   3.8396565529884825`*^9, 3.839656667985509*^9}, {3.8396568526250334`*^9, 
   3.839656873162519*^9}, {3.8396570321068354`*^9, 3.8396570367161813`*^9}, {
   3.8396571621919303`*^9, 3.839657193340761*^9}, {3.839657225174745*^9, 
   3.8396572442512493`*^9}, {3.8396572932236905`*^9, 3.8396572940165*^9}, 
   3.8396574072631903`*^9, {3.8396575476060143`*^9, 3.8396575682943974`*^9}, {
   3.839664138921971*^9, 3.839664156869915*^9}, 3.839664243007531*^9, {
   3.839669622125418*^9, 3.839669647884663*^9}, {3.839670002387182*^9, 
   3.839670025487237*^9}, {3.8396700586539392`*^9, 3.8396701085420904`*^9}, {
   3.8396766028729286`*^9, 3.839676603372811*^9}, {3.839676649783103*^9, 
   3.8396766681979322`*^9}, {3.839723206211033*^9, 3.839723252419324*^9}, {
   3.8397243192805915`*^9, 3.8397243622670403`*^9}, {3.839724526690404*^9, 
   3.8397245565593586`*^9}, 3.839724591814554*^9, {3.8397246526353917`*^9, 
   3.8397246677187424`*^9}, {3.839724698665658*^9, 3.8397248461537275`*^9}, {
   3.839724910156172*^9, 3.839724969029936*^9}, {3.839725029399225*^9, 
   3.839725070375955*^9}, {3.8397257491640964`*^9, 3.8397258148584566`*^9}, {
   3.839726205531111*^9, 3.839726226304987*^9}, {3.839726314389023*^9, 
   3.8397264887181263`*^9}, {3.8397266355093994`*^9, 
   3.8397266356472826`*^9}, {3.839727069639051*^9, 3.83972707062368*^9}, {
   3.8397274615058823`*^9, 3.839727481527841*^9}, {3.83972755827617*^9, 
   3.8397275594724007`*^9}, {3.839727857737072*^9, 3.83972788618902*^9}, 
   3.8397281801577473`*^9, {3.839741406815917*^9, 3.839741648719699*^9}, 
   3.839741694966459*^9, {3.8397417738301263`*^9, 3.8397417740488653`*^9}, 
   3.839742014559319*^9, {3.8397421882027674`*^9, 3.839742188943444*^9}, {
   3.8397589658528605`*^9, 3.83975903164762*^9}, {3.839759582024466*^9, 
   3.8397596437148447`*^9}, {3.8397597378135786`*^9, 3.839759770277839*^9}, {
   3.839760042248042*^9, 3.8397600434337606`*^9}, {3.839760792865179*^9, 
   3.839760817913896*^9}, {3.8397655048182044`*^9, 3.839765505036851*^9}, {
   3.839765649791177*^9, 3.839765680039174*^9}, {3.839765730951825*^9, 
   3.8397657438209515`*^9}, {3.8397658325268707`*^9, 3.839765870890603*^9}, {
   3.8397695336031294`*^9, 3.8397695785421767`*^9}, 3.839769610638837*^9, {
   3.839769642999297*^9, 3.8397696900062704`*^9}, {3.8397697294324865`*^9, 
   3.839769753667972*^9}, 3.839770624201335*^9, {3.8399858643515997`*^9, 
   3.839985870106961*^9}, {3.8399859073530426`*^9, 3.83998590778368*^9}, {
   3.839986665758301*^9, 3.839986671600184*^9}, {3.840015477117873*^9, 
   3.840015532633871*^9}, {3.840262190474472*^9, 3.8402621922160215`*^9}, {
   3.8402622512898836`*^9, 3.8402623158498154`*^9}, {3.840262346847395*^9, 
   3.840262361938197*^9}, {3.8402624446884875`*^9, 3.840262497278998*^9}, {
   3.8402625593196363`*^9, 3.840262562846277*^9}, {3.840262654524027*^9, 
   3.8402626673364897`*^9}, {3.8402800661176753`*^9, 3.840280138278593*^9}, {
   3.840280177703832*^9, 3.840280189480773*^9}, {3.8402802324576406`*^9, 
   3.8402802331825943`*^9}, {3.8402812754975386`*^9, 3.840281326464582*^9}, 
   3.8402813946519136`*^9, {3.84028186111417*^9, 3.8402818954912634`*^9}, {
   3.8402819964993353`*^9, 3.8402819971437144`*^9}, {3.840330466229367*^9, 
   3.8403304972505484`*^9}, 3.8403305401374164`*^9, 3.840330628649666*^9, {
   3.8403306672934227`*^9, 3.8403306802026963`*^9}, {3.8403307193320885`*^9, 
   3.840330758272279*^9}, 3.8403307967908325`*^9, 3.8403308358680725`*^9, {
   3.840330872410847*^9, 3.8403308786837*^9}, {3.8403309221453967`*^9, 
   3.840330944340696*^9}, 3.840330989285677*^9, {3.840331109810131*^9, 
   3.840331153164013*^9}, {3.840331431580937*^9, 3.8403314406879196`*^9}, {
   3.8403317789283185`*^9, 3.840331780542934*^9}, {3.840331813886128*^9, 
   3.8403318320633073`*^9}, {3.8403318821336937`*^9, 
   3.8403318897950106`*^9}, {3.8403319357741313`*^9, 
   3.8403319411825953`*^9}, {3.8403320129500637`*^9, 
   3.8403321277278547`*^9}, {3.840332221075777*^9, 3.8403322212632327`*^9}, {
   3.8404162792747984`*^9, 3.8404162803058043`*^9}, {3.840416344690134*^9, 
   3.8404163448306866`*^9}, {3.8404178626090136`*^9, 3.840417925824424*^9}, {
   3.8404191918191233`*^9, 3.84041920226635*^9}, {3.840419242024495*^9, 
   3.8404192617321796`*^9}, {3.8404194389428053`*^9, 3.840419462557069*^9}, {
   3.840453834266838*^9, 3.8404538447517056`*^9}, 3.840453909614043*^9, {
   3.8404539683635793`*^9, 3.8404539905838337`*^9}, 3.8404540272985306`*^9, {
   3.840454156166298*^9, 3.840454205291971*^9}, {3.840454240247527*^9, 
   3.8404542540157146`*^9}, {3.8404543237333283`*^9, 
   3.8404543404928937`*^9}, {3.8404544521143074`*^9, 
   3.8404544541302176`*^9}, {3.840454485008524*^9, 3.8404544958331428`*^9}, {
   3.840454535970628*^9, 3.840454551137659*^9}, {3.840500625089159*^9, 
   3.840500656940725*^9}, {3.840500695345143*^9, 3.8405006960523067`*^9}, {
   3.8405010969852047`*^9, 3.840501112587641*^9}, {3.840501150634077*^9, 
   3.8405011611522417`*^9}, {3.8405026446645527`*^9, 3.84050265267775*^9}, 
   3.8405026878215275`*^9, 3.8405027886745453`*^9, {3.8405028323157024`*^9, 
   3.8405028521056433`*^9}, {3.840508597751215*^9, 3.8405086042448597`*^9}, {
   3.8405086361734276`*^9, 3.840508697640854*^9}, {3.84530515034306*^9, 
   3.8453051663199177`*^9}, 3.845305197884505*^9, {3.8454792808354254`*^9, 
   3.8454794150956697`*^9}, {3.845479722113243*^9, 3.8454797915964413`*^9}, {
   3.845514873929638*^9, 3.8455149337268724`*^9}, {3.8455149684706416`*^9, 
   3.8455149695080223`*^9}, {3.8455153275220933`*^9, 3.845515328229957*^9}, {
   3.845515395675539*^9, 3.845515401297691*^9}, {3.845515515853771*^9, 
   3.845515576447665*^9}, {3.845515612558851*^9, 3.845515632979537*^9}, {
   3.845515680153039*^9, 3.8455159262376585`*^9}, {3.845516112061887*^9, 
   3.8455161465263453`*^9}, {3.845516193085106*^9, 3.845516229178423*^9}, {
   3.8455163351689043`*^9, 3.845516585318216*^9}, {3.8455166177397394`*^9, 
   3.845516714733508*^9}, {3.845516771645197*^9, 3.8455167731827154`*^9}, {
   3.845516818729296*^9, 3.84551695860878*^9}, {3.845516994711903*^9, 
   3.845517026462266*^9}, 3.845517092145789*^9, {3.845517135366593*^9, 
   3.845517155446496*^9}, {3.845517186534149*^9, 3.8455171937276707`*^9}, {
   3.845517227012909*^9, 3.8455172279061613`*^9}, {3.8455173234132085`*^9, 
   3.8455173514857492`*^9}, {3.845517423730919*^9, 3.8455174243493695`*^9}, {
   3.8455174624069753`*^9, 3.845517465100626*^9}, 3.845517507705373*^9, 
   3.8455175508535676`*^9, {3.8455176264044795`*^9, 3.8455176334075813`*^9}, {
   3.8455313319229393`*^9, 3.845531509940443*^9}, 3.8455315849840965`*^9, {
   3.8455317016782956`*^9, 3.845531738966821*^9}, {3.845531778451456*^9, 
   3.845531779386674*^9}, {3.8456415428113813`*^9, 3.845641735457308*^9}, {
   3.8456420427094593`*^9, 3.8456420444008894`*^9}, {3.8456420953927226`*^9, 
   3.845642095827136*^9}, {3.8456421305858717`*^9, 3.8456422084386454`*^9}, 
   3.8456422719473834`*^9, {3.8456424654126687`*^9, 3.8456424685516415`*^9}, {
   3.8456425391271963`*^9, 3.845642581942461*^9}, {3.8456426396045694`*^9, 
   3.845642806094469*^9}, {3.845642836196087*^9, 3.845642900922883*^9}, {
   3.845642970285206*^9, 3.8456430181273146`*^9}, {3.8456430708546114`*^9, 
   3.845643125882959*^9}, {3.845643178575968*^9, 3.845643257358486*^9}, {
   3.8456433623862553`*^9, 3.8456433771042914`*^9}, {3.8456434590863156`*^9, 
   3.8456434937160645`*^9}, 3.845643545927831*^9, {3.845643600156926*^9, 
   3.845643618570978*^9}, {3.8456436644300175`*^9, 3.84564366503797*^9}, {
   3.845643702197648*^9, 3.8456437461979747`*^9}, 3.8456439574887114`*^9, {
   3.846069818172841*^9, 3.846069849642768*^9}, {3.8460699136765876`*^9, 
   3.846069914209477*^9}, {3.8460699599440656`*^9, 3.8460700314146757`*^9}, {
   3.846070076753316*^9, 3.846070077439046*^9}, {3.846070157661101*^9, 
   3.8460701937707815`*^9}, {3.846070258127372*^9, 3.846070370035694*^9}, 
   3.8460704231130123`*^9, {3.846070456017062*^9, 3.8460704588184586`*^9}, {
   3.8460710172041235`*^9, 3.846071021582673*^9}, {3.846071106666136*^9, 
   3.8460711227728405`*^9}, {3.846071236516765*^9, 3.8460712690613956`*^9}, {
   3.846071302508814*^9, 3.8460713286265783`*^9}, {3.846071391711331*^9, 
   3.8460713919222136`*^9}, {3.8460717432565613`*^9, 3.846071846163582*^9}, {
   3.8460718796339417`*^9, 3.8460718981181345`*^9}, {3.8460719281852317`*^9, 
   3.8460719602156863`*^9}, {3.8460725487311463`*^9, 
   3.8460727277222366`*^9}, {3.8460727966336946`*^9, 
   3.8460727999447126`*^9}, {3.8460728715731387`*^9, 3.846072900231036*^9}, 
   3.8460729488995743`*^9, 3.846073094187673*^9, {3.846073124968068*^9, 
   3.846073143649494*^9}, {3.846073291437569*^9, 3.846073320871194*^9}, {
   3.8460733513356*^9, 3.8460733827836275`*^9}, {3.8460734213260293`*^9, 
   3.846073547913215*^9}, {3.8460735888598585`*^9, 3.8460735948494663`*^9}, {
   3.8460736630482445`*^9, 3.84607366906472*^9}, {3.846073769039547*^9, 
   3.8460738022300262`*^9}, {3.8460738788770266`*^9, 
   3.8460738952181954`*^9}, {3.846073949966679*^9, 3.8460739569065495`*^9}, {
   3.846074029073464*^9, 3.8460740346596146`*^9}, {3.846074102104647*^9, 
   3.8460741324118767`*^9}, {3.8460741949049115`*^9, 3.846074222593691*^9}, {
   3.8460742841895127`*^9, 3.846074340763191*^9}, {3.846160732253354*^9, 
   3.8461607332481594`*^9}, 3.846161492762432*^9, {3.846161780897497*^9, 
   3.846161788138113*^9}, {3.8461618293598766`*^9, 3.846161858226082*^9}, {
   3.8461618966585674`*^9, 3.846161969794857*^9}, 3.846162102689354*^9, {
   3.8461621668466263`*^9, 3.846162180355235*^9}, {3.8461622164826603`*^9, 
   3.8461622355856447`*^9}, {3.846162281065609*^9, 3.8461624985309367`*^9}, 
   3.8461626621493115`*^9, 3.846162697816634*^9, {3.8461627342864695`*^9, 
   3.8461627345822268`*^9}, {3.8461628166006966`*^9, 3.8461628174265194`*^9}, 
   3.846162849529516*^9, 3.846163042718745*^9, {3.8461630926561747`*^9, 
   3.8461631014520173`*^9}, 3.846164675187914*^9, {3.8461653709571285`*^9, 
   3.8461653939322076`*^9}, {3.846239297565034*^9, 3.846239321709072*^9}, {
   3.8462393704866405`*^9, 3.846239378462596*^9}, 3.8462394463604927`*^9, {
   3.846239908200873*^9, 3.846240041118046*^9}, {3.8462400979595313`*^9, 
   3.8462402075029526`*^9}, {3.846240330599819*^9, 3.846240332116249*^9}, {
   3.846240396409835*^9, 3.846240426609739*^9}, {3.8462404635946035`*^9, 
   3.846240479194495*^9}, {3.846240547126852*^9, 3.8462406007711906`*^9}, {
   3.846240672984129*^9, 3.8462406735655537`*^9}, {3.846240715451014*^9, 
   3.846240727662325*^9}, {3.8462408398048706`*^9, 3.8462408550133176`*^9}, {
   3.846240906219432*^9, 3.8462409845731764`*^9}, {3.8462415426024213`*^9, 
   3.846241600241384*^9}, {3.8462416533016524`*^9, 3.8462416824345474`*^9}, {
   3.846241871443136*^9, 3.846241889026347*^9}, {3.84624196622915*^9, 
   3.846241982209696*^9}, {3.8462420839315395`*^9, 3.8462421106657743`*^9}, {
   3.8462493213059616`*^9, 3.846249371505189*^9}, {3.846249426216957*^9, 
   3.8462494677076874`*^9}, {3.846249549506504*^9, 3.8462495503135986`*^9}, {
   3.8463317012472258`*^9, 3.846331723789422*^9}, 3.846331790148814*^9, {
   3.846331841946804*^9, 3.8463318642788124`*^9}, {3.8463318999649568`*^9, 
   3.84633190085021*^9}, {3.846331970187175*^9, 3.8463319724350276`*^9}, {
   3.846332425994608*^9, 3.8463324267831564`*^9}, {3.8463324853767433`*^9, 
   3.846332505743512*^9}, {3.84633253640195*^9, 3.84633253746087*^9}, 
   3.8463325927468147`*^9, {3.846332664076268*^9, 3.84633267729871*^9}, {
   3.84633282094595*^9, 3.846332866648316*^9}, {3.846332915983061*^9, 
   3.846332964772069*^9}, {3.8463332315659857`*^9, 3.8463332589840655`*^9}, {
   3.8463333159368706`*^9, 3.8463333881232243`*^9}, {3.846333478174964*^9, 
   3.846333507307977*^9}, {3.8463337169753866`*^9, 3.846333752677167*^9}, {
   3.8463337874930525`*^9, 3.8463337938266315`*^9}, {3.84633382889653*^9, 
   3.8463338314544067`*^9}, {3.8463338661347585`*^9, 
   3.8463338671064034`*^9}, {3.8463341029946103`*^9, 3.8463341178046017`*^9}, 
   3.8463344961508446`*^9, {3.846334551477289*^9, 3.8463345669722776`*^9}, {
   3.846334647851037*^9, 3.8463346507709723`*^9}, {3.8463350072556896`*^9, 
   3.846335009531336*^9}, {3.8463350584383993`*^9, 3.8463350832915545`*^9}, 
   3.8463356730391445`*^9, {3.8463357330577507`*^9, 3.846335734677639*^9}, {
   3.8463357713912954`*^9, 3.846335784599365*^9}, {3.846335824451017*^9, 
   3.846335850541898*^9}, {3.8465148279290648`*^9, 3.846514905645626*^9}, {
   3.8465149546536207`*^9, 3.8465149557287645`*^9}, 3.8465150347627506`*^9, 
   3.8465150735123754`*^9, 3.846515133355834*^9, {3.846551496354246*^9, 
   3.8465515199215117`*^9}, {3.8465515514860935`*^9, 3.846551558453719*^9}, {
   3.8465516511605453`*^9, 3.8465516816971188`*^9}, {3.8465517493251767`*^9, 
   3.8465517819787836`*^9}, {3.846551812162984*^9, 3.84655181978378*^9}, {
   3.8469012753631597`*^9, 3.8469014245266294`*^9}, {3.846901477101201*^9, 
   3.846901480891117*^9}, 3.846901533852523*^9, {3.8469015653056993`*^9, 
   3.8469015942691755`*^9}, 3.8469016260053563`*^9, {3.846901664939994*^9, 
   3.8469016657155457`*^9}, {3.846901747509447*^9, 3.8469017503170366`*^9}, {
   3.84690191404624*^9, 3.84690193970901*^9}, 3.846901985149589*^9, {
   3.84690203255608*^9, 3.8469020373058805`*^9}, {3.8469021528510695`*^9, 
   3.84690220430954*^9}, {3.8469022448931456`*^9, 3.8469022504597807`*^9}, {
   3.846902285388745*^9, 3.846902288603936*^9}, {3.8469023384879513`*^9, 
   3.846902371933584*^9}, 3.846902765731144*^9, {3.8469028332433987`*^9, 
   3.8469028443561935`*^9}, 3.8469030843801355`*^9, 3.846903160980903*^9, {
   3.8469032059828815`*^9, 3.8469032390870132`*^9}, {3.84690342310567*^9, 
   3.846903439207902*^9}, {3.8469061580301685`*^9, 3.8469062645476227`*^9}, {
   3.8469065486448135`*^9, 3.846906561548581*^9}, {3.8469067471371455`*^9, 
   3.8469068174896765`*^9}, {3.84690686154051*^9, 3.8469068684523077`*^9}, {
   3.8497527618146653`*^9, 3.8497527676380615`*^9}, {3.8497528414079475`*^9, 
   3.849752843454638*^9}, {3.8497530625145917`*^9, 3.849753063032662*^9}, {
   3.8497530971084747`*^9, 3.8497531011988783`*^9}, {3.8497532258666143`*^9, 
   3.849753345755213*^9}, {3.849753924288494*^9, 3.849753985952464*^9}, {
   3.849754069460248*^9, 3.849754087001464*^9}, {3.849754259204835*^9, 
   3.849754268999332*^9}, {3.8497554284565487`*^9, 3.8497554930272894`*^9}, {
   3.849755685279069*^9, 3.8497556896240177`*^9}, {3.8497558773614607`*^9, 
   3.849755877843891*^9}, {3.8497559807269473`*^9, 3.8497560211165953`*^9}, 
   3.850443650520732*^9, {3.8504438404083548`*^9, 3.8504441120345283`*^9}, {
   3.850444156664489*^9, 3.850444280967318*^9}, {3.850444354744196*^9, 
   3.85044463643923*^9}, {3.8504447256702757`*^9, 3.8504447980665684`*^9}, {
   3.8505274395909743`*^9, 3.8505274411181674`*^9}, {3.8505275310510144`*^9, 
   3.8505276349685197`*^9}, {3.850527665564816*^9, 3.850527741150744*^9}, {
   3.850528010969228*^9, 3.8505280914370484`*^9}, {3.850528341539154*^9, 
   3.8505283435766478`*^9}, {3.850528399268195*^9, 3.850528452926201*^9}, {
   3.850528511901552*^9, 3.850528524032834*^9}, {3.8505286008142643`*^9, 
   3.8505286255862675`*^9}, {3.850528657292616*^9, 3.8505287485299587`*^9}, {
   3.850528791091945*^9, 3.8505287912193995`*^9}, {3.8505289892778673`*^9, 
   3.8505290093703814`*^9}, {3.8505291179397283`*^9, 3.850529246368305*^9}, {
   3.8505292847200036`*^9, 3.8505293531238484`*^9}, {3.85052942526715*^9, 
   3.8505295026053452`*^9}, {3.850529652810694*^9, 3.85052969888447*^9}, {
   3.8505297570230837`*^9, 3.8505297793908668`*^9}, {3.8505298130474796`*^9, 
   3.85052982372943*^9}, 3.850529903643921*^9, {3.8505299339680395`*^9, 
   3.850529938523468*^9}, {3.850533467746894*^9, 3.850533696587976*^9}, {
   3.8505337523084393`*^9, 3.8505340100220647`*^9}, {3.850534073301394*^9, 
   3.8505341115212436`*^9}, {3.8505341448690495`*^9, 3.850534244609003*^9}, {
   3.8505342773409953`*^9, 3.850534317485276*^9}, {3.850534376818581*^9, 
   3.8505345375059347`*^9}, 3.8505345895823593`*^9, {3.850534712936541*^9, 
   3.850534853983102*^9}, {3.85053489565536*^9, 3.85053490800423*^9}, {
   3.850535011630887*^9, 3.850535069369616*^9}, {3.8505609789941187`*^9, 
   3.8505609796472797`*^9}, {3.850561024378234*^9, 3.8505611077291512`*^9}, {
   3.8505611554662695`*^9, 3.8505611900834045`*^9}, {3.8505612604815354`*^9, 
   3.850561307036023*^9}, 3.8505614161973686`*^9, {3.850561489892841*^9, 
   3.8505614904828854`*^9}, 3.850561540476676*^9, {3.850566961415826*^9, 
   3.85056699607444*^9}, {3.8505670465401917`*^9, 3.850567067268143*^9}, {
   3.850567124561453*^9, 3.8505671481746936`*^9}, {3.8505671891195374`*^9, 
   3.850567192972233*^9}, {3.8505672404233675`*^9, 3.850567272319547*^9}, {
   3.8505673802869396`*^9, 3.850567388289441*^9}, {3.850567420051065*^9, 
   3.8505674379775977`*^9}, {3.850568113924102*^9, 3.850568121245113*^9}, {
   3.8505681786419373`*^9, 3.8505682190225987`*^9}, {3.8505682742836356`*^9, 
   3.8505682972999997`*^9}, {3.850568330443387*^9, 3.8505683415549088`*^9}, {
   3.850568377492758*^9, 3.850568403154665*^9}, {3.850568837097434*^9, 
   3.850568946787299*^9}, {3.8505691453292117`*^9, 3.850569195539899*^9}, {
   3.8505692859376397`*^9, 3.8505693669331837`*^9}, {3.8505693974289236`*^9, 
   3.8505695475039663`*^9}, {3.8505696079724298`*^9, 
   3.8505696221275873`*^9}, {3.8505697874854712`*^9, 
   3.8505698175396166`*^9}, {3.850569868969412*^9, 3.8505698726296372`*^9}, {
   3.850569905926787*^9, 3.8505699809036593`*^9}, {3.850570015920215*^9, 
   3.85057008172045*^9}, {3.850785556912866*^9, 3.850785616614393*^9}, {
   3.8507856606466494`*^9, 3.850785723209618*^9}, {3.8507857656066175`*^9, 
   3.850785880874487*^9}, {3.850785924508508*^9, 3.850785937300992*^9}, {
   3.8507859750545197`*^9, 3.8507859968100834`*^9}, {3.850786077342246*^9, 
   3.8507860848236823`*^9}, {3.8507861340867023`*^9, 3.8507861374599075`*^9}, 
   3.850786227982345*^9, {3.8507862859910107`*^9, 3.8507863008387175`*^9}, {
   3.850786368316942*^9, 3.850786374976062*^9}, {3.850786423270744*^9, 
   3.850786423425295*^9}, {3.8507865491264324`*^9, 3.850786595976322*^9}, {
   3.850786636570469*^9, 3.850786709325587*^9}, {3.850786743990263*^9, 
   3.8507868015086374`*^9}, {3.8507870134211025`*^9, 
   3.8507870176048164`*^9}, {3.850787059141889*^9, 3.8507870650224657`*^9}, {
   3.850787111878257*^9, 3.850787113157389*^9}, {3.8507887599989805`*^9, 
   3.850788841851822*^9}, {3.850788913491912*^9, 3.8507890311085014`*^9}, {
   3.8507890809695005`*^9, 3.8507890902738066`*^9}, {3.8507891921970196`*^9, 
   3.8507891973037043`*^9}, {3.8507892279462795`*^9, 3.850789249495205*^9}, {
   3.850791412876636*^9, 3.8507914130273633`*^9}, {3.8507915155633483`*^9, 
   3.8507915162424593`*^9}, {3.850827343188859*^9, 3.850827375432101*^9}, {
   3.8508274109868975`*^9, 3.8508274369062905`*^9}, {3.8508274890786314`*^9, 
   3.8508274894138756`*^9}, {3.8508275695516253`*^9, 3.850827569788695*^9}, 
   3.8508276711587315`*^9, {3.8508277166165743`*^9, 3.8508277728386536`*^9}, {
   3.8508278475513325`*^9, 3.8508278753498926`*^9}, {3.8508279408872223`*^9, 
   3.85082794118405*^9}, {3.850827981298354*^9, 3.850828056921221*^9}, {
   3.850828494113824*^9, 3.850828495039543*^9}, {3.85082856023905*^9, 
   3.850828575017256*^9}, {3.850828628892047*^9, 3.850828696248144*^9}, 
   3.8508287630158415`*^9, {3.8508293694951773`*^9, 3.850829372071825*^9}, {
   3.8508294221130056`*^9, 3.8508294474505587`*^9}, {3.8508295136154523`*^9, 
   3.850829546786518*^9}, {3.8508307551495695`*^9, 3.850830755305548*^9}, {
   3.850830846425475*^9, 3.8508308469949007`*^9}, {3.8508328226756153`*^9, 
   3.8508328956454206`*^9}, {3.8515151599360895`*^9, 
   3.8515151854097323`*^9}, {3.851515227511881*^9, 3.8515152691971846`*^9}, {
   3.8517376565999703`*^9, 3.851737660729647*^9}, {3.8517376993937993`*^9, 
   3.851737854226467*^9}, {3.8517379030659018`*^9, 3.851737963592141*^9}, {
   3.8517380004040184`*^9, 3.851738156849004*^9}, {3.8517381881441555`*^9, 
   3.8517383547150526`*^9}, {3.851738403578961*^9, 3.8517384750343685`*^9}, {
   3.8517386329884996`*^9, 3.8517387036807384`*^9}, {3.8517387496128297`*^9, 
   3.8517391066461697`*^9}, 3.851739167106615*^9, {3.851739199324179*^9, 
   3.8517392033202653`*^9}, {3.851739306865944*^9, 3.8517396012506447`*^9}, {
   3.8517396478337793`*^9, 3.851739717012961*^9}, {3.851739779861041*^9, 
   3.8517398251446857`*^9}, {3.8517401674121*^9, 3.85174023031291*^9}, {
   3.8517403822763968`*^9, 3.8517405215277195`*^9}, {3.8517405598035936`*^9, 
   3.8517405807347307`*^9}, 3.8517406111741548`*^9, {3.852771815388609*^9, 
   3.852771815826337*^9}, {3.852771938933034*^9, 3.852772015527173*^9}, {
   3.8527720455326405`*^9, 3.852772051655347*^9}, {3.852772112575083*^9, 
   3.85277216712604*^9}, {3.8527722639917727`*^9, 3.8527723193930345`*^9}, {
   3.8527723507994275`*^9, 3.8527724886441803`*^9}, 3.852772518958836*^9, {
   3.8527726690962496`*^9, 3.8527726724595623`*^9}, {3.852772785224839*^9, 
   3.852772814059412*^9}, {3.8527728536940055`*^9, 3.8527728543197746`*^9}, 
   3.8527728940919833`*^9, {3.8527729250196114`*^9, 3.8527729905347033`*^9}, {
   3.8527730490675783`*^9, 3.8527730529881525`*^9}, {3.852773399558672*^9, 
   3.852773411256092*^9}, {3.852773459331044*^9, 3.852773480723246*^9}, {
   3.8527735251577444`*^9, 3.8527735647772226`*^9}, {3.85277372440212*^9, 
   3.852773727144375*^9}, {3.8528731960002193`*^9, 3.8528733256878357`*^9}, {
   3.852873387704274*^9, 3.852873409884766*^9}, {3.8528734508562613`*^9, 
   3.8528734515817213`*^9}, {3.8528734901873713`*^9, 3.852873528186962*^9}, {
   3.8528735614708843`*^9, 3.8528735812376013`*^9}, {3.8528736531146784`*^9, 
   3.852873677620881*^9}, {3.8528801200331235`*^9, 3.852880146194016*^9}, {
   3.853140879673688*^9, 3.8531409143592653`*^9}, {3.8531409625201416`*^9, 
   3.8531410288764524`*^9}, {3.8531410590292354`*^9, 
   3.8531411087537766`*^9}, {3.906960081539485*^9, 3.9069602331152077`*^9}, {
   3.9069603433707557`*^9, 3.906960421970504*^9}, 3.90696058512084*^9, {
   3.9069606314181366`*^9, 3.906960643357847*^9}, {3.9069606827315874`*^9, 
   3.9069606842067842`*^9}, {3.9069607800459027`*^9, 3.906960789339467*^9}, {
   3.906960946958927*^9, 3.906961015693834*^9}, {3.9069610665773287`*^9, 
   3.9069610942448244`*^9}, {3.906975980921613*^9, 3.906976089812361*^9}, {
   3.9069761287780294`*^9, 3.9069761444527407`*^9}, {3.9069761802392483`*^9, 
   3.9069764111837945`*^9}, {3.9069764723969927`*^9, 
   3.9069764965177555`*^9}, {3.9069765456510816`*^9, 3.906976559809983*^9}, {
   3.9069766596602173`*^9, 3.9069766598802757`*^9}, 3.9069767005917444`*^9, {
   3.906976778520788*^9, 3.906976842147175*^9}, {3.90697690958217*^9, 
   3.906976948797903*^9}, {3.906977008286579*^9, 3.9069770258571725`*^9}, {
   3.9069783088004336`*^9, 3.9069783295883393`*^9}, {3.9069784555681205`*^9, 
   3.9069784736312475`*^9}, {3.9069785149274707`*^9, 
   3.9069785203580103`*^9}, {3.9069785545147533`*^9, 
   3.9069786442875185`*^9}, {3.9069786792021737`*^9, 
   3.9069788093775425`*^9}, {3.906978853786457*^9, 3.906978872127804*^9}, {
   3.906978907937706*^9, 3.9069789439029903`*^9}, {3.906979021341509*^9, 
   3.9069791012891383`*^9}, {3.9069793249639287`*^9, 
   3.9069793698176155`*^9}, {3.9069794500914555`*^9, 
   3.9069794867247863`*^9}, {3.9069795534312057`*^9, 3.906979579384478*^9}, {
   3.9069796794955473`*^9, 3.906979691967578*^9}, {3.90697984152462*^9, 
   3.9069798495662622`*^9}, {3.9069798829331303`*^9, 3.906979892303535*^9}, {
   3.906979929815036*^9, 3.9069799897806015`*^9}, {3.907029838923909*^9, 
   3.9070298429045696`*^9}, 3.907029873049452*^9, {3.9070299082271347`*^9, 
   3.9070299615551324`*^9}, {3.9070300098261147`*^9, 3.907030048469262*^9}, {
   3.907030090835805*^9, 3.907030236396055*^9}, {3.9070302925336046`*^9, 
   3.907030304052057*^9}, {3.907030372815591*^9, 3.9070304865078115`*^9}, {
   3.907030557887286*^9, 3.9070305689133244`*^9}, {3.9070308911683903`*^9, 
   3.907030892187997*^9}, {3.9070604376835546`*^9, 3.907060445993576*^9}, {
   3.9070605369359646`*^9, 3.907060610391075*^9}, {3.9070607652596164`*^9, 
   3.907060779428796*^9}, {3.90706081432941*^9, 3.9070608151924467`*^9}, {
   3.9070608516888237`*^9, 3.907060854768076*^9}, {3.907060944967448*^9, 
   3.907060990845777*^9}, {3.907061076512681*^9, 3.9070611086597958`*^9}, {
   3.9070611484876804`*^9, 3.9070611988926153`*^9}, {3.9070612582075396`*^9, 
   3.907061352628416*^9}, {3.9070614831261873`*^9, 3.9070615845827394`*^9}, {
   3.907061784180231*^9, 3.9070618159858637`*^9}, {3.907061890477336*^9, 
   3.907061943454452*^9}, {3.9071484650166793`*^9, 3.90714866651295*^9}, {
   3.907148762155178*^9, 3.9071488404975348`*^9}, {3.9071488774252872`*^9, 
   3.9071489294181747`*^9}, {3.9071489765577335`*^9, 3.907148976814991*^9}, {
   3.9071491725272875`*^9, 3.907149241274995*^9}, 3.9071493285419173`*^9, {
   3.9071493746789184`*^9, 3.907149483905308*^9}, {3.9071495447705164`*^9, 
   3.907149550473424*^9}, {3.9071495819630795`*^9, 3.90714963340366*^9}, {
   3.9071497225947556`*^9, 3.9071497240775113`*^9}, {3.907149760297258*^9, 
   3.907149761731573*^9}, {3.9071498152856555`*^9, 3.907149875310998*^9}, 
   3.9071499205002947`*^9, {3.9071499577662582`*^9, 3.9071499702396035`*^9}, {
   3.9071500532046795`*^9, 3.9071500682462764`*^9}, {3.907218618548807*^9, 
   3.9072187011296597`*^9}, {3.9072195014873066`*^9, 
   3.9072195025316906`*^9}, {3.90721955313033*^9, 3.907219605997478*^9}, {
   3.9076388883376904`*^9, 3.907639028857774*^9}, {3.9076584642948866`*^9, 
   3.9076584677515554`*^9}, 3.9076585061822867`*^9, {3.9076585847633705`*^9, 
   3.9076586673533773`*^9}, {3.9076587071776705`*^9, 3.907658763185525*^9}, {
   3.907658814220379*^9, 3.9076588335250573`*^9}, {3.907658905205724*^9, 
   3.907658950762456*^9}, {3.907660119522422*^9, 3.9076601635769453`*^9}, 
   3.9126500418645983`*^9, {3.912650272877923*^9, 3.9126503212520823`*^9}, {
   3.912650484389138*^9, 3.912650572012165*^9}, {3.912650656766632*^9, 
   3.9126506581126027`*^9}, {3.9126507259529123`*^9, 3.912650777581822*^9}, 
   3.912651074711319*^9, {3.9126512031248045`*^9, 3.912651213319991*^9}, 
   3.912651703687234*^9, {3.912770083842639*^9, 3.9127701076862574`*^9}, {
   3.9128202786546226`*^9, 3.912820284120411*^9}, 3.9128203334420757`*^9, {
   3.9128203658705187`*^9, 3.91282056892971*^9}, {3.912820649630741*^9, 
   3.912820661602646*^9}, {3.9128206955003443`*^9, 3.912820724768431*^9}, 
   3.9128207658429365`*^9, {3.9128210569191675`*^9, 3.9128210648083296`*^9}, 
   3.9128210964617248`*^9, 3.9128211283606553`*^9, 3.9128212232449136`*^9, 
   3.912821276435539*^9, 3.9128214180597515`*^9, {3.912821544243472*^9, 
   3.9128215499947147`*^9}, {3.9128217996313906`*^9, 
   3.9128218286437273`*^9}, {3.912821877012741*^9, 3.912821923396287*^9}, {
   3.9128219675831423`*^9, 3.9128221124228954`*^9}, {3.912920245593502*^9, 
   3.912920245966591*^9}, {3.9139445874276905`*^9, 3.91394459507491*^9}, {
   3.9139450187138863`*^9, 3.9139450343858995`*^9}, {3.913945205447682*^9, 
   3.913945248472603*^9}, {3.913945412690005*^9, 3.9139455155179462`*^9}, {
   3.913958962378629*^9, 3.9139589785035114`*^9}, {3.9139590402712264`*^9, 
   3.9139590937141848`*^9}, 3.9139750141153145`*^9, {3.9139750744801207`*^9, 
   3.9139751224167085`*^9}, {3.9139752153934174`*^9, 3.91397523521216*^9}, {
   3.9139752681667395`*^9, 3.9139752765309496`*^9}, {3.9139754210256305`*^9, 
   3.91397543855688*^9}, {3.913975474761815*^9, 3.913975549799944*^9}, {
   3.9139756202766843`*^9, 3.913975621473342*^9}, {3.913976355232353*^9, 
   3.9139763564720173`*^9}, 3.913976468052901*^9, {3.913976504313478*^9, 
   3.9139766047022376`*^9}, {3.9139768730666857`*^9, 
   3.9139769991515765`*^9}, {3.9139805364785786`*^9, 
   3.9139805578142247`*^9}, {3.9143020649613595`*^9, 3.914302072021001*^9}, {
   3.914302194959444*^9, 3.914302202483561*^9}, {3.9191390449333115`*^9, 
   3.919139125489049*^9}, {3.9191391862084427`*^9, 3.919139212733096*^9}, {
   3.9191393296015463`*^9, 3.9191393355361643`*^9}, {3.919139393908128*^9, 
   3.9191394603885593`*^9}, 3.919139538292508*^9, {3.9191395898427453`*^9, 
   3.9191395945714526`*^9}, {3.9191397104148407`*^9, 3.9191397261812196`*^9}, 
   3.919139790543318*^9, 3.919139967192321*^9, {3.9191406455936623`*^9, 
   3.919140690845147*^9}, {3.9191407735213203`*^9, 3.9191407743776417`*^9}, {
   3.9191408181117997`*^9, 3.9191408270078845`*^9}, {3.9191408657281303`*^9, 
   3.919140902915256*^9}, {3.9191410060045266`*^9, 3.9191410203172483`*^9}, 
   3.919141070320388*^9, {3.919141163927287*^9, 3.9191411872159586`*^9}, {
   3.9191412577972193`*^9, 3.9191412976368313`*^9}, {3.9191688870873775`*^9, 
   3.919168933052214*^9}, {3.9201182584505105`*^9, 3.920118274636175*^9}, {
   3.9201183148461*^9, 3.920118343218148*^9}, {3.9201784059083443`*^9, 
   3.920178470289201*^9}, {3.920178507855404*^9, 3.9201785455959826`*^9}, {
   3.920178965113888*^9, 3.9201790019678364`*^9}, {3.920248155151059*^9, 
   3.9202483498451767`*^9}, {3.920248389503045*^9, 3.9202483978744574`*^9}, 
   3.9202484386447196`*^9, {3.9202485470386105`*^9, 3.9202485618135386`*^9}, {
   3.9202485937761097`*^9, 3.9202486060898476`*^9}, {3.920248654173068*^9, 
   3.920248687395794*^9}, {3.9202487471821632`*^9, 3.920248757769596*^9}, {
   3.920248836338523*^9, 3.9202488737720094`*^9}, {3.9202489384678183`*^9, 
   3.9202489395783587`*^9}, {3.9202490180745525`*^9, 
   3.9202490544358435`*^9}, {3.9202491396774197`*^9, 
   3.9202492222178316`*^9}, {3.9202493242154093`*^9, 3.920249354829981*^9}, {
   3.9202499010503387`*^9, 3.920249910578265*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {GrayLevel[0.5], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwtlgk0lVsbxw3Hec9LRBGSynhxZbzndCs5u0jKUGlURIauLGPXEE2UJolS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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwVjGs4FPgCh8cMY8jtsNhU0kUtSyRdDjVHncqSxUqSFGlyP4UiVE54sAip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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwVxX04E3gAB3BG2yS5EFEseqNLSUpPtEvnUupwo6KkUkclvXlJlKfpihB5
iSa6i5MU6UXY1vr+TipqlqatQitm2qQsSpLN3f3xeT62oftZv1N0dHSC/vP/
tQs+ZnE4KjxeylnNOkgnPvkTNrzIV4GdIo84FEkn3dq5VpPzVOj3fuCRt5tO
TEThxWezVWCWSQaV2+lk397OW8lpKjQ829PJZdHJzPLnrTHHVJhQzo0bt5hO
suz4k1nbVSiwmHHLdpRGIiancMY7qHA2RyCLyqGRQ+LCRLs5KnTNMS2zPEsj
8Zk3dyybpULlEdbR+nQaSTVod9xjq8Lx0J1u1qdo5IrGsb7JUgXuT2HpQ3E0
0q1o7U0Zr4LQ1Pq4y1YaCa5huNP6lLiWmrccjjSybmOtTK9KiZgLfWInMZWE
mgdNc69Uwiat3qDsKZXESUaCoq8psTb32ERGM5WU+jMl3WVKbI8fjjVrpBKt
74MnD/5S4tTt5Dize1RStbq1LjlbCU+7T/rhV6nEZFl/tmGsEm1b9gb88geV
vJo2x8t0uRLM3rrScHcqUQZebA9pfocoy+pRL8E4MvPT1UrngHdwt+bJIlaO
I0ZGw8XT5D1gJMp5y1/pkxkn2yQZu3rg5Vy0ZyBSn/CjGlyWqxVYmDXKlND1
yZjiY43ucQXsm+Ydrq7QIweqr8f6UBUY0i120PXWIxnUqqCbud0QOkpDl32k
kPlPa3b5zeqG+p5fqVUuhXwf9L9zuEIO174SRsNCCokuXDjrjpscU4Ze2jEl
usTq0t/i+H+68G0oJPjDfl2ychqj4uiaLmTWtXn+aqhLLKa2Xcl91YnfrNez
Ayt0iGXsXLnLtk5o+JujLTx1yKMA/or3H9+ikc3utrs/huLMznaH6LeITUtm
qHu10LBtVq35+gb9uva+A6ZaGPeNWEWYv0FpIkXv02oNEiZSIorsZMi2t2xz
2jOKFUtTdUeZrzEg88gV5H+Hga+tWry1A9GPkxbZPBrBPBt5EC+yHaoTncVu
Xd9w5fOs8aK0NogcSzd7jP+GxBM5iwfyXsHHfljDsR5G4JgxN+PyS1TYp1je
cP6KtCSjExsfvgCrg/ph7fohTLm3uNGpVYqQMqpWEPoFWp03/kvUEpSm1PRQ
Ez9D6ZTvWj1Jglrt/LNVFwYxzzI+b+X05+ClRX2tLRlAE13mpmG2IjjM/IwD
7xPIjb3Bjd5ieMbvmMjhqfHDtqP3EfYMuR0MZmJOP3aOFiQtSG5B9uk8G0bt
B8wsbjyy1eEpRu4wCqSV77Fw05aEup3NeMt3yjS5r8JgkleUc/wTeEv9BGVX
3+HuSd+pReebwCpx99mVr4BrfpDfthePUFsfll5fIkeYJTfBU/0A/CyjyBx2
J7yuWrmwHRpwa/ZAgcWYDE6TCwqvR9TD7RmzKY/Wjmb1vu+jyQR3qufx/W5K
4VqTJvI6LYAoSq83uEgMnc2V5qePCMDRfHAwTxPj8Zgo5PFuARbI94pFcWKE
rDHpX+ctgOK02xZmgBinOs4bswwFWBN5eZO5oRhSymW/4DN3sWj62HB53DPE
+BLxgSw+3t6WKrb6t4D5udPqFpsPH9FDD6pHC+gcvR2DB/mwEfdQK+a3oLBr
1WAMi4+R8ibhF4MWNMQ0myaY8qFf8VOmPvspzArbAk6e48FEEfZds0kE2YrR
wocneQidU/vadYkIVxTWClosD5Tz2uwDk0RwX7A9JnUDD+qE87GyR83YWf/u
XKYFD219GrsKl2bMDzeQtdB4KAg0uthh3Ixhwx9nmwxz0ZUf0mf4Xoj09ftq
cl9yMbvqPSX8khAbRjK1kkYunIyXPck+KsT0P2+usuBysc2/P0ywUYjen1sz
Asu56K0zk/Y4C3Fb+VnK4XBhFn97ivFEIf4Fb3MUEg==
      "]]}}, {{{{{InsetBox[
         StyleBox[
          TagBox[
           RowBox[{
            StyleBox[
             SubscriptBox["\[Tau]", "e"],
             FontSize->12], 
            StyleBox["=",
             FontSize->12], 
            StyleBox[" ",
             FontSize->12], 
            RowBox[{
             StyleBox["0.5",
              FontSize->12], 
             StyleBox["  ",
              FontSize->12], 
             StyleBox["ms",
              FontSize->12], " "}]}],
           "RawBoxes"],
          FontFamily->"Arial",
          FontSize->10,
          
          Background->GrayLevel[
           1.]], {-0.9465657902805327, -0.9237244815224575}, {Left, Baseline},
         Alignment->{Left, Top}], InsetBox[
         StyleBox[
          TagBox[
           RowBox[{
            StyleBox[
             SubscriptBox["\[Tau]", "d"],
             FontSize->12], 
            StyleBox["=",
             FontSize->12], 
            StyleBox[" ",
             FontSize->12], 
            RowBox[{
             StyleBox["0.1",
              FontSize->12], 
             StyleBox["  ",
              FontSize->12], 
             StyleBox["ms",
              FontSize->12], " "}]}],
           "RawBoxes"],
          FontFamily->"Arial",
          FontSize->10,
          
          Background->GrayLevel[
           1.]], {-0.9523254274687407, -1.3126133704113447`}, {Left, Baseline},
         Alignment->{Left, Top}]}, InsetBox[
        RowBox[{"\[Theta]", "=", 
         RowBox[{"+", "1"}]}], {-0.9601304481813842, -0.5312839953161989}, {
        Left, Baseline},
        Alignment->{Left, Top}]}, InsetBox[
       StyleBox[
        TagBox[
         RowBox[{
          SubscriptBox[
           StyleBox["v",
            FontFamily->"Arial",
            FontSize->12,
            FontWeight->"Plain",
            FontSlant->"Plain",
            FontVariations->{"StrikeThrough"->False,
            "Underline"->False}], 
           RowBox[{"r", " "}]], 
          StyleBox["=",
           FontSize->12], 
          StyleBox[" ",
           FontSize->12], 
          RowBox[{
           StyleBox["0.4",
            FontSize->12], 
           StyleBox[" ",
            FontSize->12], 
           RowBox[{
            StyleBox["mV",
             FontSize->12], 
            StyleBox["/",
             FontSize->12], 
            StyleBox["s",
             FontSize->12], " "}]}]}],
         "RawBoxes"],
        FontFamily->"Arial",
        FontSize->10,
        Background->GrayLevel[
         1.]], {-0.9826088741807589, -1.6964002184839058`}, {Left, Baseline},
       Alignment->{Left, Top}]}, 
     {RGBColor[1., 0.32153022506559453`, 0.], AbsoluteThickness[2], 
      Arrowheads[{{0.042072662838444415`, 1, {
          GraphicsBox[{
            EdgeForm[None], 
            Dashing[{}], 
            PolygonBox[{{-1, 0.5}, {0, 0}, {-1, -0.5}}]}], 0.98}}}], 
      StrokeForm[RGBColor[0, 0.501961, 0.501961]], EdgeForm[{RGBColor[
      0., 0.5019607843137255, 0.5019607843137255], Opacity[1.], 
      AbsoluteThickness[2]}], EdgeForm[None], 
      ArrowBox[{{-0.5752487581741615, -1.8711068703912233`}, \
{-0.36349631632580803`, -1.1025502918901728`}}]}}, 
    {RGBColor[1., 0.32153022506559453`, 0.], AbsoluteThickness[2], 
     Arrowheads[{{0.042072662838444415`, 1, {
         GraphicsBox[{
           EdgeForm[None], 
           Dashing[{}], 
           PolygonBox[{{-1, 0.5}, {0, 0}, {-1, -0.5}}]}], 0.98}}}], 
     StrokeForm[RGBColor[0, 0.501961, 0.501961]], EdgeForm[{RGBColor[
     0., 0.5019607843137255, 0.5019607843137255], Opacity[1.], 
     AbsoluteThickness[2]}], EdgeForm[None], 
     ArrowBox[{{-0.28068520047949896`, -1.7709204424774687`}, \
{-0.46928611552160504`, -2.4592038437845942`}}]}}},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{-1., 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(u\\), \\(g\\)]\\) (V)\"", FontSize -> 20, 
      StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(I\\), \\(d\\)]\\) (\[Mu]A)\"", FontSize -> 
      20, StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, {{-4, 
      FormBox[
       RowBox[{"-", "4"}], TraditionalForm]}, {-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImagePadding->{{52., 25.}, {55., 24.}},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{-1., 0.1}, {-3.2, 0.5}},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic]], "Input",
 CellChangeTimes->{{3.920249924775138*^9, 3.9202499360379047`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {GrayLevel[0.5], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwtlgk0lVsbxw3Hec9LRBGSynhxZbzndCs5u0jKUGlURIauLGPXEE2UJolS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      "]]}}, {{}, {}, 
    {RGBColor[1, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwVjGs4FPgCh8cMY8jtsNhU0kUtSyRdDjVHncqSxUqSFGlyP4UiVE54sAip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      "]]}}, {{}, {}, 
    {RGBColor[1, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwVxX04E3gAB3BG2yS5EFEseqNLSUpPtEvnUupwo6KkUkclvXlJlKfpihB5
iSa6i5MU6UXY1vr+TipqlqatQitm2qQsSpLN3f3xeT62oftZv1N0dHSC/vP/
tQs+ZnE4KjxeylnNOkgnPvkTNrzIV4GdIo84FEkn3dq5VpPzVOj3fuCRt5tO
TEThxWezVWCWSQaV2+lk397OW8lpKjQ829PJZdHJzPLnrTHHVJhQzo0bt5hO
suz4k1nbVSiwmHHLdpRGIiancMY7qHA2RyCLyqGRQ+LCRLs5KnTNMS2zPEsj
8Zk3dyybpULlEdbR+nQaSTVod9xjq8Lx0J1u1qdo5IrGsb7JUgXuT2HpQ3E0
0q1o7U0Zr4LQ1Pq4y1YaCa5huNP6lLiWmrccjjSybmOtTK9KiZgLfWInMZWE
mgdNc69Uwiat3qDsKZXESUaCoq8psTb32ERGM5WU+jMl3WVKbI8fjjVrpBKt
74MnD/5S4tTt5Dize1RStbq1LjlbCU+7T/rhV6nEZFl/tmGsEm1b9gb88geV
vJo2x8t0uRLM3rrScHcqUQZebA9pfocoy+pRL8E4MvPT1UrngHdwt+bJIlaO
I0ZGw8XT5D1gJMp5y1/pkxkn2yQZu3rg5Vy0ZyBSn/CjGlyWqxVYmDXKlND1
yZjiY43ucQXsm+Ydrq7QIweqr8f6UBUY0i120PXWIxnUqqCbud0QOkpDl32k
kPlPa3b5zeqG+p5fqVUuhXwf9L9zuEIO174SRsNCCokuXDjrjpscU4Ze2jEl
usTq0t/i+H+68G0oJPjDfl2ychqj4uiaLmTWtXn+aqhLLKa2Xcl91YnfrNez
Ayt0iGXsXLnLtk5o+JujLTx1yKMA/or3H9+ikc3utrs/huLMznaH6LeITUtm
qHu10LBtVq35+gb9uva+A6ZaGPeNWEWYv0FpIkXv02oNEiZSIorsZMi2t2xz
2jOKFUtTdUeZrzEg88gV5H+Hga+tWry1A9GPkxbZPBrBPBt5EC+yHaoTncVu
Xd9w5fOs8aK0NogcSzd7jP+GxBM5iwfyXsHHfljDsR5G4JgxN+PyS1TYp1je
cP6KtCSjExsfvgCrg/ph7fohTLm3uNGpVYqQMqpWEPoFWp03/kvUEpSm1PRQ
Ez9D6ZTvWj1Jglrt/LNVFwYxzzI+b+X05+ClRX2tLRlAE13mpmG2IjjM/IwD
7xPIjb3Bjd5ieMbvmMjhqfHDtqP3EfYMuR0MZmJOP3aOFiQtSG5B9uk8G0bt
B8wsbjyy1eEpRu4wCqSV77Fw05aEup3NeMt3yjS5r8JgkleUc/wTeEv9BGVX
3+HuSd+pReebwCpx99mVr4BrfpDfthePUFsfll5fIkeYJTfBU/0A/CyjyBx2
J7yuWrmwHRpwa/ZAgcWYDE6TCwqvR9TD7RmzKY/Wjmb1vu+jyQR3qufx/W5K
4VqTJvI6LYAoSq83uEgMnc2V5qePCMDRfHAwTxPj8Zgo5PFuARbI94pFcWKE
rDHpX+ctgOK02xZmgBinOs4bswwFWBN5eZO5oRhSymW/4DN3sWj62HB53DPE
+BLxgSw+3t6WKrb6t4D5udPqFpsPH9FDD6pHC+gcvR2DB/mwEfdQK+a3oLBr
1WAMi4+R8ibhF4MWNMQ0myaY8qFf8VOmPvspzArbAk6e48FEEfZds0kE2YrR
wocneQidU/vadYkIVxTWClosD5Tz2uwDk0RwX7A9JnUDD+qE87GyR83YWf/u
XKYFD219GrsKl2bMDzeQtdB4KAg0uthh3Ixhwx9nmwxz0ZUf0mf4Xoj09ftq
cl9yMbvqPSX8khAbRjK1kkYunIyXPck+KsT0P2+usuBysc2/P0ywUYjen1sz
Asu56K0zk/Y4C3Fb+VnK4XBhFn97ivFEIf4Fb3MUEg==
      "]]}}},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{-1., 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(u\\), \\(g\\)]\\) (V)\"", FontSize -> 20, 
      StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(I\\), \\(d\\)]\\) (\[Mu]A)\"", FontSize -> 
      20, StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, {{-4, 
      FormBox[
       RowBox[{"-", "4"}], TraditionalForm]}, {-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImagePadding->{{52., 25.}, {55., 24.}},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{-1., 0.1}, {-3.2, 0.5}},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic]], "Input",
 CellChangeTimes->{{3.920249372551179*^9, 3.9202493892203517`*^9}, {
   3.9202494241560316`*^9, 3.9202494360774755`*^9}, 3.9202499217268934`*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {GrayLevel[0.5], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwtlgk0lVsbxw3Hec9LRBGSynhxZbzndCs5u0jKUGlURIauLGPXEE2UJolS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      "]]}}, {{}, {}, 
    {RGBColor[1, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwVjGs4FPgCh8cMY8jtsNhU0kUtSyRdDjVHncqSxUqSFGlyP4UiVE54sAip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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwVxX04E3gAB3BG2yS5EFEseqNLSUpPtEvnUupwo6KkUkclvXlJlKfpihB5
iSa6i5MU6UXY1vr+TipqlqatQitm2qQsSpLN3f3xeT62oftZv1N0dHSC/vP/
tQs+ZnE4KjxeylnNOkgnPvkTNrzIV4GdIo84FEkn3dq5VpPzVOj3fuCRt5tO
TEThxWezVWCWSQaV2+lk397OW8lpKjQ829PJZdHJzPLnrTHHVJhQzo0bt5hO
suz4k1nbVSiwmHHLdpRGIiancMY7qHA2RyCLyqGRQ+LCRLs5KnTNMS2zPEsj
8Zk3dyybpULlEdbR+nQaSTVod9xjq8Lx0J1u1qdo5IrGsb7JUgXuT2HpQ3E0
0q1o7U0Zr4LQ1Pq4y1YaCa5huNP6lLiWmrccjjSybmOtTK9KiZgLfWInMZWE
mgdNc69Uwiat3qDsKZXESUaCoq8psTb32ERGM5WU+jMl3WVKbI8fjjVrpBKt
74MnD/5S4tTt5Dize1RStbq1LjlbCU+7T/rhV6nEZFl/tmGsEm1b9gb88geV
vJo2x8t0uRLM3rrScHcqUQZebA9pfocoy+pRL8E4MvPT1UrngHdwt+bJIlaO
I0ZGw8XT5D1gJMp5y1/pkxkn2yQZu3rg5Vy0ZyBSn/CjGlyWqxVYmDXKlND1
yZjiY43ucQXsm+Ydrq7QIweqr8f6UBUY0i120PXWIxnUqqCbud0QOkpDl32k
kPlPa3b5zeqG+p5fqVUuhXwf9L9zuEIO174SRsNCCokuXDjrjpscU4Ze2jEl
usTq0t/i+H+68G0oJPjDfl2ychqj4uiaLmTWtXn+aqhLLKa2Xcl91YnfrNez
Ayt0iGXsXLnLtk5o+JujLTx1yKMA/or3H9+ikc3utrs/huLMznaH6LeITUtm
qHu10LBtVq35+gb9uva+A6ZaGPeNWEWYv0FpIkXv02oNEiZSIorsZMi2t2xz
2jOKFUtTdUeZrzEg88gV5H+Hga+tWry1A9GPkxbZPBrBPBt5EC+yHaoTncVu
Xd9w5fOs8aK0NogcSzd7jP+GxBM5iwfyXsHHfljDsR5G4JgxN+PyS1TYp1je
cP6KtCSjExsfvgCrg/ph7fohTLm3uNGpVYqQMqpWEPoFWp03/kvUEpSm1PRQ
Ez9D6ZTvWj1Jglrt/LNVFwYxzzI+b+X05+ClRX2tLRlAE13mpmG2IjjM/IwD
7xPIjb3Bjd5ieMbvmMjhqfHDtqP3EfYMuR0MZmJOP3aOFiQtSG5B9uk8G0bt
B8wsbjyy1eEpRu4wCqSV77Fw05aEup3NeMt3yjS5r8JgkleUc/wTeEv9BGVX
3+HuSd+pReebwCpx99mVr4BrfpDfthePUFsfll5fIkeYJTfBU/0A/CyjyBx2
J7yuWrmwHRpwa/ZAgcWYDE6TCwqvR9TD7RmzKY/Wjmb1vu+jyQR3qufx/W5K
4VqTJvI6LYAoSq83uEgMnc2V5qePCMDRfHAwTxPj8Zgo5PFuARbI94pFcWKE
rDHpX+ctgOK02xZmgBinOs4bswwFWBN5eZO5oRhSymW/4DN3sWj62HB53DPE
+BLxgSw+3t6WKrb6t4D5udPqFpsPH9FDD6pHC+gcvR2DB/mwEfdQK+a3oLBr
1WAMi4+R8ibhF4MWNMQ0myaY8qFf8VOmPvspzArbAk6e48FEEfZds0kE2YrR
wocneQidU/vadYkIVxTWClosD5Tz2uwDk0RwX7A9JnUDD+qE87GyR83YWf/u
XKYFD219GrsKl2bMDzeQtdB4KAg0uthh3Ixhwx9nmwxz0ZUf0mf4Xoj09ftq
cl9yMbvqPSX8khAbRjK1kkYunIyXPck+KsT0P2+usuBysc2/P0ywUYjen1sz
Asu56K0zk/Y4C3Fb+VnK4XBhFn97ivFEIf4Fb3MUEg==
      "]]}}, InsetBox[
    RowBox[{"\[Theta]", "=", 
     RowBox[{"+", "1"}]}], {-0.9397526501766782, -0.527258960121151}, {
    Left, Baseline},
    Alignment->{Left, Top}]},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{-1., 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(u\\), \\(g\\)]\\) (V)\"", FontSize -> 20, 
      StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(I\\), \\(d\\)]\\) (\[Mu]A)\"", FontSize -> 
      20, StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, {{-4, 
      FormBox[
       RowBox[{"-", "4"}], TraditionalForm]}, {-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImagePadding->{{52., 25.}, {55., 24.}},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{-1., 0.1}, {-3.2, 0.5}},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic]], "Input",
 CellChangeTimes->{{3.920249347031005*^9, 3.920249349469968*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {GrayLevel[0.5], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwtlgk0lVsbxw3Hec9LRBGSynhxZbzndCs5u0jKUGlURIauLGPXEE2UJolS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      "]]}}, {{}, {}, 
    {RGBColor[1, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV1nlYDd8fB/A2oi4tWrRQtCl+spSs2b4qpLRYSgh9lUpUklYqJCVUWpCS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      "]]}}, {{}, {}, 
    {RGBColor[1, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV1nk0VV0UAHDDuyFDRSlSMmYKSaQkIXPIVKRUSqSQqb6HikilUJkqJCGi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      "]]}}, {{{{InsetBox[
        StyleBox[
         TagBox[
          RowBox[{
           StyleBox[
            SubscriptBox["\[Tau]", "e"],
            FontSize->12], 
           StyleBox["=",
            FontSize->12], 
           StyleBox[" ",
            FontSize->12], 
           RowBox[{
            StyleBox["0.5",
             FontSize->12], 
            StyleBox["  ",
             FontSize->12], 
            StyleBox["ms",
             FontSize->12], " "}]}],
          "RawBoxes"],
         FontFamily->"Arial",
         FontSize->10,
         Background->GrayLevel[
          1.]], {-0.9509184200272678, -0.878786968261982}, {Left, Baseline},
        Alignment->{Left, Top}], InsetBox[
        StyleBox[
         TagBox[
          RowBox[{
           StyleBox[
            SubscriptBox["\[Tau]", "d"],
            FontSize->12], 
           StyleBox["=",
            FontSize->12], 
           StyleBox[" ",
            FontSize->12], 
           RowBox[{
            StyleBox["0.8",
             FontSize->12], 
            StyleBox["  ",
             FontSize->12], 
            StyleBox["ms",
             FontSize->12], " "}]}],
          "RawBoxes"],
         FontFamily->"Arial",
         FontSize->10,
         Background->GrayLevel[
          1.]], {-0.9566780572154758, -1.2676758571508697`}, {Left, Baseline},
        Alignment->{Left, Top}]}, InsetBox[
       RowBox[{"\[Theta]", "=", 
        RowBox[{"+", "1"}]}], {-0.9061791910023242, -0.3929593038628909}, {
       Left, Baseline},
       Alignment->{Left, Top}]}, InsetBox[
      StyleBox[
       TagBox[
        RowBox[{
         SubscriptBox[
          StyleBox["v",
           FontFamily->"Arial",
           FontSize->12,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontVariations->{"StrikeThrough"->False,
           "Underline"->False}], 
          RowBox[{"r", " "}]], 
         StyleBox["=",
          FontSize->12], 
         StyleBox[" ",
          FontSize->12], 
         RowBox[{
          StyleBox["0.2",
           FontSize->12], 
          StyleBox[" ",
           FontSize->12], 
          RowBox[{
           StyleBox["mV",
            FontSize->12], 
           StyleBox["/",
            FontSize->12], 
           StyleBox["s",
            FontSize->12], " "}]}]}],
        "RawBoxes"],
       FontFamily->"Arial",
       FontSize->10,
       Background->GrayLevel[
        1.]], {-0.986961503927494, -1.6514627052234307`}, {Left, Baseline},
      Alignment->{Left, Top}]}, 
    {RGBColor[1., 0.32153022506559453`, 0.], AbsoluteThickness[2], 
     Arrowheads[{{0.042072662838444415`, 1, {
         GraphicsBox[{
           EdgeForm[None], 
           Dashing[{}], 
           PolygonBox[{{-1, 0.5}, {0, 0}, {-1, -0.5}}]}], 0.98}}}], 
     StrokeForm[RGBColor[0, 0.501961, 0.501961]], EdgeForm[{RGBColor[
     0., 0.5019607843137255, 0.5019607843137255], Opacity[1.], 
     AbsoluteThickness[2]}], EdgeForm[None], 
     ArrowBox[{{-0.4707674656594124, -2.4798796044805744`}, \
{-0.23958039483579396`, -1.7860327685337878`}}]}}, 
   {RGBColor[1., 0.32153022506559453`, 0.], AbsoluteThickness[2], 
    Arrowheads[{{0.042072662838444415`, 1, {
        GraphicsBox[{
          EdgeForm[None], 
          Dashing[{}], 
          PolygonBox[{{-1, 0.5}, {0, 0}, {-1, -0.5}}]}], 0.98}}}], StrokeForm[
    RGBColor[0, 0.501961, 0.501961]], EdgeForm[{RGBColor[
    0., 0.5019607843137255, 0.5019607843137255], Opacity[1.], 
    AbsoluteThickness[2]}], EdgeForm[None], 
    ArrowBox[{{-0.3977586782827712, -1.2590470382528367`}, \
{-0.6135680738902483, -1.9099755682828299`}}]}},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{-1., 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(u\\), \\(g\\)]\\) (V)\"", FontSize -> 20, 
      StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(I\\), \\(d\\)]\\) (\[Mu]A)\"", FontSize -> 
      20, StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, {{-4, 
      FormBox[
       RowBox[{"-", "4"}], TraditionalForm]}, {-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImagePadding->{{52., 25.}, {55., 24.}},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{-1., 0.1}, {-3.2, 0.5}},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic]], "Input",
 CellChangeTimes->{{3.920249236045028*^9, 3.9202492804619856`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {GrayLevel[0.5], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwtlgk0lVsbxw3Hec9LRBGSynhxZbzndCs5u0jKUGlURIauLGPXEE2UJolS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      "]]}}, {{}, {}, 
    {RGBColor[1, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV1nlYDd8fB/A2oi4tWrRQtCl+spSs2b4qpLRYSgh9lUpUklYqJCVUWpCS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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV1nk0VV0UAHDDuyFDRSlSMmYKSaQkIXPIVKRUSqSQqb6HikilUJkqJCGi
RCWP2DeZi0SUsQzvnfvKGBnK8J3+uOuu31pn7TPtc86WOuZje4KLg4PjF/7+
/V+rjdy6e5cNoW+zAk5O0kirJAHHL0lsMDQTuDyEPbigJL4qkQ2pnFM8Z3/T
SOGmkxlxt9mQ6LHE//wUjfQ+3VcUFc2G7uDNLZdmaKRs7ufWwFA2DGa6tZ2b
o5G3pMtW2R5lw1O+Jb8WuQlS4XpHR6wrG5zvTvzxpxFkxfh0auMhNuxSWnoB
YQ+RmvJmzmzo+GQw8YEgSFPXZ1r6dmxIy21LvcVDkAv3H+5X3cOGWQs+ES5+
gvRadfXuUkU2yB00C7q0giD9WlIuSG9kg+2lAbchbHpsodt2OTZozXky9gsT
5HW+rk2npNjgHTCUoiJCkDnzmyrrxdiQkn3P/ONKghxktv64upQNTtuVT86s
JkiXYkldniEKdCcYbZ3rCPK4v6aU5A8KnLRgleZ63L+62RJtioIDP2Xf3cCm
P/Frdh+kYM+uYnddSYJMTqs+XtNNwQq6b1v8BoL8fMXrZmQjbh+jH6gkQ5CW
+1/3chdQ8JwS62VvJMhjok4Suk8pGJ2oOaGiQJDn2/44BeRRED0j6ueNnWWn
1zb4mIK0J3Ji49gL1tXvq9MpcH6XlTmmSJAFpq0lUbcpeDXo0/RVmSBreAKn
IA7Hh+kCERWC7K4R1ZyJoUDMQWeNFTbvHucCj2gKQm18Qt9iH9ndl2UWQcFn
671pGZsIUnj76G3+IDyf0l4HKzW8f7NxzYYBFJiU7SgKw9Yr0RAK8cP+aJP0
EttLK+jakDcFi3sl59aoE2SVxvzFxpMUVLgWbenGDlLmPxPrREGuVVugpQZB
3viR/6R2PwV68nqnz2Nn5FpRiw4UbHOyHn6E/XHjbTdfWwrutbFiZ7EVZMWc
91lQMKFm5fxgC0F2SGw0EdlJQfbxdZJtmgTZMHs+0H4HBWYFQatnsUvbGx4l
6FCQ7jCQLrGVIO/FeXOs0cLx6F4nj2E704oZEmoUfA/yqKGwzft4qEObKLj/
66Y5nxZBbq9wEn2gTEGgxfMjithrz8/7SSlQ8MLqiKEHdvdPIxV5KQocH6Qx
v2N/qEt0PilJQcjS7rl57DdZ1NWcdTh/KhazxbUJMtX1BlNJHK/vM++XttiH
W1vT1EQoGNu3WFyO/b302AodgoLOWn+/i9sIsjnp5S46NwUyeYLVCdhkwBLv
Mk4K9Ik9+XnYD1WfNOxcQNCgO7utHftYxvhlg2kEkRf8reR1CNL2omHR5d8I
tL5PmupgG7gkfK+aQDAyPPzVAltGVGenyRiCcamXDB/swWuXpizYCD563ggr
wv7s3iJ7EyG4klejVIldZShr18RE8Idhe+oTdtZ8bYFNPwJvk8b8EezETrHe
W98RfDL/VTCHfeW1l0BrL4JimXazpdsJ0v3sMk+HLgSHD5oYyGI7Wh1NSuxA
QNPlf6iObaz8ovrLFwRTv/8k6mJvZDpKO39GIDbVYGqHvaYyx+Z+C4KXZX20
w9i8D/5c6G7G/TvdOuCBTR1I6zrciKBojUJtMLZZNEuJ/h4BcAo/isR+Uq5K
T6hHECKURYvF5h8Lqn9ei8CeRhtKwj4tDWs+VCOwyNnnlI7daM/jgd4h4C9/
bpmDrRpl/ZqrEkG+o2FNAfbYz28OOhUIHL9esSzH3rdeIcv+DYLPwf85vcMu
svGd9CnF49WQGa7DFrlcYhhdgiCnI5OnCTvgFced7GI8X0vJ3BbsNmTa//Yl
glCPF5/asbXEb23uKULwnCc8rBM70bLj0sxzBClEfkkP9vQFqWaRAgT9urbn
vmMfKPSUVHuKoDwqobwfu2Sg0Ns8DwEHmRg9iC0m+qf8RC4CYQjqY2LTTQ0E
wx7j/g85Agu7i37dJSULgXGgoxzC1n3akvf6Ec6fniSRf079Jv635SGC2DM7
rv9rv7DCzXzkAQLG/NFr/+K5GuXd5UtDUHBcZcW//sigCUo2BcHS/8qk/o1H
KnfHNv17OH+Wq5d9ww7vuhx1MBmvN1deTzf2gOCH9qBEBMek917rwDbSXyl/
Ox6BnrF2RRt2lp9L4NPbCIINrod8wl6SlVlVF4dg70/3qg/YJ78MiQzGIIhY
OZJQi13Ht9Vt8QaC6Fv642+xFXVDi8SjEZzeerG9DPu6dzWn1jUEtS0Ne15h
/0wX3LcvCkHXDqNdz7AtWx3ST0fieAYC77Kxhbax9B6FIRD05j+ViO1zSjWm
4iKCQs2Imzexm1OCejpCEfh3N+2IwL7NyROynI73S+iQji/2xBbr98rncXvt
/qsnsO3dk8RNghAYXHzj5oy96v1GRqgfgoWMiTID7KB5H967vvh8i9/W0cJu
VyvZ/9IbQc9ZXkNF7OR406kfpxDILc7MCmJLHPbccsANgZr23r//zmdoXGG4
/1EEyxeEut5i91bOfopxRVCXlm5SiJ2+8bpv9UEETvsLamOwZcefPNWwRxAw
0eNuhB0vd8nB2xbB5Oc2mgY2t7PDfK4N3n8Bm12S2P2Vi5ZSexG836R+febf
fRRvP7TMGI93ypWejb28XjHewgivn5nyYhz2pfmFHVEGCOLNDaSCsY+450Yv
6CFIWni90wp7/bYFpWFtBBoF4Z2j+D6MOd3aoqCFIGzay/IL9nx6Dv24JoJe
zVMuFdjdfHYNXeoIZlWW7o/Gvt/12LNBEYHO/mTGBuw1F/flPF6L4BCMmOng
+/jqC3mbATEENTJjOeLY0+jv9Po1CCinxMd/8f3fbpNtkrgSn2999Yg32AnS
f1kRggh+C20p18EWrsmUO7bIggvRuobS+H0RFJzJkBhgwaGIuD35mwlyJPGd
l0YfC8Z/bdK8gN20IVbT9BsLiCDJV9bYMZryNf5dLJANO+c9jt/D5S727IZW
FmQKmFWqYQvnPVf7r4oF9Q+/8Car4vGbeb5py2LBTiH53tX4PZ9p0Yz8+YgF
cnHxNt1K+P1z4bDizGDBx6NzB9Kx7/kmfVNJY0HviKLKRuy1ydVcEYks8Dwn
/k0N1wfrkZSZRhQLGoL04jbhekMmsrMtxoMFSpX3WZ3SOD9UHGOfurPgYrjQ
ozvYyZ8/mX44zoKE4sI5C2wB2foyvqMs0DYajSqTIsipytcPI5xYYH1mGWci
rm/qORLO0M1Z0NMsH78N10M+IdaEuwoLdgeWjmqKEWSZf5XmzjEm0DIVacuF
CDJiXaNxyAgTQo0kdV8LEqRVbduBsiEmkMKhMoexv4ujEB02E17blXPkCRAk
rZKvems/E+jiJ6b1cf1nudzaQfUzExwYU8xDvATZk98RKFnChMxk/b0uXAS5
yBwp5rzEhINxaad9cP26jTnMFr/ABNPto0OzuL71GxyS0AxhwiXzJSsjsFn9
P8LdzzPBaqzXMWmCRjZ9Y1m992XCQmRqIWOcRqZ09LLijzLBqcKjaXgYx2ts
ElUwZEL5o187V7JopO/LZ0FWS5igLjzJONxGI2OWFDgVxg9C9LreDUVFNFL1
Y7GHjdwgTPBED1y+QSP/Tti9Opc/AHV9VStzD9PIgJTNcq92DIBcz8fycTUa
Kf4ws4X+th9MFYxjd89ykwYSkvkhZv0wGXnO+zlwk6vXdubEd/RBrOkW4ZIr
3KRYkNKA5pE+EJe4YR+1h5ustS/T/znyHYb4Y55lEtxkRmxfl2LAd1hm8Yxu
VM5FzoetNzab/gZrWexXyv5c5LKhP+Jeot8g5oq2aYAyFxksxOWVKt0LYnma
IoudnKT+tuucc3o9QBfxY5y9yUnyWUuNtbh2Qyue2vZdnKTK+gGn0jNdILdE
eZxGcZA5k3JLm6I7obeEnhkez0FeuHxn66/EDrA7GyFQrc1BHlhcxojJ/gqd
4SLNoq8WITpc8PL+mi8QOr7nyBnuRVhTsbVOvbUdZhYCRRv1FmCB45ud1lgb
XD6vfi378jxQ6knaL1e0QdIptgW7bg5UxOiJBhs+Qyl9Q+/rP3+hnrd3x7xe
K1jf+2skqv0XyOenXerMWyBdtC4wzvUPLD8S8g7cP4EA70U3xTuzcHzuXrha
VDMIrrdg99XOgGxG3X+uih9BMOWFsS41DZudDwWXHG+Exyd9eFNXTsNEuIm/
Bv09HHnj81tTZQreRFqvTU2uh8qvOeVzRr9BO8nJ5siXWkh8vyvj4alJcBdj
BBuNVQN/vLANLXgCTJ6Ia4YpVsHmWfhSkPwL1FfdS3nmVQlpRSeN3UrGoXHM
++9cFAlPD0hXuVaOgXZxdJPJtXJ4cG6469XLUeA4+FT02n/loC/sr3onfxQa
FpsON3iWg+uDURnfzFE4bCY8amleDo11rGmF+FG40p28zJa/HHZ1hBol+o9C
O1e2jcvNNxCb3xLoqjEKgdZki++tMgg4qH4iv2AE9Cb7xIvCysDuTr30hccj
wHuX223ibBmI28hEWD8YgZR+44lA2zKojtisMR4zAlWBjSLBImWQJ+Cpq+49
AitTOu0jE0qhsrdaKFVlBHr151JqIkuB9HLm95QdgRzmOiZPUCkYya3M15QY
AV21o4HXHUuh1Wh5ZwP/CByvRAmxq0vBcncX9evHMKie5Ott5imFW3pmPG/6
h2GGX1leeIYBQy+EGiI6h+GGg3dx/FcGLCoxdFc1DIPjn9iFtjoG3K54MtT9
dhg2PCg0Xs1gwPCwwO5MxjD8MGyNOZDLgHpOlo5X4TC8oCbb795lQJWB7pfN
ucPwP+Vn+WA=
      "]]}}, InsetBox[
    RowBox[{"\[Theta]", "=", 
     RowBox[{"+", "1"}]}], {-0.9727915194346288, -0.5272589601211508}, {
    Left, Baseline},
    Alignment->{Left, Top}]},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{-1., 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(u\\), \\(g\\)]\\) (V)\"", FontSize -> 20, 
      StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(I\\), \\(d\\)]\\) (\[Mu]A)\"", FontSize -> 
      20, StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, {{-4, 
      FormBox[
       RowBox[{"-", "4"}], TraditionalForm]}, {-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImagePadding->{{52., 25.}, {55., 24.}},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{-1., 0.1}, {-3.2, 0.5}},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic]], "Input",
 CellChangeTimes->{{3.920249208725293*^9, 3.9202492145102873`*^9}}]
},
WindowSize->{1148, 681},
WindowMargins->{{322, Automatic}, {114, Automatic}},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{595.1999999999999, 841.98}},
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (November 20, 2012)",
StyleDefinitions->FrontEnd`FileName[{"Article"}, "JournalArticle.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 86, 1, 23, "Text"],
Cell[646, 23, 84, 1, 23, "Text"],
Cell[CellGroupData[{
Cell[755, 28, 48234, 787, 516, "Input"],
Cell[48992, 817, 9390, 165, 292, "Output"],
Cell[58385, 984, 13287, 230, 298, "Output"]
}, Open  ]],
Cell[71687, 1217, 84, 1, 23, "Text"],
Cell[71774, 1220, 55068, 924, 708, "Input"],
Cell[126845, 2146, 20751, 412, 300, InheritFromParent],
Cell[147599, 2560, 19896, 398, 300, InheritFromParent],
Cell[167498, 2960, 16344, 294, 300, InheritFromParent],
Cell[183845, 3256, 20744, 412, 300, InheritFromParent],
Cell[204592, 3670, 55199, 926, 708, "Input"],
Cell[259794, 4598, 13693, 296, 292, InheritFromParent],
Cell[273490, 4896, 10051, 189, 292, InheritFromParent],
Cell[283544, 5087, 10133, 192, 292, InheritFromParent],
Cell[293680, 5281, 18777, 380, 292, InheritFromParent],
Cell[312460, 5663, 15354, 278, 292, InheritFromParent]
}
]
*)

(* End of internal cache information *)
